/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.immutable;

import java.util.HashSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassSimDef {
    int methodCount;
    int fieldCount;
    byte[] bytes;
    HashSet<String> refFieldSet;
    HashSet<String> refMtdSet;

    public ClassSimDef(byte[] bytes, HashSet<String> refFieldSet, HashSet<String> refMtdSet) {
        this.bytes = bytes;
        this.refFieldSet = refFieldSet;
        this.refMtdSet = refMtdSet;
        this.init();
    }

    public void init() {
        this.methodCount = 0;
        this.fieldCount = 0;
        ClassReader cr = new ClassReader(this.bytes);
        ClassVisitor cv = new ClassVisitor(262144){
            String className;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String mtdName, String mtdDesc, String mtdSig, String[] exceptions) {
                String defMtd = this.className + ":" + mtdName + ":" + mtdDesc;
                if (!ClassSimDef.this.refMtdSet.contains(defMtd)) {
                    ClassSimDef.this.refMtdSet.add(defMtd);
                    ++ClassSimDef.this.methodCount;
                }
                MethodVisitor mv = super.visitMethod(access, mtdName, mtdDesc, mtdSig, exceptions);
                mv = new MethodVisitor(262144, mv){

                    public void visitFieldInsn(int opcode, String owner, String fName, String fDesc) {
                        String invokeField = owner + ":" + fName + ":" + fDesc;
                        if (!ClassSimDef.this.refFieldSet.contains(invokeField)) {
                            ClassSimDef.this.refFieldSet.add(invokeField);
                            ++ClassSimDef.this.fieldCount;
                        }
                        super.visitFieldInsn(opcode, owner, fName, fDesc);
                    }

                    public void visitMethodInsn(int opcode, String owner, String mName, String mDesc) {
                        String invokeMtd = owner + ":" + mName + ":" + mDesc;
                        if (!ClassSimDef.this.refMtdSet.contains(invokeMtd)) {
                            ClassSimDef.this.refMtdSet.add(invokeMtd);
                            ++ClassSimDef.this.methodCount;
                        }
                        super.visitMethodInsn(opcode, owner, mName, mDesc);
                    }
                };
                return mv;
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                String fieldDesc = this.className + ":" + name + ":" + desc;
                if (!ClassSimDef.this.refFieldSet.contains(fieldDesc)) {
                    ClassSimDef.this.refFieldSet.add(fieldDesc);
                    ++ClassSimDef.this.fieldCount;
                }
                return super.visitField(access, name, desc, signature, value);
            }
        };
        cr.accept(cv, 0);
    }
}

