/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher.util;

import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dx.instruction.InstructionReader;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.android.dx.instruction.ShortArrayCodeInput;
import com.tencent.tinker.build.util.DexClassesComparator;
import com.tencent.tinker.commons.dexpatcher.DexPatcherLogger;
import java.io.EOFException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ChangedClassesDexClassInfoCollector {
    private static final String TAG = "ChangedClassesDexClassInfoCollector";
    private static final DexPatcherLogger LOGGER = new DexPatcherLogger();
    private final Set<String> excludedClassPatterns = new HashSet<String>();
    private boolean includeRefererToRefererAffectedClasses = false;

    public ChangedClassesDexClassInfoCollector setExcludedClassPatterns(Collection<String> loaderClassPatterns) {
        this.excludedClassPatterns.clear();
        this.excludedClassPatterns.addAll(loaderClassPatterns);
        return this;
    }

    public ChangedClassesDexClassInfoCollector clearExcludedClassPatterns() {
        this.excludedClassPatterns.clear();
        return this;
    }

    public ChangedClassesDexClassInfoCollector setLogger(DexPatcherLogger.IDexPatcherLogger loggerImpl) {
        LOGGER.setLoggerImpl(loggerImpl);
        return this;
    }

    public ChangedClassesDexClassInfoCollector setIncludeRefererToRefererAffectedClasses(boolean enabled) {
        this.includeRefererToRefererAffectedClasses = enabled;
        return this;
    }

    public Set<DexClassesComparator.DexClassInfo> doCollect(DexClassesComparator.DexGroup oldDexGroup, DexClassesComparator.DexGroup newDexGroup) {
        HashSet<String> classDescsInResult = new HashSet<String>();
        HashSet<DexClassesComparator.DexClassInfo> result = new HashSet<DexClassesComparator.DexClassInfo>();
        DexClassesComparator dexClassCmptor = new DexClassesComparator("*");
        dexClassCmptor.setCompareMode(0);
        dexClassCmptor.setIgnoredRemovedClassDescPattern(this.excludedClassPatterns);
        dexClassCmptor.setLogger(LOGGER.getLoggerImpl());
        dexClassCmptor.startCheck(oldDexGroup, newDexGroup);
        result.addAll(dexClassCmptor.getAddedClassInfos());
        Collection<DexClassesComparator.DexClassInfo[]> changedClassInfos = dexClassCmptor.getChangedClassDescToInfosMap().values();
        for (DexClassesComparator.DexClassInfo[] oldAndNewInfoPair : changedClassInfos) {
            DexClassesComparator.DexClassInfo newClassInfo = oldAndNewInfoPair[1];
            LOGGER.i(TAG, "Add class %s to changed classes dex.", new Object[]{newClassInfo.classDesc});
            result.add(newClassInfo);
        }
        for (DexClassesComparator.DexClassInfo classInfo : result) {
            classDescsInResult.add(classInfo.classDesc);
        }
        if (this.includeRefererToRefererAffectedClasses) {
            dexClassCmptor.setCompareMode(1);
            dexClassCmptor.startCheck(oldDexGroup, newDexGroup);
            Set<String> referrerAffectedChangedClassDescs = dexClassCmptor.getChangedClassDescToInfosMap().keySet();
            Set<DexClassesComparator.DexClassInfo> oldClassInfos = oldDexGroup.getClassInfosInDexesWithDuplicateCheck();
            for (DexClassesComparator.DexClassInfo oldClassInfo : oldClassInfos) {
                if (classDescsInResult.contains(oldClassInfo.classDesc) || !this.isClassReferToAnyClasses(oldClassInfo, referrerAffectedChangedClassDescs)) continue;
                LOGGER.i(TAG, "Add class %s in old dex to changed classes dex since it is affected by modified referee.", new Object[]{oldClassInfo.classDesc});
                result.add(oldClassInfo);
            }
        }
        return result;
    }

    private boolean isClassReferToAnyClasses(DexClassesComparator.DexClassInfo classInfo, Set<String> refereeClassDescs) {
        if (classInfo.classDef.classDataOffset == 0) {
            return false;
        }
        ClassData classData = classInfo.owner.readClassData(classInfo.classDef);
        for (ClassData.Method method : classData.directMethods) {
            if (!this.isMethodReferToAnyClasses(classInfo, method, refereeClassDescs)) continue;
            return true;
        }
        for (ClassData.Method method : classData.virtualMethods) {
            if (!this.isMethodReferToAnyClasses(classInfo, method, refereeClassDescs)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodReferToAnyClasses(DexClassesComparator.DexClassInfo classInfo, ClassData.Method method, Set<String> refereeClassDescs) {
        if (method.codeOffset == 0) {
            return false;
        }
        Code methodCode = classInfo.owner.readCode(method);
        InstructionReader ir = new InstructionReader(new ShortArrayCodeInput(methodCode.instructions));
        ReferToClassesCheckVisitor rtcv = new ReferToClassesCheckVisitor(classInfo.owner, method, refereeClassDescs);
        try {
            ir.accept((InstructionVisitor)rtcv);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return rtcv.isReferToAnyRefereeClasses;
    }

    private static class ReferToClassesCheckVisitor
    extends InstructionVisitor {
        private final Dex owner;
        private final ClassData.Method method;
        private final Collection<String> refereeClassDescs;
        private boolean isReferToAnyRefereeClasses = false;

        ReferToClassesCheckVisitor(Dex owner, ClassData.Method method, Collection<String> refereeClassDescs) {
            super(null);
            this.owner = owner;
            this.method = method;
            this.refereeClassDescs = refereeClassDescs;
        }

        public void visitZeroRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal) {
            this.processIndexByType(index, indexType);
        }

        public void visitOneRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a) {
            this.processIndexByType(index, indexType);
        }

        public void visitTwoRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b) {
            this.processIndexByType(index, indexType);
        }

        public void visitThreeRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c) {
            this.processIndexByType(index, indexType);
        }

        public void visitFourRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d) {
            this.processIndexByType(index, indexType);
        }

        public void visitFiveRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d, int e) {
            this.processIndexByType(index, indexType);
        }

        public void visitRegisterRangeInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int registerCount) {
            this.processIndexByType(index, indexType);
        }

        private void processIndexByType(int index, int indexType) {
            MethodId methodId;
            String typeName = null;
            String refInfoInLog = null;
            switch (indexType) {
                case 2: {
                    typeName = (String)this.owner.typeNames().get(index);
                    refInfoInLog = "init referrer-affected class";
                    break;
                }
                case 5: {
                    FieldId fieldId = (FieldId)this.owner.fieldIds().get(index);
                    typeName = (String)this.owner.typeNames().get(fieldId.declaringClassIndex);
                    refInfoInLog = "referencing to field: " + (String)this.owner.strings().get(fieldId.nameIndex);
                    break;
                }
                case 4: {
                    methodId = (MethodId)this.owner.methodIds().get(index);
                    typeName = (String)this.owner.typeNames().get(methodId.declaringClassIndex);
                    refInfoInLog = "invoking method: " + this.getMethodProtoTypeStr(methodId);
                    break;
                }
            }
            if (typeName != null && this.refereeClassDescs.contains(typeName)) {
                methodId = (MethodId)this.owner.methodIds().get(this.method.methodIndex);
                LOGGER.i(ChangedClassesDexClassInfoCollector.TAG, "Method %s in class %s referenced referrer-affected class %s by %s", new Object[]{this.getMethodProtoTypeStr(methodId), this.owner.typeNames().get(methodId.declaringClassIndex), typeName, refInfoInLog});
                this.isReferToAnyRefereeClasses = true;
            }
        }

        private String getMethodProtoTypeStr(MethodId methodId) {
            short[] paramTypeIds;
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append((String)this.owner.strings().get(methodId.nameIndex));
            ProtoId protoId = (ProtoId)this.owner.protoIds().get(methodId.protoIndex);
            strBuilder.append('(');
            for (short typeId : paramTypeIds = this.owner.parameterTypeIndicesFromMethodId(methodId)) {
                strBuilder.append((String)this.owner.typeNames().get(typeId));
            }
            strBuilder.append(')').append((String)this.owner.typeNames().get(protoId.returnTypeIndex));
            return strBuilder.toString();
        }
    }
}

