/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.aapt;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String BLANK = "";
    public static final String SPACE = " ";
    public static final String NULL = "null";
    public static final String CRLF_STRING = "\r\n";
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte[] CRLF = new byte[]{13, 10};
    private static final String METCH_PATTERN_REGEX = "[\\*]+";
    private static final String METCH_PATTERN = "*";
    private static final String METCH_PATTERN_REPLACEMENT = "[\\\\S|\\\\s]*";
    private static final String ZERO = "0";

    private StringUtil() {
    }

    public static String trim(String string) {
        String result = null;
        result = string == null ? BLANK : string.trim();
        return result;
    }

    public static String nullToBlank(String string) {
        return string == null ? BLANK : string;
    }

    public static String[] nullToBlank(String[] stringArray) {
        String[] result = stringArray;
        if (stringArray == null) {
            result = new String[]{};
        }
        return result;
    }

    public static boolean isBlank(String string) {
        int strLen;
        boolean result = false;
        if (string == null || (strLen = string.length()) == 0) {
            result = true;
        } else {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(string.charAt(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean isNotBlank(String string) {
        return !StringUtil.isBlank(string);
    }

    public static String[] compareString(String[] stringArray1, String[] stringArray2) {
        String[] differentString = null;
        if (stringArray1 != null && stringArray2 != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < stringArray1.length; ++i) {
                boolean sign = false;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray1[i].equals(stringArray2[j])) continue;
                    sign = true;
                    break;
                }
                if (sign) continue;
                list.add(stringArray1[i]);
            }
            differentString = new String[list.size()];
            differentString = list.toArray(differentString);
        }
        return differentString;
    }

    public static boolean isMatchPattern(String string, String patternString) {
        boolean result = false;
        if (string != null && patternString != null) {
            if (patternString.indexOf(METCH_PATTERN) >= 0) {
                String matchPattern = "^" + patternString.replaceAll(METCH_PATTERN_REGEX, METCH_PATTERN_REPLACEMENT) + "$";
                result = StringUtil.isMatchRegex(string, matchPattern);
            } else if (string.equals(patternString)) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isMatchRegex(String string, String regex) {
        boolean result = false;
        if (string != null && regex != null) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(string);
            result = matcher.find();
        }
        return result;
    }

    public static List<String> parseRegexGroup(String string, String regex) {
        ArrayList<String> groupList = null;
        if (string != null && regex != null) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(string);
            int groupCount = matcher.groupCount();
            groupList = new ArrayList<String>();
            if (matcher.find()) {
                for (int count = 1; count <= groupCount; ++count) {
                    groupList.add(matcher.group(count));
                }
            }
        }
        return groupList;
    }

    public static List<String> parseStringGroup(String string, String regex, String firstRegex, String firstRegexReplace, int lastRegexStringLength) {
        ArrayList<String> list = null;
        if (string != null) {
            list = new ArrayList<String>();
            int lastRegexLength = lastRegexStringLength < 0 ? 0 : lastRegexStringLength;
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(string);
            String group = null;
            int start = 0;
            while (matcher.find(start)) {
                start = matcher.end();
                group = matcher.group();
                group = group.replaceFirst(firstRegex, firstRegexReplace);
                group = group.substring(0, group.length() - lastRegexLength);
                list.add(group);
            }
        }
        return list;
    }

    public static String byteToHexString(byte[] byteArray) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            int byteCode = byteArray[i] & 0xFF;
            if (byteCode < 16) {
                builder.append(0);
            }
            builder.append(Integer.toHexString(byteCode));
        }
        return builder.toString();
    }

    public static byte[] hexStringToByte(String source) {
        byte[] bytes = null;
        if (source != null) {
            bytes = new byte[source.length() / 2];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)Integer.parseInt(source.substring(i * 2, (i + 1) * 2), 16);
            }
        }
        return bytes;
    }

    public static String fillZero(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(ZERO);
        }
        return stringBuilder.toString();
    }

    public static int stringMod(String string, int mod) {
        int hashCode = 0;
        if (string != null && (hashCode = string.hashCode()) < 0) {
            hashCode = (hashCode = Math.abs(hashCode)) < 0 ? 0 : hashCode;
        }
        return hashCode % (mod > 0 ? mod : 1);
    }
}

