/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.aapt;

import com.tencent.tinker.build.aapt.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class FileUtil {
    private FileUtil() {
    }

    public static boolean isExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static void createDirectory(String directoryPath) {
        File file = new File(directoryPath);
        if (!file.exists()) {
            file.setReadable(true, false);
            file.setWritable(true, true);
            file.mkdirs();
        }
    }

    public static boolean createFile(String fullFilename) {
        boolean result = false;
        File file = new File(fullFilename);
        FileUtil.createDirectory(file.getParent());
        try {
            file.setReadable(true, false);
            file.setWritable(true, true);
            result = file.createNewFile();
        }
        catch (Exception e) {
            throw new FileUtilException(e);
        }
        return result;
    }

    public static List<String> findMatchFile(String sourceDirectory, String fileSuffix) {
        return FileUtil.findMatchFileOrMatchFileDirectory(sourceDirectory, fileSuffix, null, true, true);
    }

    private static List<String> findMatchFileOrMatchFileDirectory(String sourceDirectory, String fileSuffix, String somethingAppendToRear, boolean isFindMatchFile, boolean includeHidden) {
        fileSuffix = StringUtil.nullToBlank(fileSuffix);
        somethingAppendToRear = StringUtil.nullToBlank(somethingAppendToRear);
        ArrayList<String> list = new ArrayList<String>();
        File sourceDirectoryFile = new File(sourceDirectory);
        ConcurrentLinkedQueue<File> queue = new ConcurrentLinkedQueue<File>();
        queue.add(sourceDirectoryFile);
        while (!queue.isEmpty()) {
            File file = (File)queue.poll();
            if (file.isHidden() && !includeHidden) continue;
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                queue.addAll(Arrays.asList(fileArray));
                continue;
            }
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(fileSuffix.toLowerCase())) continue;
            if (isFindMatchFile) {
                list.add(file.getAbsolutePath() + somethingAppendToRear);
                continue;
            }
            String parentPath = file.getParent();
            if (list.contains(parentPath = parentPath + somethingAppendToRear)) continue;
            list.add(parentPath);
        }
        return list;
    }

    public static class FileUtilException
    extends RuntimeException {
        private static final long serialVersionUID = 3884649425767533205L;

        public FileUtilException(Throwable cause) {
            super(cause);
        }
    }
}

