/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.logutils;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import com.tencent.qcloud.logutils.LogActivity;
import com.tencent.qcloud.logutils.OnLogListener;
import com.tencent.qcloud.logutils.R;
import java.io.File;
import java.util.ArrayList;

public class LogServer
implements Application.ActivityLifecycleCallbacks,
View.OnClickListener {
    private static String TAG = LogServer.class.getSimpleName();
    private int activeActivityCount = 0;
    private boolean isAppForeground = false;
    private Application application;
    private ClipboardManager clipboardManager;
    protected static final String FILE_PARENT_PATH_KEY = "FILE_PARENT_PATH";
    protected static final String FILE_NAME_KEY = "FILE_NAME";
    private OnLogListener onLogListener;
    private Context currentContext;
    private AlertDialog alertDialog;
    private static final String KEY_LOG = "##qcloud-cos-log-ispct##";

    public LogServer(Context context) {
        this.application = (Application)context.getApplicationContext();
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.clipboardManager = (ClipboardManager)this.application.getSystemService("clipboard");
        this.createAlertDialog(context);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        ++this.activeActivityCount;
        if (!this.isAppForeground) {
            this.isAppForeground = true;
            Log.d((String)TAG, (String)"background to foreground");
            if (this.clipboardManager != null && this.clipboardManager.hasPrimaryClip()) {
                ClipData clipData = this.clipboardManager.getPrimaryClip();
                if (clipData == null) {
                    return;
                }
                ClipData.Item item = clipData.getItemAt(0);
                if (item == null) {
                    return;
                }
                CharSequence content = item.getText();
                if (content == null) {
                    return;
                }
                content = content.toString().trim();
                Log.d((String)TAG, (String)("clip content: " + content));
                if (KEY_LOG.equals(content)) {
                    Log.d((String)TAG, (String)"hit it");
                    this.clipboardManager.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)""));
                    this.currentContext = activity;
                    this.tipsDialog();
                }
            }
        }
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        --this.activeActivityCount;
        if (this.activeActivityCount < 0) {
            this.activeActivityCount = 0;
        }
        if (this.activeActivityCount == 0) {
            this.isAppForeground = false;
            Log.d((String)TAG, (String)"foreground switch background");
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.yesId) {
            this.showLog((Context)(this.currentContext == null ? this.application : this.currentContext));
        }
    }

    public void setOnLogListener(OnLogListener onLogListener) {
        Log.d((String)TAG, (String)"setOnLogListener");
        this.onLogListener = onLogListener;
    }

    public void destroy() {
        Log.d((String)TAG, (String)"destroy");
        if (this.application != null) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    private void tipsDialog() {
        if (this.alertDialog != null && !this.alertDialog.isShowing()) {
            this.alertDialog.show();
        }
    }

    private void showLog(Context context) {
        Intent intent = new Intent();
        File[] files = null;
        if (this.onLogListener != null) {
            files = this.onLogListener.onLoad();
        }
        ArrayList<String> fileNameList = null;
        String parentPath = null;
        if (files != null && files.length > 0) {
            fileNameList = new ArrayList<String>();
            parentPath = files[0].getParent();
            for (File file : files) {
                fileNameList.add(file.getName());
            }
        }
        Bundle bundle = new Bundle();
        bundle.putString(FILE_PARENT_PATH_KEY, parentPath);
        bundle.putStringArrayList(FILE_NAME_KEY, fileNameList);
        intent.putExtras(bundle);
        intent.setClass(context, LogActivity.class);
        context.startActivity(intent);
    }

    private void createAlertDialog(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context).setTitle(R.string.dialog_title).setNegativeButton(R.string.no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LogServer.this.alertDialog.dismiss();
            }
        }).setPositiveButton(R.string.yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                LogServer.this.showLog((Context)(LogServer.this.currentContext == null ? LogServer.this.application : LogServer.this.currentContext));
                LogServer.this.alertDialog.dismiss();
            }
        });
        this.alertDialog = builder.create();
    }
}

