/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.logutils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.tencent.qcloud.logutils.R;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LogActivity
extends AppCompatActivity {
    private static String TAG = LogActivity.class.getSimpleName();
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private ListView listView;
    private static CustomerAdapter customerAdapter;

    protected void onCreate(Bundle savedInstanceState) {
        this.supportRequestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_log);
        this.findViewById(R.id.backId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogActivity.this.finish();
            }
        });
        this.listView = (ListView)this.findViewById(R.id.item_list);
        customerAdapter = new CustomerAdapter();
        this.mainHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = LogActivity.this.getIntent().getExtras();
                if (bundle != null) {
                    String parentPath = bundle.getString("FILE_PARENT_PATH", null);
                    ArrayList fileNameList = bundle.getStringArrayList("FILE_NAME");
                    LogActivity.this.initItems(parentPath, fileNameList);
                }
            }
        }, 30L);
        this.listView.setAdapter((ListAdapter)customerAdapter);
    }

    private void initItems(String parentPath, List<String> fileNameList) {
        if (fileNameList != null && parentPath != null) {
            customerAdapter.fileParentPath = parentPath;
            customerAdapter.items.addAll(fileNameList);
            customerAdapter.notifyDataSetChanged();
        }
    }

    private static class ViewHolder {
        private TextView filePathTextView;

        private ViewHolder() {
        }

        public void setViewOnClick(View.OnClickListener onClickListener) {
            this.filePathTextView.setOnClickListener(onClickListener);
        }
    }

    private class CustomerAdapter
    extends BaseAdapter {
        private List<String> items = new ArrayList<String>(20);
        private String fileParentPath;

        public int getCount() {
            return this.items.size();
        }

        public Object getItem(int position) {
            return this.items.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = LayoutInflater.from((Context)LogActivity.this).inflate(R.layout.item_log, null, false);
                viewHolder.filePathTextView = (TextView)convertView.findViewById(R.id.pathId);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            viewHolder.filePathTextView.setText((CharSequence)this.items.get(position));
            viewHolder.setViewOnClick(new View.OnClickListener(){

                public void onClick(View v) {
                    TextView textView = (TextView)v;
                    String filePath = CustomerAdapter.this.fileParentPath + File.separator + textView.getText().toString().trim();
                    CustomerAdapter.this.share(filePath);
                }
            });
            return convertView;
        }

        private void share(String filePath) {
            Intent fileIntent = new Intent("android.intent.action.SEND");
            fileIntent.setType("*/*");
            fileIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)filePath));
            LogActivity.this.startActivity(Intent.createChooser((Intent)fileIntent, (CharSequence)"\u5206\u4eab"));
        }
    }
}

