/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.CosXmlService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import com.tencent.cos.xml.model.object.CopyObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.UploadPartCopyRequest;
import com.tencent.cos.xml.model.object.UploadPartCopyResult;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CopyObjectService {
    private CosXmlService cosXmlService;
    private long maxSliceSize = 0x500000L;

    public CopyObjectService(CosXmlService cosXmlService) {
        this.cosXmlService = cosXmlService;
    }

    public CosXmlResult copyObject(String bucket, String cosPath, CopyObjectRequest.CopySourceStruct copySourceStruct) throws CosXmlClientException, CosXmlServiceException {
        long sourceLength = this.headObject(copySourceStruct.bucket, copySourceStruct.cosPath);
        if (sourceLength >= this.maxSliceSize) {
            return this.copyObjectForLargeFile(bucket, cosPath, copySourceStruct, sourceLength);
        }
        return this.copyObjectForSmallFile(bucket, cosPath, copySourceStruct);
    }

    public CosXmlResult copyObject(String bucket, String cosPath, CopyObjectRequest.CopySourceStruct copySourceStruct, long sourceObjectLength) throws CosXmlClientException, CosXmlServiceException {
        if (sourceObjectLength >= this.maxSliceSize) {
            return this.copyObjectForLargeFile(bucket, cosPath, copySourceStruct, sourceObjectLength);
        }
        return this.copyObjectForSmallFile(bucket, cosPath, copySourceStruct);
    }

    private long headObject(String bucket, String cosPath) throws CosXmlServiceException, CosXmlClientException {
        HeadObjectRequest headObjectRequest = new HeadObjectRequest(bucket, cosPath);
        HeadObjectResult headObjectResult = this.cosXmlService.headObject(headObjectRequest);
        if (headObjectResult != null) {
            String length = (String)((List)headObjectResult.headers.get("Content-Length")).get(0);
            return Long.valueOf(length);
        }
        return -1L;
    }

    private CopyObjectResult copyObjectForSmallFile(String bucket, String cosPath, CopyObjectRequest.CopySourceStruct copySourceStruct) throws CosXmlServiceException, CosXmlClientException {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(bucket, cosPath, copySourceStruct);
        return this.cosXmlService.copyObject(copyObjectRequest);
    }

    private CompleteMultiUploadResult copyObjectForLargeFile(String bucket, String cosPath, CopyObjectRequest.CopySourceStruct copySourceStruct, long sourceLength) throws CosXmlClientException, CosXmlServiceException {
        String uploadId = this.initMultiUpload(bucket, cosPath);
        LinkedHashMap<Integer, String> partNumberAndEtag = new LinkedHashMap<Integer, String>();
        int partNumber = 1;
        long start = 0L;
        long end = -1L;
        long sliceSize = this.maxSliceSize;
        while (end < sourceLength - 1L) {
            start = end + 1L;
            end = end + sliceSize >= sourceLength - 1L ? sourceLength - 1L : end + sliceSize;
            UploadPartCopyResult copyObjectResult = this.copyObjectForLargeFile(bucket, cosPath, partNumber, uploadId, copySourceStruct, start, end);
            partNumberAndEtag.put(partNumber, copyObjectResult.copyObject.eTag);
            ++partNumber;
        }
        CompleteMultiUploadResult completeMultiUploadResult = this.completeMultipart(bucket, cosPath, uploadId, partNumberAndEtag);
        return completeMultiUploadResult;
    }

    private String initMultiUpload(String bucket, String cosPath) throws CosXmlServiceException, CosXmlClientException {
        InitMultipartUploadRequest initMultipartUploadRequest = new InitMultipartUploadRequest(bucket, cosPath);
        InitMultipartUploadResult initMultipartUploadResult = this.cosXmlService.initMultipartUpload(initMultipartUploadRequest);
        String uploadId = initMultipartUploadResult.initMultipartUpload.uploadId;
        return uploadId;
    }

    private UploadPartCopyResult copyObjectForLargeFile(String bucket, String cosPath, int partNumber, String uploadId, CopyObjectRequest.CopySourceStruct copySourceStruct, long start, long end) throws CosXmlServiceException, CosXmlClientException {
        UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest(bucket, cosPath, partNumber, uploadId, copySourceStruct, start, end);
        return this.cosXmlService.copyObject(uploadPartCopyRequest);
    }

    private CompleteMultiUploadResult completeMultipart(String bucket, String cosPath, String uploadId, Map<Integer, String> partNumberAndEtag) throws CosXmlServiceException, CosXmlClientException {
        CompleteMultiUploadRequest completeMultiUploadRequest = new CompleteMultiUploadRequest(bucket, cosPath, uploadId, partNumberAndEtag);
        CompleteMultiUploadResult completeMultiUploadResult = this.cosXmlService.completeMultiUpload(completeMultiUploadRequest);
        return completeMultiUploadResult;
    }
}

