/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.util.Base64;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.utils.DigestUtils;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class ObjectRequest
extends CosXmlRequest {
    protected String cosPath;

    public ObjectRequest(String bucket, String cosPath) {
        this.bucket = bucket;
        this.cosPath = cosPath;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    @Override
    public String getPath(CosXmlServiceConfig config) {
        return config.getUrlPath(this.bucket, this.cosPath);
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        if (this.requestURL != null) {
            return;
        }
        if (this.bucket == null || this.bucket.length() < 1) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "bucket must not be null ");
        }
        if (this.cosPath == null || this.cosPath.length() < 1) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "cosPath must not be null ");
        }
    }

    public void setCOSServerSideEncryption() {
        this.addHeader("x-cos-server-side-encryption", "AES256");
    }

    public void setCOSServerSideEncryptionWithCustomerKey(String customerKey) throws CosXmlClientException {
        if (customerKey != null) {
            String base64ForKeyMd5;
            this.addHeader("x-cos-server-side-encryption-customer-algorithm", "AES256");
            this.addHeader("x-cos-server-side-encryption-customer-key", DigestUtils.getBase64(customerKey));
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                base64ForKeyMd5 = Base64.encodeToString((byte[])messageDigest.digest(customerKey.getBytes(Charset.forName("UTF-8"))), (int)2);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
            }
            this.addHeader("x-cos-server-side-encryption-customer-key-MD5", base64ForKeyMd5);
        }
    }

    public void setCOSServerSideEncryptionWithKMS(String customerKeyID, String json) throws CosXmlClientException {
        this.addHeader("x-cos-server-side-encryption", "cos/kms");
        if (customerKeyID != null) {
            this.addHeader("x-cos-server-side-encryption-cos-kms-key-id", customerKeyID);
        }
        if (json != null) {
            this.addHeader("x-cos-server-side-encryption-context", DigestUtils.getBase64(json));
        }
    }
}

