/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.util.Base64;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.common.COSStorageClass;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.common.MetaDataDirective;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.cos.xml.utils.URLEncodeUtils;
import com.tencent.qcloud.core.auth.STSCredentialScope;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CopyObjectRequest
extends ObjectRequest {
    private CopySourceStruct copySourceStruct;

    public CopyObjectRequest(String bucket, String cosPath, CopySourceStruct copySourceStruct) {
        super(bucket, cosPath);
        this.copySourceStruct = copySourceStruct;
    }

    public CopyObjectRequest() {
        super(null, null);
    }

    @Override
    public String getMethod() {
        return "PUT";
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        return RequestBodySerializer.bytes(null, (byte[])new byte[0]);
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.copySourceStruct == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "copy source must not be null");
        }
        this.copySourceStruct.checkParameters();
    }

    @Override
    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    @Override
    public STSCredentialScope[] getSTSCredentialScope(CosXmlServiceConfig config) {
        STSCredentialScope scope1 = new STSCredentialScope("name/cos:PutObject", config.getBucket(this.bucket), config.getRegion(), this.getPath(config));
        STSCredentialScope scope2 = new STSCredentialScope("name/cos:GetObject", this.copySourceStruct.bucket, this.copySourceStruct.region, this.copySourceStruct.cosPath);
        return STSCredentialScope.toArray((STSCredentialScope[])new STSCredentialScope[]{scope1, scope2});
    }

    private void setCopySource(CopySourceStruct copySource, CosXmlServiceConfig config) throws CosXmlClientException {
        this.copySourceStruct = copySource;
        if (this.copySourceStruct != null) {
            this.addHeader("x-cos-copy-source", this.copySourceStruct.getSource(config));
        }
    }

    @Override
    public String getHost(CosXmlServiceConfig config, boolean isSupportAccelerate) throws CosXmlClientException {
        String host = super.getHost(config, isSupportAccelerate);
        this.setCopySource(this.copySourceStruct, config);
        return host;
    }

    public CopySourceStruct getCopySource() {
        return this.copySourceStruct;
    }

    public void setCopyMetaDataDirective(MetaDataDirective metaDataDirective) {
        if (metaDataDirective != null) {
            this.addHeader("x-cos-metadata-directive", metaDataDirective.getMetaDirective());
        }
    }

    public void setCopyIfModifiedSince(String sourceIfModifiedSince) {
        if (sourceIfModifiedSince != null) {
            this.addHeader("x-cos-copy-source-If-Modified-Since", sourceIfModifiedSince);
        }
    }

    public void setCopyIfUnmodifiedSince(String sourceIfUnmodifiedSince) {
        if (sourceIfUnmodifiedSince != null) {
            this.addHeader("x-cos-copy-source-If-Unmodified-Since", sourceIfUnmodifiedSince);
        }
    }

    public void setCopyIfMatch(String eTag) {
        if (eTag != null) {
            this.addHeader("x-cos-copy-source-If-Match", eTag);
        }
    }

    public void setCopyIfNoneMatch(String eTag) {
        if (eTag != null) {
            this.addHeader("x-cos-copy-source-If-None-Match", eTag);
        }
    }

    public void setCopySourceServerSideEncryptionCustomerKey(String sourceKey) throws CosXmlClientException {
        if (sourceKey != null) {
            String base64ForKeyMd5;
            this.addHeader("x-cos-copy-source-server-side-encryption-customer-algorithm", "AES256");
            this.addHeader("x-cos-copy-source-server-side-encryption-customer-key", DigestUtils.getBase64(sourceKey));
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                base64ForKeyMd5 = Base64.encodeToString((byte[])messageDigest.digest(sourceKey.getBytes(Charset.forName("UTF-8"))), (int)2);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
            }
            this.addHeader("x-cos-copy-source-server-side-encryption-customer-key-MD5", base64ForKeyMd5);
        }
    }

    public void setCopySourceServerSideEncryptionKMS(String customerKeyID, String json) throws CosXmlClientException {
        this.addHeader("'x-cos-copy-source-server-side-encryption", "cos/kms");
        if (customerKeyID != null) {
            this.addHeader("x-cos-copy-source-server-side-encryption-cos-kms-key-id", customerKeyID);
        }
        if (json != null) {
            this.addHeader("x-cos-copy-source-server-side-encryption-context", DigestUtils.getBase64(json));
        }
    }

    public void setCosStorageClass(COSStorageClass cosStorageClass) {
        if (cosStorageClass != null) {
            this.addHeader("x-cos-storage-class", cosStorageClass.getStorageClass());
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.addHeader(key, value);
        }
    }

    public static class CopySourceStruct {
        public String appid;
        public String bucket;
        public String region;
        public String cosPath;
        public String versionId;

        public CopySourceStruct(String appid, String bucket, String region, String cosPath) {
            this.appid = appid;
            this.bucket = bucket;
            this.region = region;
            this.cosPath = cosPath;
        }

        public CopySourceStruct(String appid, String bucket, String region, String cosPath, String versionId) {
            this(appid, bucket, region, cosPath);
            this.versionId = versionId;
        }

        public void checkParameters() throws CosXmlClientException {
            if (this.bucket == null) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "copy source bucket must not be null");
            }
            if (this.cosPath == null) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "copy source cosPath must not be null");
            }
            if (this.appid == null) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "copy source appid must not be null");
            }
            if (this.region == null) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "copy source region must not be null");
            }
            this.cosPath = URLEncodeUtils.cosPathEncode(this.cosPath);
        }

        public String getSource(CosXmlServiceConfig config) throws CosXmlClientException {
            if (this.cosPath != null && !this.cosPath.startsWith("/")) {
                this.cosPath = "/" + this.cosPath;
            }
            String host = config.getHost(this.bucket, this.region, this.appid, false);
            String url = host + this.cosPath;
            if (this.versionId != null) {
                url = url + "?versionId=" + this.versionId;
            }
            return url;
        }
    }
}

