/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.transfer.ExRequestBodySerializer;
import com.tencent.cos.xml.utils.DateUtils;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.cos.xml.utils.GenerateGetObjectURLUtils;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PostObjectRequest
extends ObjectRequest {
    private FormStruct formStruct = new FormStruct();
    private CosXmlProgressListener progressListener;
    private long offset = -1L;
    private long contentLength = -1L;

    private PostObjectRequest(String bucket, String cosPath) {
        super(bucket, "/");
        this.formStruct.key = cosPath;
    }

    public PostObjectRequest(String bucket, String cosPath, String srcPath) {
        this(bucket, cosPath);
        this.formStruct.srcPath = srcPath;
    }

    public PostObjectRequest(String bucket, String cosPath, byte[] data) {
        this(bucket, cosPath);
        this.formStruct.data = data;
    }

    public PostObjectRequest(String bucket, String cosPath, InputStream inputStream) {
        this(bucket, cosPath);
        this.formStruct.inputStream = inputStream;
    }

    public void setRange(long offset, long contentSize) {
        this.offset = offset;
        this.contentLength = contentSize;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        if (this.formStruct.srcPath != null) {
            return ExRequestBodySerializer.multipart(this.formStruct.getFormParameters(), new File(this.formStruct.srcPath), this.offset, this.contentLength);
        }
        if (this.formStruct.data != null) {
            return ExRequestBodySerializer.multipart(this.formStruct.getFormParameters(), null, this.formStruct.data, this.offset, this.contentLength);
        }
        if (this.formStruct.inputStream != null) {
            try {
                File tmpFile = new File(CosXmlSimpleService.appCachePath, String.valueOf(System.currentTimeMillis()));
                if (!tmpFile.exists()) {
                    tmpFile.createNewFile();
                }
                return ExRequestBodySerializer.multipart(this.formStruct.getFormParameters(), tmpFile, this.formStruct.inputStream, this.offset, this.contentLength);
            }
            catch (IOException e) {
                throw new CosXmlClientException(e);
            }
        }
        return null;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.formStruct.key == null) {
            throw new CosXmlClientException("cosPath must not be null ");
        }
        this.formStruct.signature.checkParameters();
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public CosXmlProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setSecretIdAndKey(String secretId, String signKey, String keyTime) {
        this.formStruct.signature.secretId = secretId;
        this.formStruct.signature.signKey = signKey;
        this.formStruct.signature.keyTime = keyTime;
    }

    @Override
    public void setSign(long signDuration) {
        long startTime = System.currentTimeMillis() / 1000L;
        this.setSign(startTime, startTime + signDuration);
    }

    @Override
    public void setSign(long startTime, long endTime) {
        this.formStruct.signature.signTime = startTime + ";" + endTime;
    }

    public void setSign(long signDuration, Map<String, String> parameters, Map<String, String> headers) {
        long startTime = System.currentTimeMillis() / 1000L;
        this.setSign(startTime, startTime + signDuration, parameters, headers);
    }

    public void setSign(long startTime, long endTime, Map<String, String> parameters, Map<String, String> headers) {
        this.formStruct.signature.signTime = startTime + ";" + endTime;
        this.formStruct.signature.parameters = parameters;
        this.formStruct.signature.headers = headers;
    }

    @Override
    public void setSign(long signDuration, Set<String> parameters, Set<String> headers) {
        throw new IllegalArgumentException("need to invoke setSign(long, Map<String, String>,  Map<String, String>) or setSign(long)");
    }

    @Override
    public void setSign(long startTime, long endTime, Set<String> parameters, Set<String> headers) {
        throw new IllegalArgumentException("need to invoke setSign(long, long, Map<String, String>,  Map<String, String>)or setSign(long, long)");
    }

    public void setAcl(String acl) {
        this.formStruct.acl = acl;
    }

    public void setCacheControl(String cacheControl) {
        this.formStruct.headers.put("Cache-Control", cacheControl);
    }

    public void setContentType(String contentType) {
        this.formStruct.headers.put("Content-Type", contentType);
    }

    public void setContentDisposition(String contentDisposition) {
        this.formStruct.headers.put("Content-Disposition", contentDisposition);
    }

    public void setContentEncoding(String contentEncoding) {
        this.formStruct.headers.put("Content-Encoding", contentEncoding);
    }

    public void setExpires(String expires) {
        this.formStruct.headers.put("Expires", expires);
    }

    public void setHeader(String key, String value) {
        if (key != null && value != null) {
            this.formStruct.headers.put(key, value);
        }
    }

    public void setCustomerHeader(String key, String value) {
        if (key != null && value != null) {
            this.formStruct.customHeaders.put(key, value);
        }
    }

    public void setCosStorageClass(String cosStorageClass) {
        this.formStruct.xCosStorageClass = cosStorageClass;
    }

    public void setSuccessActionRedirect(String redirectHost) {
        this.formStruct.successActionRedirect = redirectHost;
    }

    public void setSuccessActionStatus(int successHttpCode) {
        this.formStruct.successActionStatus = String.valueOf(successHttpCode);
    }

    public void setPolicy(Policy policy) {
        this.formStruct.policy = policy;
    }

    public Map<String, String> testFormParameters() throws CosXmlClientException {
        return this.formStruct.getFormParameters();
    }

    public static class Policy {
        private String expiration;
        private JSONArray conditions = new JSONArray();

        public void setExpiration(long endTimeMills) {
            this.expiration = DateUtils.getFormatTime("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", endTimeMills);
        }

        public void setExpiration(String formatEndTime) {
            this.expiration = formatEndTime;
        }

        public void addConditions(String key, String value, boolean isPrefixMatch) throws CosXmlClientException {
            if (isPrefixMatch) {
                JSONArray content = new JSONArray();
                content.put((Object)"starts-with");
                content.put((Object)key);
                content.put((Object)value);
                this.conditions.put((Object)content);
            } else {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put(key, (Object)value);
                }
                catch (JSONException e) {
                    throw new CosXmlClientException(e);
                }
                this.conditions.put((Object)jsonObject);
            }
        }

        public void addContentConditions(int start, int end) {
            JSONArray content = new JSONArray();
            content.put((Object)"content-length-range");
            content.put(start);
            content.put(end);
            this.conditions.put((Object)content);
        }

        public String content() throws CosXmlClientException {
            JSONObject jsonObject = new JSONObject();
            try {
                if (this.expiration != null) {
                    jsonObject.put("expiration", (Object)this.expiration);
                }
                jsonObject.put("conditions", (Object)this.conditions);
                return jsonObject.toString();
            }
            catch (JSONException e) {
                throw new CosXmlClientException(e);
            }
        }
    }

    private class Signature {
        public Map<String, String> parameters;
        public Map<String, String> headers;
        public String signTime;
        public String secretId;
        public String signKey;
        public String keyTime;

        public Signature() {
            long startTime = System.currentTimeMillis() / 1000L;
            this.signTime = startTime + ";" + (startTime + 600L);
        }

        public void checkParameters() throws CosXmlClientException {
            if (this.secretId == null || this.signKey == null) {
                throw new CosXmlClientException("secretId or secretKey must not be null");
            }
        }

        public String getSign() throws CosXmlClientException {
            return GenerateGetObjectURLUtils.getSign("POST", "/", this.headers, this.parameters, this.signTime, this.keyTime, this.secretId, this.signKey);
        }
    }

    private class FormStruct {
        String acl;
        Map<String, String> headers = new LinkedHashMap<String, String>();
        String key;
        String successActionRedirect;
        String successActionStatus;
        Map<String, String> customHeaders = new LinkedHashMap<String, String>();
        String xCosStorageClass;
        Policy policy;
        Signature signature;
        String srcPath;
        byte[] data;
        InputStream inputStream;

        public FormStruct() {
            this.signature = new Signature();
        }

        public Map<String, String> getFormParameters() throws CosXmlClientException {
            LinkedHashMap<String, String> formParameters = new LinkedHashMap<String, String>();
            if (this.acl != null) {
                formParameters.put("Acl", this.acl);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                formParameters.put(entry.getKey(), entry.getValue());
            }
            formParameters.put("key", this.key);
            if (this.successActionRedirect != null) {
                formParameters.put("success_action_redirect", this.successActionRedirect);
            }
            if (this.successActionStatus != null) {
                formParameters.put("success_action_status", this.successActionStatus);
            }
            for (Map.Entry<String, String> entry : this.customHeaders.entrySet()) {
                formParameters.put(entry.getKey(), entry.getValue());
            }
            if (this.xCosStorageClass != null) {
                formParameters.put("x-cos-storage-class", this.xCosStorageClass);
            }
            formParameters.put("Signature", this.signature.getSign());
            if (this.policy != null) {
                formParameters.put("policy", DigestUtils.getBase64(this.policy.content()));
            }
            return formParameters;
        }
    }
}

