/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mmkv;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.lang.reflect.Method;
import java.util.List;

class MMKVProcessUtil {
    private static String currentProcessName = "";

    MMKVProcessUtil() {
    }

    public static String getCurrentProcessName(@NonNull Context context) {
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            return currentProcessName;
        }
        currentProcessName = MMKVProcessUtil.getCurrentProcessNameByApplication();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            return currentProcessName;
        }
        currentProcessName = MMKVProcessUtil.getCurrentProcessNameByActivityThread();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            return currentProcessName;
        }
        currentProcessName = MMKVProcessUtil.getCurrentProcessNameByActivityManager(context);
        return currentProcessName;
    }

    @NonNull
    private static String getCurrentProcessNameByApplication() {
        if (Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        return "";
    }

    @NonNull
    private static String getCurrentProcessNameByActivityThread() {
        String processName = "";
        try {
            Method declaredMethod = Class.forName("android.app.ActivityThread").getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object invoke = declaredMethod.invoke(null, new Object[0]);
            if (invoke instanceof String) {
                processName = (String)invoke;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return processName;
    }

    private static String getCurrentProcessNameByActivityManager(@NonNull Context context) {
        List runningAppList;
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am != null && (runningAppList = am.getRunningAppProcesses()) != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : runningAppList) {
                if (processInfo.pid != pid) continue;
                return processInfo.processName;
            }
        }
        return "";
    }
}

