/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.tencent.mm.opensdk.channel.MMessageActV2;
import com.tencent.mm.opensdk.channel.a.a;
import com.tencent.mm.opensdk.channel.a.b;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelbiz.AddCardToWXCardPackage;
import com.tencent.mm.opensdk.modelbiz.ChooseCardFromWXCardPackage;
import com.tencent.mm.opensdk.modelbiz.CreateChatroom;
import com.tencent.mm.opensdk.modelbiz.HandleScanResult;
import com.tencent.mm.opensdk.modelbiz.IWXChannelJumpInfo;
import com.tencent.mm.opensdk.modelbiz.JoinChatroom;
import com.tencent.mm.opensdk.modelbiz.OpenWebview;
import com.tencent.mm.opensdk.modelbiz.SubscribeMessage;
import com.tencent.mm.opensdk.modelbiz.SubscribeMiniProgramMsg;
import com.tencent.mm.opensdk.modelbiz.WXChannelBaseJumpInfo;
import com.tencent.mm.opensdk.modelbiz.WXChannelBind;
import com.tencent.mm.opensdk.modelbiz.WXChannelJumpMiniProgramInfo;
import com.tencent.mm.opensdk.modelbiz.WXChannelJumpUrlInfo;
import com.tencent.mm.opensdk.modelbiz.WXChannelOpenEvent;
import com.tencent.mm.opensdk.modelbiz.WXChannelOpenFeed;
import com.tencent.mm.opensdk.modelbiz.WXChannelOpenLive;
import com.tencent.mm.opensdk.modelbiz.WXChannelOpenProfile;
import com.tencent.mm.opensdk.modelbiz.WXChannelShareVideo;
import com.tencent.mm.opensdk.modelbiz.WXChannelStartLive;
import com.tencent.mm.opensdk.modelbiz.WXGetA8Key;
import com.tencent.mm.opensdk.modelbiz.WXInvoiceAuthInsert;
import com.tencent.mm.opensdk.modelbiz.WXLaunchMiniProgram;
import com.tencent.mm.opensdk.modelbiz.WXLaunchMiniProgramWithToken;
import com.tencent.mm.opensdk.modelbiz.WXLaunchWxaRedirectingPage;
import com.tencent.mm.opensdk.modelbiz.WXNontaxPay;
import com.tencent.mm.opensdk.modelbiz.WXOpenBusinessView;
import com.tencent.mm.opensdk.modelbiz.WXOpenBusinessWebview;
import com.tencent.mm.opensdk.modelbiz.WXOpenCustomerServiceChat;
import com.tencent.mm.opensdk.modelbiz.WXPayInsurance;
import com.tencent.mm.opensdk.modelbiz.WXPreloadMiniProgram;
import com.tencent.mm.opensdk.modelbiz.WXPreloadMiniProgramEnvironment;
import com.tencent.mm.opensdk.modelbiz.WXQRCodePay;
import com.tencent.mm.opensdk.modelmsg.GetMessageFromWX;
import com.tencent.mm.opensdk.modelmsg.LaunchFromWX;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.SendTdiAuth;
import com.tencent.mm.opensdk.modelmsg.ShowMessageFromWX;
import com.tencent.mm.opensdk.modelmsg.WXMiniProgramObject;
import com.tencent.mm.opensdk.modelmsg.WXStateSceneDataObject;
import com.tencent.mm.opensdk.modelmsg.WXTextObject;
import com.tencent.mm.opensdk.modelpay.JumpToOfflinePay;
import com.tencent.mm.opensdk.modelpay.PayResp;
import com.tencent.mm.opensdk.modelpay.WXJointPay;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.MMSharedPreferences;
import com.tencent.mm.opensdk.openapi.SendReqCallback;
import com.tencent.mm.opensdk.openapi.WXAPiSecurityHelper;
import com.tencent.mm.opensdk.openapi.WXApiImplComm;
import com.tencent.mm.opensdk.utils.ILog;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.d;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

class BaseWXApiImplV10
implements IWXAPI {
    protected static final String TAG = "MicroMsg.SDK.WXApiImplV10";
    protected Context context;
    protected String appId;
    protected boolean checkSignature = false;
    protected boolean detached = false;
    private int wxSdkVersion;
    private int launchMode = 2;
    private WXAPiSecurityHelper securityHelper;
    private static String wxappPayEntryClassname = null;

    BaseWXApiImplV10(Context context, String string, boolean bl, int n) {
        Log.d(TAG, "<init>, appId = " + string + ", checkSignature = " + bl + ", launchMode = " + n);
        this.context = context;
        this.appId = string;
        this.checkSignature = bl;
        this.launchMode = n;
        if (null != context.getApplicationContext()) {
            context = context.getApplicationContext();
        }
        d.D = context;
        this.securityHelper = new WXAPiSecurityHelper(context);
    }

    @Override
    public boolean registerApp(String string) {
        return this.registerApp(string, 0L);
    }

    @Override
    public boolean registerApp(String object, long l) {
        if (this.detached) {
            throw new IllegalStateException("registerApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e(TAG, "register app failed for wechat app signature check failed");
            return false;
        }
        Log.d(TAG, "registerApp, appId = ".concat(String.valueOf(object)));
        if (object != null) {
            this.appId = object;
        }
        Log.d(TAG, "registerApp, appId = ".concat(String.valueOf(object)));
        if (object != null) {
            this.appId = object;
        }
        Log.d(TAG, "register app " + this.context.getPackageName());
        object = new a.a();
        new a.a().a = "com.tencent.mm";
        ((a.a)object).action = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_REGISTER";
        ((a.a)object).content = "weixin://registerapp?appid=" + this.appId;
        ((a.a)object).b = l;
        return a.a(this.context, (a.a)object);
    }

    @Override
    public void unregisterApp() {
        if (this.detached) {
            throw new IllegalStateException("unregisterApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e(TAG, "unregister app failed for wechat app signature check failed");
            return;
        }
        Log.d(TAG, "unregisterApp, appId = " + this.appId);
        if (this.appId == null || this.appId.length() == 0) {
            Log.e(TAG, "unregisterApp fail, appId is empty");
            return;
        }
        Log.d(TAG, "unregister app " + this.context.getPackageName());
        a.a a2 = new a.a();
        new a.a().a = "com.tencent.mm";
        a2.action = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_UNREGISTER";
        a2.content = "weixin://unregisterapp?appid=" + this.appId;
        a.a(this.context, a2);
    }

    @Override
    public boolean handleIntent(Intent object, IWXAPIEventHandler iWXAPIEventHandler) {
        try {
            if (!WXApiImplComm.isIntentFromWx((Intent)object, "com.tencent.mm.openapi.token")) {
                Log.i(TAG, "handleIntent fail, intent not from weixin msg");
                return false;
            }
            if (this.detached) {
                throw new IllegalStateException("handleIntent fail, WXMsgImpl has been detached");
            }
            Object object2 = object.getStringExtra("_mmessage_content");
            int bl = object.getIntExtra("_mmessage_sdkVersion", 0);
            String string = object.getStringExtra("_mmessage_appPackage");
            if (string == null || string.length() == 0) {
                Log.e(TAG, "invalid argument");
                return false;
            }
            byte[] byArray = object.getByteArrayExtra("_mmessage_checksum");
            if (!this.checkSumConsistent(byArray, (byte[])(object2 = (Object)b.a((String)object2, bl, string)))) {
                Log.e(TAG, "checksum fail");
                return false;
            }
            int n = object.getIntExtra("_wxapi_command_type", 0);
            Log.i(TAG, "handleIntent, cmd = ".concat(String.valueOf(n)));
            switch (n) {
                case 1: {
                    object = new SendAuth.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 31: {
                    object = new SendTdiAuth.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 2: {
                    object = new SendMessageToWX.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 3: {
                    object = new GetMessageFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 4: {
                    object = new ShowMessageFromWX.Req(object.getExtras());
                    Object object3 = ((ShowMessageFromWX.Req)object).message.messageExt;
                    if (object3 != null && ((String)object3).contains("wx_internal_resptype")) {
                        boolean object4 = this.handleWxInternalRespType((String)object3, iWXAPIEventHandler);
                        Log.i(TAG, "handleIntent, extInfo contains wx_internal_resptype, ret = ".concat(String.valueOf(object4)));
                        return object4;
                    }
                    if (object3 != null && ((String)object3).contains("openbusinesswebview")) {
                        try {
                            Uri exception = Uri.parse((String)object3);
                            if (exception != null && "openbusinesswebview".equals(exception.getHost())) {
                                object3 = new WXOpenBusinessWebview.Resp();
                                string = exception.getQueryParameter("ret");
                                if (string != null && string.length() > 0) {
                                    ((WXOpenBusinessWebview.Resp)object3).errCode = d.c(string);
                                }
                                ((WXOpenBusinessWebview.Resp)object3).resultInfo = exception.getQueryParameter("resultInfo");
                                ((WXOpenBusinessWebview.Resp)object3).errStr = exception.getQueryParameter("errmsg");
                                String string2 = exception.getQueryParameter("type");
                                if (string2 != null && string2.length() > 0) {
                                    ((WXOpenBusinessWebview.Resp)object3).businessType = d.c(string2);
                                }
                                iWXAPIEventHandler.onResp((BaseResp)object3);
                                return true;
                            }
                            Log.d(TAG, "not openbusinesswebview %".concat(String.valueOf(object3)));
                        }
                        catch (Exception exception) {
                            Log.e(TAG, "parse fail, ex = " + exception.getMessage());
                        }
                    }
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 5: {
                    object = new PayResp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 27: {
                    object = new WXJointPay.JointPayResp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 6: {
                    object = new LaunchFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 9: {
                    object = new AddCardToWXCardPackage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 16: {
                    object = new ChooseCardFromWXCardPackage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 14: {
                    object = new CreateChatroom.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 15: {
                    object = new JoinChatroom.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 12: {
                    object = new OpenWebview.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 17: {
                    object = new HandleScanResult.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 19: {
                    object = new WXLaunchMiniProgram.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 30: {
                    object = new WXLaunchWxaRedirectingPage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 28: {
                    object = new WXPreloadMiniProgram.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 29: {
                    object = new WXLaunchMiniProgramWithToken.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 26: {
                    object = new WXOpenBusinessView.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 24: {
                    object = new JumpToOfflinePay.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 25: {
                    object = new WXOpenBusinessWebview.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 32: {
                    object = new WXPreloadMiniProgramEnvironment.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 39: {
                    object = new WXChannelStartLive.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 33: {
                    object = new WXChannelShareVideo.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 34: {
                    object = new WXChannelOpenProfile.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 35: {
                    object = new WXChannelOpenLive.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 36: {
                    object = new WXChannelOpenFeed.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 41: {
                    object = new WXChannelOpenEvent.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 42: {
                    object = new WXChannelBind.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 37: {
                    object = new WXOpenCustomerServiceChat.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 38: {
                    object = new WXQRCodePay.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 43: {
                    object = new WXGetA8Key.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
            }
            Log.e(TAG, "unknown cmd = ".concat(String.valueOf(n)));
        }
        catch (Exception exception) {
            Log.e(TAG, "handleIntent fail, ex = " + exception.getMessage());
        }
        return false;
    }

    private boolean handleWxInternalRespType(String string, IWXAPIEventHandler iWXAPIEventHandler) {
        Log.i(TAG, "handleWxInternalRespType, extInfo = ".concat(String.valueOf(string)));
        try {
            string = Uri.parse((String)string);
            Object object = string.getQueryParameter("wx_internal_resptype");
            Log.i(TAG, "handleWxInternalRespType, respType = ".concat(String.valueOf(object)));
            if (d.b((String)object)) {
                Log.e(TAG, "handleWxInternalRespType fail, respType is null");
                return false;
            }
            if (((String)object).equals("subscribemessage")) {
                object = new SubscribeMessage.Resp();
                String string2 = string.getQueryParameter("ret");
                if (string2 != null && string2.length() > 0) {
                    ((SubscribeMessage.Resp)object).errCode = d.c(string2);
                }
                ((SubscribeMessage.Resp)object).openId = string.getQueryParameter("openid");
                ((SubscribeMessage.Resp)object).templateID = string.getQueryParameter("template_id");
                ((SubscribeMessage.Resp)object).scene = d.c(string.getQueryParameter("scene"));
                ((SubscribeMessage.Resp)object).action = string.getQueryParameter("action");
                ((SubscribeMessage.Resp)object).reserved = string.getQueryParameter("reserved");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            if (((String)object).contains("invoice_auth_insert")) {
                object = new WXInvoiceAuthInsert.Resp();
                String string3 = string.getQueryParameter("ret");
                if (string3 != null && string3.length() > 0) {
                    ((WXInvoiceAuthInsert.Resp)object).errCode = d.c(string3);
                }
                ((WXInvoiceAuthInsert.Resp)object).wxOrderId = string.getQueryParameter("wx_order_id");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            if (((String)object).contains("payinsurance")) {
                object = new WXPayInsurance.Resp();
                String string4 = string.getQueryParameter("ret");
                if (string4 != null && string4.length() > 0) {
                    ((WXPayInsurance.Resp)object).errCode = d.c(string4);
                }
                ((WXPayInsurance.Resp)object).wxOrderId = string.getQueryParameter("wx_order_id");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            if (((String)object).contains("nontaxpay")) {
                object = new WXNontaxPay.Resp();
                String string5 = string.getQueryParameter("ret");
                if (string5 != null && string5.length() > 0) {
                    ((WXNontaxPay.Resp)object).errCode = d.c(string5);
                }
                ((WXNontaxPay.Resp)object).wxOrderId = string.getQueryParameter("wx_order_id");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            if ("subscribeminiprogrammsg".equals(object) || "5".equals(object)) {
                object = new SubscribeMiniProgramMsg.Resp();
                String string6 = string.getQueryParameter("ret");
                if (string6 != null && string6.length() > 0) {
                    ((SubscribeMiniProgramMsg.Resp)object).errCode = d.c(string6);
                }
                ((SubscribeMiniProgramMsg.Resp)object).openId = string.getQueryParameter("openid");
                ((SubscribeMiniProgramMsg.Resp)object).unionId = string.getQueryParameter("unionid");
                ((SubscribeMiniProgramMsg.Resp)object).nickname = string.getQueryParameter("nickname");
                ((SubscribeMiniProgramMsg.Resp)object).errStr = string.getQueryParameter("errmsg");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            Log.e(TAG, "this open sdk version not support the request type");
        }
        catch (Exception exception) {
            Log.e(TAG, "handleWxInternalRespType fail, ex = " + exception.getMessage());
        }
        return false;
    }

    @Override
    public boolean isWXAppInstalled() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppInstalled fail, WXMsgImpl has been detached");
        }
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo("com.tencent.mm", 64);
            if (packageInfo == null) {
                Log.w(TAG, "isWXAppInstalled packageInfo is null");
                return false;
            }
            return WXApiImplComm.validateAppSignature(this.context, packageInfo.signatures, this.checkSignature);
        }
        catch (Exception exception) {
            Log.w(TAG, "isWXAppInstalled ex:" + exception.getMessage());
            return false;
        }
    }

    @Override
    public int getWXAppSupportAPI() {
        Object object;
        if (this.detached) {
            throw new IllegalStateException("getWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            Log.e(TAG, "open wx app failed, not installed or signature check failed");
            return 0;
        }
        this.wxSdkVersion = 0;
        try {
            object = this.context.getPackageManager().getApplicationInfo("com.tencent.mm", 128);
            this.wxSdkVersion = ((ApplicationInfo)object).metaData.getInt("com.tencent.mm.BuildInfo.OPEN_SDK_VERSION", 0);
            Log.d(TAG, "OPEN_SDK_VERSION = " + this.wxSdkVersion);
        }
        catch (Exception exception) {
            Log.e(TAG, "get from metaData failed : " + exception.getMessage());
        }
        if (this.wxSdkVersion == 0) {
            object = new CountDownLatch(1);
            d.b().submit(new Runnable((CountDownLatch)object){
                final /* synthetic */ CountDownLatch val$countDownWait;
                {
                    this.val$countDownWait = countDownLatch;
                }

                @Override
                public void run() {
                    try {
                        MMSharedPreferences mMSharedPreferences = new MMSharedPreferences(BaseWXApiImplV10.this.context);
                        BaseWXApiImplV10.this.wxSdkVersion = mMSharedPreferences.getInt("_build_info_sdk_int_", 0);
                    }
                    catch (Exception exception) {
                        Log.w(BaseWXApiImplV10.TAG, exception.getMessage());
                    }
                    this.val$countDownWait.countDown();
                }
            });
            try {
                ((CountDownLatch)object).await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Log.w(TAG, interruptedException.getMessage());
            }
        }
        Log.d(TAG, "wxSdkVersion = " + this.wxSdkVersion);
        return this.wxSdkVersion;
    }

    @Override
    public boolean openWXApp() {
        if (this.detached) {
            throw new IllegalStateException("openWXApp fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            Log.e(TAG, "open wx app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.tencent.mm"));
        }
        catch (Exception exception) {
            Log.e(TAG, "startActivity fail, exception = " + exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean sendReq(BaseReq baseReq) {
        return this.sendReq(baseReq, null);
    }

    @Override
    public boolean sendReq(BaseReq baseReq, SendReqCallback sendReqCallback) {
        Object object;
        SendMessageToWX.Req req;
        if (this.detached) {
            throw new IllegalStateException("sendReq fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e(TAG, "sendReq failed for wechat app signature check failed");
            return false;
        }
        if (baseReq.getType() == 2) {
            req = (SendMessageToWX.Req)baseReq;
            if (req.scene == 4 && req.sceneDataObject instanceof WXStateSceneDataObject) {
                object = (WXStateSceneDataObject)req.sceneDataObject;
                if (req.message.mediaObject == null) {
                    req.message.mediaObject = new WXTextObject();
                }
                if (req.message.getType() == 1 && (((WXStateSceneDataObject)object).stateTitle == null || ((WXStateSceneDataObject)object).stateTitle.length() <= 0)) {
                    ((WXStateSceneDataObject)object).stateTitle = ((WXTextObject)req.message.mediaObject).text;
                }
            }
        }
        if (!baseReq.checkArgs()) {
            Log.e(TAG, "sendReq checkArgs fail");
            return false;
        }
        Log.i(TAG, "sendReq, req type = " + baseReq.getType());
        req = new Bundle();
        baseReq.toBundle((Bundle)req);
        if (baseReq.getType() == 5 || baseReq.getType() == 27) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendPayReq(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 9) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendAddCardToWX(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 16) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendChooseCardFromWX(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 11) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendOpenRankListReq(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 12) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendOpenWebview(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 25) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendOpenBusinessWebview(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 13) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendOpenBusiLuckyMoney(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 14) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.createChatroom(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 15) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.joinChatroom(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 17) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendHandleScanResult(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 18) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendSubscribeMessage(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 28) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendPreloadWXMiniprogram(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 29) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendLaunchWXMiniprogramWithToken(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 23) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendSubscribeMiniProgramMsg(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 19) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendLaunchWXMiniprogram(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 32) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendPreloadWXMiniProgramEnvironment(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 30) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendToWxaRedirectingPage(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 26) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendOpenBusinessView(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 33) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendFinderShareVideo(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 39) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendFinderStartLive(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 34) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendFinderOpenProfile(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 35) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendFinderOpenLive(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 36) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendFinderOpenFeed(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 41) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendFinderOpenEvent(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 42) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendFinderBind(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 37) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendOpenCustomerServiceChat(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 38) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendQRCodePayReq(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 20) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendInvoiceAuthInsert(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 21) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendNonTaxPay(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 22) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendPayInSurance(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 24) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendJumpToOfflinePayReq(baseWXApiImplV10.context, (Bundle)req);
        }
        if (baseReq.getType() == 43) {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            return baseWXApiImplV10.sendGetA8KeyReq(baseWXApiImplV10.context, baseReq);
        }
        if (baseReq.getType() == 2) {
            object = (SendMessageToWX.Req)baseReq;
            if (d.a(((SendMessageToWX.Req)object).message.getType())) {
                WXMiniProgramObject wXMiniProgramObject = (WXMiniProgramObject)((SendMessageToWX.Req)object).message.mediaObject;
                wXMiniProgramObject.userName = wXMiniProgramObject.userName + "@app";
                Object object2 = wXMiniProgramObject.path;
                if (!d.b((String)wXMiniProgramObject.path)) {
                    object2 = ((String[])(object2 = object2.split("\\?"))).length > 1 ? object2[0] + ".html?" + object2[1] : object2[0] + ".html";
                    wXMiniProgramObject.path = object2;
                }
                if (((SendMessageToWX.Req)object).scene != 3 && ((SendMessageToWX.Req)object).scene != 1) {
                    ((SendMessageToWX.Req)object).scene = 0;
                }
                baseReq.toBundle((Bundle)req);
            }
        }
        if (!d.b((String)(object = this.securityHelper.extractMayNeedDoSecurityCheckUrl(this.appId, baseReq)))) {
            int n = this.securityHelper.doExtraSecurityCheck(this.appId, "638067200", (String)object, new WXAPiSecurityHelper.ISecurityCheck((Bundle)req, sendReqCallback){
                final /* synthetic */ Bundle val$data;
                final /* synthetic */ SendReqCallback val$sendReqCallback;
                {
                    this.val$data = bundle;
                    this.val$sendReqCallback = sendReqCallback;
                }

                @Override
                public void onCheckFinish(boolean bl) {
                    if (bl) {
                        Log.i(BaseWXApiImplV10.TAG, "WXAPiSecurityHelper, extra check do next step: check pass, doLaunchApp");
                        bl = BaseWXApiImplV10.this.doLaunchApp(this.val$data);
                        BaseWXApiImplV10.this.callbackReq(this.val$sendReqCallback, bl);
                        return;
                    }
                    Log.i(BaseWXApiImplV10.TAG, "WXAPiSecurityHelper, extra check do next step: check fail, stop process!");
                    BaseWXApiImplV10.this.callbackReq(this.val$sendReqCallback, false);
                }
            });
            if (!n) {
                Log.i(TAG, "WXAPiSecurityHelper, extra check pass, doLaunchApp");
                n = this.doLaunchApp((Bundle)req) ? 1 : 0;
                this.callbackReq(sendReqCallback, n != 0);
                return n != 0;
            }
            if (n) {
                Log.i(TAG, "WXAPiSecurityHelper, extra check fail, return");
                this.callbackReq(sendReqCallback, false);
                return false;
            }
            Log.i(TAG, "WXAPiSecurityHelper, hold on request, extra check need to do next step");
            return true;
        }
        boolean bl = this.doLaunchApp((Bundle)req);
        this.callbackReq(sendReqCallback, bl);
        return bl;
    }

    private void callbackReq(SendReqCallback sendReqCallback, boolean bl) {
        if (sendReqCallback != null) {
            sendReqCallback.onSendFinish(bl);
        }
    }

    private boolean doLaunchApp(Bundle object) {
        MMessageActV2.Args args = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = object;
        args.content = "weixin://sendreq?appid=" + this.appId;
        args.targetPkgName = "com.tencent.mm";
        args.targetClassName = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        args.launchMode = this.launchMode;
        try {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            object = baseWXApiImplV10.getTokenFromWX(baseWXApiImplV10.context);
            if (object != null) {
                args.token = object;
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "getTokenFromWX fail, exception = ".concat(String.valueOf(exception)));
        }
        return MMessageActV2.send(this.context, args);
    }

    private String getTokenFromWX(Context context) {
        String[] stringArray;
        context = context.getContentResolver();
        Object object = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/genTokenForOpenSdk");
        if ((context = context.query(object, null, null, stringArray = new String[]{this.appId, "638067200"}, null)) != null && context.moveToFirst()) {
            object = context.getString(0);
            Log.i(TAG, "getTokenFromWX token is ".concat(String.valueOf(object)));
            context.close();
            return object;
        }
        Log.e(TAG, "getTokenFromWX , token is null , if your app targetSdkVersion >= 30, include 'com.tencent.mm' in a set of <package> elements inside the <queries> element");
        return null;
    }

    private boolean sendPayReq(Context context, Bundle bundle) {
        if (wxappPayEntryClassname == null) {
            wxappPayEntryClassname = new MMSharedPreferences(context).getString("_wxapp_pay_entry_classname_", null);
            Log.d(TAG, "pay, set wxappPayEntryClassname = " + wxappPayEntryClassname);
            if (wxappPayEntryClassname == null) {
                try {
                    wxappPayEntryClassname = context.getPackageManager().getApplicationInfo((String)"com.tencent.mm", (int)128).metaData.getString("com.tencent.mm.BuildInfo.OPEN_SDK_PAY_ENTRY_CLASSNAME", null);
                }
                catch (Exception exception) {
                    Log.e(TAG, "get from metaData failed : " + exception.getMessage());
                }
            }
            if (wxappPayEntryClassname == null) {
                Log.e(TAG, "pay fail, wxappPayEntryClassname is null");
                return false;
            }
        }
        MMessageActV2.Args args = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = bundle;
        args.targetPkgName = "com.tencent.mm";
        args.targetClassName = wxappPayEntryClassname;
        args.launchMode = this.launchMode;
        try {
            String string = this.getTokenFromWX(context);
            if (string != null) {
                args.token = string;
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "getTokenFromWX fail, exception = ".concat(String.valueOf(exception)));
        }
        return MMessageActV2.send(context, args);
    }

    private void launchWXIfNeed() {
        if (Build.VERSION.SDK_INT >= 29 && this.launchMode == 2) {
            this.launchWXUsingPendingIntent();
            return;
        }
        this.openWXApp();
    }

    private void launchWXUsingPendingIntent() {
        if (this.detached) {
            throw new IllegalStateException("openWXApp fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            Log.e(TAG, "openWXApp failed, not installed or signature check failed");
            return;
        }
        try {
            Log.i(TAG, "launchWXUsingPendingIntent");
            Intent intent = this.context.getPackageManager().getLaunchIntentForPackage("com.tencent.mm");
            int n = 0x8000000;
            if (Build.VERSION.SDK_INT >= 23) {
                n = 0xC000000;
            }
            if (Build.VERSION.SDK_INT >= 35) {
                if (intent == null) {
                    throw new NullPointerException("getLaunchIntentForPackage is null");
                }
                ActivityOptions activityOptions = ActivityOptions.makeBasic();
                activityOptions.setPendingIntentBackgroundActivityStartMode(1);
                intent = PendingIntent.getActivity((Context)this.context, (int)1, (Intent)intent, (int)n, (Bundle)activityOptions.toBundle());
            } else {
                intent = PendingIntent.getActivity((Context)this.context, (int)1, (Intent)intent, (int)n);
            }
            intent.send(this.context, 2, null, new PendingIntent.OnFinished(){

                public void onSendFinished(PendingIntent pendingIntent, Intent intent, int n, String string, Bundle bundle) {
                    Log.d(BaseWXApiImplV10.TAG, "onSendFinished resultCode: " + n + ", resultData: " + string);
                }
            }, null);
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "launchWXUsingPendingIntent pendingIntent send failed: " + exception.getMessage());
            this.openWXApp();
            return;
        }
    }

    private boolean sendAddCardToWX(Context context, Bundle stringArray) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/addCardToWX");
        stringArray = new String[]{this.appId, stringArray.getString("_wxapi_add_card_to_wx_card_list"), stringArray.getString("_wxapi_basereq_transaction")};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendChooseCardFromWX(Context context, Bundle stringArray) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/chooseCardFromWX");
        stringArray = new String[]{stringArray.getString("_wxapi_choose_card_from_wx_card_app_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_location_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_sign_type"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_sign"), stringArray.getString("_wxapi_choose_card_from_wx_card_time_stamp"), stringArray.getString("_wxapi_choose_card_from_wx_card_nonce_str"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_type"), stringArray.getString("_wxapi_choose_card_from_wx_card_can_multi_select"), stringArray.getString("_wxapi_basereq_transaction")};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenRankListReq(Context context, Bundle bundle) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        bundle = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openRankList");
        String[] stringArray = new String[]{};
        context = context.query((Uri)bundle, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenWebview(Context context, Bundle stringArray) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openWebview");
        stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_webview_url"), stringArray.getString("_wxapi_basereq_transaction")};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenBusinessWebview(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXOpenBusinessWebview.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openBusinessWebview");
        String string = "";
        if (stringArray.queryInfo != null && stringArray.queryInfo.size() > 0) {
            string = new JSONObject(stringArray.queryInfo).toString();
        }
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, "" + stringArray.businessType, string}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToOfflinePayReq(Context context, Bundle bundle) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        bundle = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToOfflinePay");
        String[] stringArray = new String[]{this.appId};
        context = context.query((Uri)bundle, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendGetA8KeyReq(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXGetA8Key.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/getA8Key");
        stringArray = new String[]{this.appId, stringArray.url};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenBusiLuckyMoney(Context context, Bundle stringArray) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openBusiLuckyMoney");
        stringArray = new String[]{this.appId, stringArray.getString("_wxapi_open_busi_lucky_money_timeStamp"), stringArray.getString("_wxapi_open_busi_lucky_money_nonceStr"), stringArray.getString("_wxapi_open_busi_lucky_money_signType"), stringArray.getString("_wxapi_open_busi_lucky_money_signature"), stringArray.getString("_wxapi_open_busi_lucky_money_package")};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean createChatroom(Context context, Bundle stringArray) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/createChatroom");
        stringArray = new String[]{this.appId, stringArray.getString("_wxapi_basereq_transaction", ""), stringArray.getString("_wxapi_create_chatroom_group_id", ""), stringArray.getString("_wxapi_create_chatroom_chatroom_name", ""), stringArray.getString("_wxapi_create_chatroom_chatroom_nickname", ""), stringArray.getString("_wxapi_create_chatroom_ext_msg", ""), stringArray.getString("_wxapi_basereq_openid", "")};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean joinChatroom(Context context, Bundle stringArray) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/joinChatroom");
        stringArray = new String[]{this.appId, stringArray.getString("_wxapi_basereq_transaction", ""), stringArray.getString("_wxapi_join_chatroom_group_id", ""), stringArray.getString("_wxapi_join_chatroom_chatroom_nickname", ""), stringArray.getString("_wxapi_join_chatroom_ext_msg", ""), stringArray.getString("_wxapi_basereq_openid", "")};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendHandleScanResult(Context context, Bundle stringArray) {
        this.launchWXIfNeed();
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/handleScanResult");
        stringArray = new String[]{this.appId, stringArray.getString("_wxapi_scan_qrcode_result")};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendSubscribeMessage(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (SubscribeMessage.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = new String[]{this.appId, "1", String.valueOf(stringArray.scene), stringArray.templateID, stringArray.reserved};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendSubscribeMiniProgramMsg(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (SubscribeMiniProgramMsg.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = new String[]{this.appId, "5", stringArray.miniProgramAppId};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendInvoiceAuthInsert(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXInvoiceAuthInsert.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = URLEncoder.encode(String.format("url=%s", URLEncoder.encode(stringArray.url)));
        stringArray = new String[]{this.appId, "2", stringArray};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendNonTaxPay(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXNontaxPay.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = URLEncoder.encode(String.format("url=%s", URLEncoder.encode(stringArray.url)));
        stringArray = new String[]{this.appId, "3", stringArray};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendPayInSurance(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXPayInsurance.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = URLEncoder.encode(String.format("url=%s", URLEncoder.encode(stringArray.url)));
        stringArray = new String[]{this.appId, "4", stringArray};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendPreloadWXMiniprogram(Context context, BaseReq stringArray) {
        stringArray = (WXPreloadMiniProgram.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/preloadWXMiniprogram");
        stringArray = new String[]{this.appId, stringArray.userName, stringArray.path, "" + stringArray.miniprogramType, stringArray.extData};
        if ((context = context.query(uri, null, null, stringArray, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendLaunchWXMiniprogramWithToken(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXLaunchMiniProgramWithToken.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/launchWXMiniprogramWithToken");
        stringArray = new String[]{this.appId, stringArray.token};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendLaunchWXMiniprogram(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXLaunchMiniProgram.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/launchWXMiniprogram");
        stringArray = new String[]{this.appId, stringArray.userName, stringArray.path, "" + stringArray.miniprogramType, stringArray.extData};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendPreloadWXMiniProgramEnvironment(Context context, BaseReq stringArray) {
        stringArray = (WXPreloadMiniProgramEnvironment.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/preloadWXMiniprogramEnvironment");
        stringArray = new String[]{this.appId, stringArray.extData};
        if ((context = context.query(uri, null, null, stringArray, null)) != null) {
            context.close();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sendToWxaRedirectingPage(Context context, BaseReq baseReq) {
        this.launchWXIfNeed();
        baseReq = (WXLaunchWxaRedirectingPage.Req)baseReq;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/launchWxaOpenApiRedirectingPage");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, this.appId);
        arrayList.addAll(Arrays.asList(((WXLaunchWxaRedirectingPage.Req)baseReq).toArray()));
        context = context.query(uri, null, null, arrayList.toArray(new String[0]), null);
        if (context == null) return true;
        context.close();
        return true;
    }

    private boolean sendOpenBusinessView(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXOpenBusinessView.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openBusinessView");
        stringArray = new String[]{this.appId, stringArray.businessType, stringArray.query, stringArray.extInfo, stringArray.transaction, stringArray.openId};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendFinderStartLive(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        Log.i(TAG, "sendFinderStartLive");
        stringArray = (WXChannelStartLive.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/finderStartLive");
        stringArray = new String[]{this.appId, stringArray.liveJsonInfo, stringArray.openId};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendFinderShareVideo(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        Log.i(TAG, "sendFinderShareVideo");
        stringArray = (WXChannelShareVideo.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/finderShareVideo");
        stringArray = new String[]{this.appId, stringArray.videoPath, "", "", stringArray.extData, this.finderShareVideoJumpInfoToString(stringArray.jumpInfo)};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private String finderShareVideoJumpInfoToString(IWXChannelJumpInfo iWXChannelJumpInfo) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("jumpType", iWXChannelJumpInfo.type());
            if (iWXChannelJumpInfo instanceof WXChannelBaseJumpInfo) {
                jSONObject.put("wording", (Object)((WXChannelBaseJumpInfo)iWXChannelJumpInfo).wording);
                jSONObject.put("extra", (Object)((WXChannelBaseJumpInfo)iWXChannelJumpInfo).extra);
                if (iWXChannelJumpInfo instanceof WXChannelJumpMiniProgramInfo) {
                    jSONObject.put("username", (Object)((WXChannelJumpMiniProgramInfo)iWXChannelJumpInfo).username);
                    jSONObject.put("path", (Object)((WXChannelJumpMiniProgramInfo)iWXChannelJumpInfo).path);
                } else if (iWXChannelJumpInfo instanceof WXChannelJumpUrlInfo) {
                    jSONObject.put("url", (Object)((WXChannelJumpUrlInfo)iWXChannelJumpInfo).url);
                }
            }
            return jSONObject.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private boolean sendFinderOpenProfile(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        Log.i(TAG, "sendFinderOpenProfile");
        stringArray = (WXChannelOpenProfile.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/finderOpenProfile");
        stringArray = new String[]{this.appId, stringArray.userName};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendFinderOpenLive(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        Log.i(TAG, "sendFinderOpenLive");
        stringArray = (WXChannelOpenLive.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/finderOpenLive");
        stringArray = new String[]{this.appId, stringArray.feedID, stringArray.nonceID};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendFinderOpenFeed(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        Log.i(TAG, "sendFinderOpenFeed");
        stringArray = (WXChannelOpenFeed.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/finderOpenFeed");
        stringArray = new String[]{this.appId, stringArray.feedID, stringArray.nonceID, String.valueOf(stringArray.notGetReleatedList)};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendFinderOpenEvent(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        Log.i(TAG, "sendFinderOpenEvent");
        stringArray = (WXChannelOpenEvent.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/finderOpenEvent");
        stringArray = new String[]{this.appId, stringArray.username, stringArray.eventId, stringArray.extInfo};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendFinderBind(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        Log.i(TAG, "sendFinderBind");
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/finderBind");
        stringArray = new String[]{this.appId, stringArray.openId};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenCustomerServiceChat(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXOpenCustomerServiceChat.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openCustomerServiceChat");
        stringArray = new String[]{this.appId, stringArray.corpId, stringArray.url};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    private boolean sendQRCodePayReq(Context context, BaseReq stringArray) {
        this.launchWXIfNeed();
        stringArray = (WXQRCodePay.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/QRCodePay");
        stringArray = new String[]{this.appId, stringArray.codeContent, stringArray.extraMsg};
        context = context.query(uri, null, null, stringArray, null);
        if (context != null) {
            context.close();
        }
        return true;
    }

    @Override
    public boolean sendResp(BaseResp object) {
        if (this.detached) {
            throw new IllegalStateException("sendResp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e(TAG, "sendResp failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseResp)object).checkArgs()) {
            Log.e(TAG, "sendResp checkArgs fail");
            return false;
        }
        Object object2 = new Bundle();
        ((BaseResp)object).toBundle((Bundle)object2);
        object = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = object2;
        ((MMessageActV2.Args)object).content = "weixin://sendresp?appid=" + this.appId;
        ((MMessageActV2.Args)object).targetPkgName = "com.tencent.mm";
        ((MMessageActV2.Args)object).targetClassName = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        try {
            BaseWXApiImplV10 baseWXApiImplV10 = this;
            object2 = baseWXApiImplV10.getTokenFromWX(baseWXApiImplV10.context);
            if (object2 != null) {
                ((MMessageActV2.Args)object).token = object2;
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "getTokenFromWX fail, exception = ".concat(String.valueOf(exception)));
        }
        return MMessageActV2.send(this.context, (MMessageActV2.Args)object);
    }

    @Override
    public void detach() {
        Log.d(TAG, "detach");
        this.detached = true;
        this.context = null;
    }

    @Override
    public void setLogImpl(ILog iLog) {
        Log.setLogImpl(iLog);
    }

    private boolean checkSumConsistent(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            Log.e(TAG, "checkSumConsistent fail, invalid arguments");
            return false;
        }
        if (byArray.length != byArray2.length) {
            Log.e(TAG, "checkSumConsistent fail, length is different");
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

