/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.b;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONArray;
import org.json.JSONObject;

class WXAPiSecurityHelper {
    private static final String TAG = "MicroMsg.SDK.WXAPiSecurityHelper";
    private static final String SECURITY_KEY_TIMESTAMP_SECOND = "security_key_timestamp_second";
    private static final String STORE_VALUE_DATA = "security_key_resp";
    private static final int MAX_STORE_KEY = 100;
    private static final int MAX_STORE_VALUE = 2048;
    private final SharedPreferences sp;
    private final Context context;
    private final CopyOnWriteArraySet<String> overtimeSyncReqSet = new CopyOnWriteArraySet();

    public WXAPiSecurityHelper(Context context) {
        this.context = context;
        this.sp = context.getSharedPreferences("__wx_opensdk_sp__", 0);
    }

    private String getStoreKey(String string) {
        return "security_key_appid_" + string;
    }

    private void extraSecurityCheckDoCallback(final ISecurityCheck iSecurityCheck, final boolean bl) {
        if (iSecurityCheck != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Log.d(WXAPiSecurityHelper.TAG, "has got result, callback on Main Thread.");
                    iSecurityCheck.onCheckFinish(bl);
                }
            });
        }
    }

    private void doRequestAsync(PassContext passContext) {
        IHttpCheckCallback iHttpCheckCallback;
        Log.d(TAG, "doRequestAsync");
        IHttpCheckCallback iHttpCheckCallback2 = iHttpCheckCallback;
        iHttpCheckCallback = new IHttpCheckCallback(){

            @Override
            public void onHttpCheckFinish(PromiseShareRule promiseShareRule) {
                WXAPiSecurityHelper.this.storeIfNecessary(promiseShareRule);
            }
        };
        this.doRequest(passContext, iHttpCheckCallback2);
    }

    private void doRequestSync(final PassContext passContext, final ISecuritySyncCheck iSecuritySyncCheck) {
        Timer timer;
        Log.i(TAG, "requestId = " + passContext.reqSessionId);
        final Timer timer2 = timer;
        new Timer(passContext.reqSessionId).schedule(new TimerTask(){

            @Override
            public void run() {
                4 v0 = iSecuritySyncCheck2;
                Log.i(WXAPiSecurityHelper.TAG, "sync request overtime, requestId = " + iSecuritySyncCheck2.passContext.reqSessionId);
                v0.WXAPiSecurityHelper.this.overtimeSyncReqSet.add(iSecuritySyncCheck2.passContext.reqSessionId);
                ISecuritySyncCheck iSecuritySyncCheck2 = v0.iSecuritySyncCheck;
                if (iSecuritySyncCheck2 != null) {
                    iSecuritySyncCheck2.onSyncCheckFinish(true);
                }
            }
        }, passContext.localRule.getLegalUserWaitTime());
        this.doRequest(passContext, new IHttpCheckCallback(){

            @Override
            public void onHttpCheckFinish(PromiseShareRule promiseShareRule) {
                5 v0 = this;
                v0.timer2.cancel();
                if (v0.WXAPiSecurityHelper.this.overtimeSyncReqSet.contains(passContext.reqSessionId)) {
                    5 v1 = this;
                    v1.WXAPiSecurityHelper.this.overtimeSyncReqSet.remove(passContext.reqSessionId);
                    v1.WXAPiSecurityHelper.this.storeIfNecessary(promiseShareRule);
                    return;
                }
                if (iSecuritySyncCheck != null) {
                    int n = WXAPiSecurityHelper.this.checkRuleCanPass(passContext.inputUrl, promiseShareRule);
                    if (n == 1) {
                        iSecuritySyncCheck.onSyncCheckFinish(true);
                    } else if (n == 2) {
                        iSecuritySyncCheck.onSyncCheckFinish(false);
                    } else {
                        5 v2 = this;
                        Object object = v2.WXAPiSecurityHelper.this.getStoredData(passContext.appid);
                        WXSecurityData wXSecurityData = object;
                        object = passContext.appid;
                        object = v2.WXAPiSecurityHelper.this.convert2ShareRule((String)object, wXSecurityData.respDataJson);
                        int n2 = v2.WXAPiSecurityHelper.this.checkRuleCanPass(passContext.inputUrl, (PromiseShareRule)object);
                        object = iSecuritySyncCheck;
                        boolean bl = n2 != 2;
                        object.onSyncCheckFinish(bl);
                    }
                }
                WXAPiSecurityHelper.this.storeIfNecessary(promiseShareRule);
            }
        });
    }

    private void doRequest(final PassContext passContext, final IHttpCheckCallback iHttpCheckCallback) {
        b.b.submit(new Runnable(){

            @Override
            public void run() {
                6 v0 = object2;
                Object object = object2.passContext;
                String string = ((PassContext)object).appid;
                String string2 = ((PassContext)object).version;
                object = v0.WXAPiSecurityHelper.this.postHttpRequest(string, string2, ((PassContext)object).localRule.buffer);
                Object object2 = object2.passContext.appid;
                object2 = v0.WXAPiSecurityHelper.this.convert2ShareRule((String)object2, ((StringBuffer)object).toString());
                v0.iHttpCheckCallback.onHttpCheckFinish((PromiseShareRule)object2);
            }
        });
    }

    private void storeIfNecessary(PromiseShareRule promiseShareRule) {
        Log.d(TAG, "storeIfNecessary");
        if (!b.b(promiseShareRule.reqAppid) && promiseShareRule.reqAppid.length() <= 100) {
            if (!b.b(promiseShareRule.orgJsonData) && promiseShareRule.orgJsonData.length() <= 2048) {
                if (promiseShareRule.state == 1 && promiseShareRule.reqAppid.equals(promiseShareRule.appidInRule)) {
                    Log.d(TAG, "storeIfNecessary, in rule");
                    this.storeCheckResp(promiseShareRule.reqAppid, promiseShareRule);
                }
                if (promiseShareRule.state == 2) {
                    Log.d(TAG, "storeIfNecessary, not rule");
                    this.storeCheckResp(promiseShareRule.reqAppid, promiseShareRule);
                }
                return;
            }
            Log.i(TAG, "store fail! response json illegal!");
            return;
        }
        Log.i(TAG, "store fail! reqAppid illegal!");
    }

    private void storeCheckResp(String string, PromiseShareRule object) {
        JSONObject jSONObject;
        object = this.cookStoreJson(string, (PromiseShareRule)object);
        Log.d(TAG, "cookStoreJson = " + (String)object);
        if (b.b((String)object)) {
            Log.w(TAG, "cookStoreJson get null!");
            return;
        }
        WXAPiSecurityHelper wXAPiSecurityHelper = this;
        String string2 = string;
        JSONObject jSONObject2 = jSONObject;
        JSONObject jSONObject3 = jSONObject;
        jSONObject = new JSONObject();
        JSONObject jSONObject4 = jSONObject;
        jSONObject4.put(SECURITY_KEY_TIMESTAMP_SECOND, System.currentTimeMillis() / 1000L);
        jSONObject2.put(STORE_VALUE_DATA, object);
        try {
            wXAPiSecurityHelper.commitSp(string2, jSONObject3.toString());
        }
        catch (Exception exception) {
            Log.e(TAG, "storeCheckResp fail, ex = " + exception.getMessage());
        }
    }

    private int checkRuleCanPass(String string, PromiseShareRule promiseShareRule) {
        Log.d(TAG, "checkRuleCanPass, start check!");
        if (promiseShareRule.orgJsonData.length() > 2048) {
            Log.w(TAG, "response json is too long!");
            return 0;
        }
        int n = promiseShareRule.state;
        if (n == 2) {
            Log.d(TAG, "checkRuleCanPass, not in rule");
            return 1;
        }
        if (n == 1 && promiseShareRule.appidInRule.equals(promiseShareRule.reqAppid)) {
            if (promiseShareRule.urlRuleList.size() == 0) {
                Log.d(TAG, "checkRuleCanPass, urlRuleList empty!");
                return 1;
            }
            boolean bl = this.checkUrlParametersLegal(string, promiseShareRule);
            Log.d(TAG, "checkRuleCanPass, urlCheckResult = " + bl);
            if (!bl) {
                Log.d(TAG, "checkRuleCanPass, no pass");
                return 2;
            }
            Log.d(TAG, "checkRuleCanPass, pass");
            return 1;
        }
        Log.d(TAG, "checkRuleCanPass, unknown");
        return 0;
    }

    private boolean checkUrlParametersLegal(String string, PromiseShareRule promiseShareRule) {
        WXAPiSecurityHelper wXAPiSecurityHelper = Uri.parse((String)string);
        if (b.b(string = wXAPiSecurityHelper.getHost())) {
            Log.i(TAG, "checkUrlParameters, host empty!");
            return false;
        }
        for (int i = 0; i < promiseShareRule.urlRuleList.size(); ++i) {
            UrlRule urlRule = promiseShareRule.urlRuleList.get(i);
            if (!string.equals(urlRule.host)) continue;
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n2 >= urlRule.mustQueryKey.size()) break;
                WXAPiSecurityHelper wXAPiSecurityHelper2 = wXAPiSecurityHelper;
                String string2 = urlRule.mustQueryKey.get(n2);
                Log.d(TAG, "checkRuleCanPass, key = " + string2);
                if (!b.b(wXAPiSecurityHelper2.getQueryParameter(string2))) {
                    n += 1;
                }
                ++n2;
                continue;
                break;
            }
            n = n == urlRule.mustQueryKey.size() ? 1 : 0;
            try {
                Log.d(TAG, "checkRuleCanPass, rule.host = " + urlRule.host + ", queryOk = " + (n != 0));
                return n != 0;
            }
            catch (Exception exception) {
                Log.e(TAG, "checkRuleCanPass, parse fail, e = %s" + exception.getMessage());
            }
        }
        return false;
    }

    public String extractMayNeedDoSecurityCheckUrl(String string, BaseReq baseReq) {
        if (baseReq.getType() != 2) {
            return "";
        }
        Object object = (SendMessageToWX.Req)baseReq;
        if (((SendMessageToWX.Req)object).message.getType() != 5) {
            return "";
        }
        object = (WXWebpageObject)((SendMessageToWX.Req)object).message.mediaObject;
        if (b.b(((WXWebpageObject)object).webpageUrl)) {
            Log.i(TAG, "webpageUrl empty, don't need check.");
            return "";
        }
        Log.i(TAG, "need check.");
        return ((WXWebpageObject)object).webpageUrl;
    }

    public int doExtraSecurityCheck(String object, String object2, String string, final ISecurityCheck iSecurityCheck) {
        Log.i(TAG, "doExtraSecurityCheck: start!");
        if (!b.b((String)object) && !b.b(string)) {
            ISecuritySyncCheck iSecuritySyncCheck;
            StringBuilder stringBuilder;
            PassContext passContext;
            WXAPiSecurityHelper wXAPiSecurityHelper = string3;
            Object[] objectArray = object;
            long l = System.currentTimeMillis();
            PassContext passContext2 = passContext;
            String string2 = object2;
            Object[] objectArray2 = object;
            passContext2();
            Object[] objectArray3 = new Object[1];
            object = objectArray3;
            object2 = stringBuilder;
            ((StringBuilder)object2)();
            objectArray3[0] = stringBuilder.append(l).append("").append(new Random().nextInt(9999)).toString();
            passContext2.reqSessionId = String.format("%s", (Object[])object);
            passContext2.appid = objectArray2;
            passContext2.inputUrl = string;
            passContext.version = string2;
            object = wXAPiSecurityHelper.getStoredData((String)objectArray);
            if (wXAPiSecurityHelper.context.getPackageManager().checkPermission("android.permission.INTERNET", ((WXAPiSecurityHelper)((Object)string3)).context.getPackageName()) != 0) {
                Log.w(TAG, "doExtraSecurityCheck: No Internet permission!");
                return 0;
            }
            if (!((WXSecurityData)object).isBasicParamsAllowed()) {
                Log.d(TAG, "doExtraSecurityCheck: local data illegal!");
                ((WXAPiSecurityHelper)((Object)string3)).doRequestAsync(passContext2);
                return 0;
            }
            object2 = passContext2.appid;
            object2 = ((WXAPiSecurityHelper)((Object)string3)).convert2ShareRule((String)object2, ((WXSecurityData)object).respDataJson);
            passContext2.localRule = object2;
            boolean bl = (((WXSecurityData)object).lastStoreTimeStampSecond + ((PromiseShareRule)object2).getLegalReqInterval()) * 1000L < System.currentTimeMillis();
            Log.d(TAG, "doExtraSecurityCheck: needDoNextReq: " + bl + ", last req time stamp:" + ((WXSecurityData)object).lastStoreTimeStampSecond);
            if (!bl) {
                WXAPiSecurityHelper wXAPiSecurityHelper2 = string3;
                PassContext passContext3 = passContext2;
                String string3 = passContext3.inputUrl;
                int n = wXAPiSecurityHelper2.checkRuleCanPass(string3, passContext3.localRule);
                Log.d(TAG, "doExtraSecurityCheck: no needDoNextReq, read local rule: " + n);
                if (n == 2) {
                    return 1;
                }
                return 0;
            }
            Log.d(TAG, "doExtraSecurityCheck: needDoNextReq, state: " + passContext2.localRule.state);
            if (passContext2.localRule.state != 1) {
                super.doRequestAsync(passContext2);
                return 0;
            }
            object = iSecuritySyncCheck;
            iSecuritySyncCheck = new ISecuritySyncCheck(){

                @Override
                public void onSyncCheckFinish(boolean bl) {
                    WXAPiSecurityHelper.this.extraSecurityCheckDoCallback(iSecurityCheck, bl);
                }
            };
            super.doRequestSync(passContext2, (ISecuritySyncCheck)object);
            return 2;
        }
        Log.e(TAG, "doExtraSecurityCheck: appid or inputurl is empty!");
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    protected StringBuffer postHttpRequest(String var1_1, String var2_3, String var3_6) {
        this = v0;
        v0 = new StringBuffer();
        var1_1 = URLEncoder.encode((String)var1_1, "UTF-8");
        var3_6 = URLEncoder.encode(var3_6, "UTF-8");
        var4_7 = String.format("https://mp.weixin.qq.com/publicpoc/opensdkconf?action=GetShareConf&appid=%s&sdkVersion=%s&buffer=%s", new Object[]{var1_1, var2_3, var3_6});
        Log.d("MicroMsg.SDK.WXAPiSecurityHelper", "request http, url = " + var4_7 + ", appid = " + (String)var1_1 + ", version = " + var2_3 + ", buffer = " + var3_6);
        var1_1 = (HttpURLConnection)new URL(var4_7).openConnection();
        var1_1.setConnectTimeout(60000);
        var1_1.setReadTimeout(60000);
        var1_1.setRequestProperty("Content-Type", "application/json");
        var1_1.connect();
        var2_4 = var1_1.getResponseCode();
        Log.i("MicroMsg.SDK.WXAPiSecurityHelper", "http respCode = " + var2_4);
        if (var2_4 != 200) ** GOTO lbl32
        var2_5 = v1;
        v1 = new BufferedReader(new InputStreamReader(var1_1.getInputStream()));
        ** while ((var3_6 = var2_5.readLine()) != null)
lbl-1000:
        // 1 sources

        {
            this.append(var3_6);
            continue;
        }
lbl29:
        // 1 sources

        try {
            Log.d("MicroMsg.SDK.WXAPiSecurityHelper", "http response = " + this);
            var2_5.close();
lbl32:
            // 2 sources

            var1_1.disconnect();
        }
        catch (Exception var1_2) {
            Log.e("MicroMsg.SDK.WXAPiSecurityHelper", "http request fail, ex = " + var1_2.getMessage());
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String cookStoreJson(String string, PromiseShareRule object) {
        String string2;
        block14: {
            block16: {
                block15: {
                    JSONObject jSONObject;
                    if (object == null) return "";
                    if (b.b(string)) return "";
                    string = "";
                    try {
                        if (((PromiseShareRule)object).state != 2) break block14;
                    }
                    catch (Exception exception) {
                        Log.e(TAG, "storeCheckResp fail, ex = " + exception.getMessage());
                        return "";
                    }
                    Object object2 = object;
                    WXAPiSecurityHelper wXAPiSecurityHelper = jSONObject;
                    Object object3 = object;
                    WXAPiSecurityHelper wXAPiSecurityHelper2 = wXAPiSecurityHelper;
                    Object object4 = object;
                    wXAPiSecurityHelper();
                    string = "state";
                    wXAPiSecurityHelper2.put(string, ((PromiseShareRule)object4).state);
                    string = "interval";
                    long l = ((PromiseShareRule)object3).getLegalReqInterval();
                    jSONObject.put(string, l);
                    string = "buffer";
                    if (((PromiseShareRule)object2).buffer.length() <= 64) break block15;
                    object = "";
                    break block16;
                }
                object = ((PromiseShareRule)object).buffer;
            }
            WXAPiSecurityHelper wXAPiSecurityHelper = wXAPiSecurityHelper;
            WXAPiSecurityHelper wXAPiSecurityHelper3 = wXAPiSecurityHelper;
            wXAPiSecurityHelper.put(string, object);
            string2 = wXAPiSecurityHelper3.toString();
            return string2;
        }
        if (((PromiseShareRule)object).state != 1) return string;
        string2 = wXAPiSecurityHelper.covertShareRule2Json((PromiseShareRule)object);
        return string2;
    }

    protected void commitSp(String string, String string2) {
        SharedPreferences.Editor editor = this.sp.edit();
        editor.putString(this.getStoreKey(string), string2);
        editor.commit();
    }

    protected String getLocalStoredJson(String string) {
        return this.getStoredData((String)string).respDataJson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WXSecurityData getStoredData(String string) {
        WXSecurityData wXSecurityData;
        WXAPiSecurityHelper wXAPiSecurityHelper = object;
        WXSecurityData wXSecurityData2 = wXSecurityData;
        wXSecurityData = new WXSecurityData();
        Log.d(TAG, "getStoredData, appid = " + string);
        try {
            String string2 = wXAPiSecurityHelper.getStoreKey(string);
            if (!wXAPiSecurityHelper.sp.contains(string2)) {
                Log.d(TAG, "getStoredData, fail, not exist!");
                return wXSecurityData2;
            }
            WXSecurityData wXSecurityData3 = wXSecurityData2;
            Object object = ((WXAPiSecurityHelper)object).sp.getString(((WXAPiSecurityHelper)object).getStoreKey(string), "");
            JSONObject jSONObject = new JSONObject((String)object);
            long l = jSONObject.optLong(SECURITY_KEY_TIMESTAMP_SECOND);
            object = jSONObject.optString(STORE_VALUE_DATA);
            wXSecurityData3.appid = string;
            wXSecurityData3.lastStoreTimeStampSecond = l;
            wXSecurityData3.respDataJson = object;
            Log.d(TAG, "getStoredData, Ok, appid = " + string + "timeStampSecond: " + wXSecurityData2.lastStoreTimeStampSecond);
            return wXSecurityData2;
        }
        catch (Exception exception) {
            Log.e(TAG, "getStoredData fail, ex = " + exception.getMessage());
        }
        return wXSecurityData2;
    }

    protected String covertShareRule2Json(PromiseShareRule promiseShareRule) {
        JSONArray jSONArray;
        Object object;
        Object object2;
        JSONObject jSONObject;
        Object object3;
        block26: {
            block25: {
                JSONObject jSONObject2;
                object3 = "";
                if (promiseShareRule == null) {
                    return object3;
                }
                PromiseShareRule promiseShareRule2 = promiseShareRule;
                jSONObject = jSONObject2;
                PromiseShareRule promiseShareRule3 = promiseShareRule;
                JSONObject jSONObject3 = jSONObject;
                PromiseShareRule promiseShareRule4 = promiseShareRule;
                JSONObject jSONObject4 = jSONObject;
                PromiseShareRule promiseShareRule5 = promiseShareRule;
                JSONObject jSONObject5 = jSONObject;
                PromiseShareRule promiseShareRule6 = promiseShareRule;
                jSONObject();
                object2 = "state";
                jSONObject5.put((String)object2, promiseShareRule6.state);
                object2 = "appid_rule";
                jSONObject4.put((String)object2, (Object)promiseShareRule5.appidInRule);
                object2 = "wait_time";
                long l = promiseShareRule4.userWaitTimeMs;
                jSONObject3.put((String)object2, l);
                object2 = "interval";
                l = promiseShareRule3.nextRequestIntervalSecond;
                jSONObject2.put((String)object2, l);
                object2 = "buffer";
                if (promiseShareRule2.buffer.length() <= 64) break block25;
                object = "";
                break block26;
            }
            object = promiseShareRule.buffer;
        }
        PromiseShareRule promiseShareRule7 = promiseShareRule;
        jSONObject.put((String)object2, object);
        promiseShareRule = jSONArray;
        jSONArray = new JSONArray();
        object2 = promiseShareRule7.urlRuleList.iterator();
        while (true) {
            if (!object2.hasNext()) break;
            PromiseShareRule promiseShareRule8 = promiseShareRule;
            object = (UrlRule)object2.next();
            Object object4 = object;
            JSONObject jSONObject6 = new JSONObject();
            String string = "host";
            jSONObject6.put(string, (Object)((UrlRule)object4).host);
            jSONObject6.put("querys", (Object)new JSONArray(((UrlRule)object).mustQueryKey));
            promiseShareRule8.put(jSONObject6);
        }
        JSONObject jSONObject7 = jSONObject;
        JSONObject jSONObject8 = jSONObject7;
        jSONObject7.put("rules", (Object)promiseShareRule);
        try {
            object3 = jSONObject8.toString();
        }
        catch (Exception exception) {
            Log.e(TAG, "covertShareRule2Json fail, ex = " + exception.getMessage());
        }
        return object3;
    }

    protected PromiseShareRule convert2ShareRule(String string, String string2) {
        block14: {
            int n;
            JSONObject jSONObject;
            PromiseShareRule promiseShareRule;
            PromiseShareRule promiseShareRule2 = promiseShareRule;
            promiseShareRule2();
            promiseShareRule2.reqAppid = string;
            promiseShareRule.orgJsonData = string2;
            if (b.b(string2)) {
                Log.d(TAG, "convert2ShareRule: jsonRespData is empty");
                return promiseShareRule2;
            }
            string = jSONObject;
            try {
                String string3 = string;
                string3(string2);
                promiseShareRule2.state = string3.optInt("state", 0);
                promiseShareRule2.appidInRule = string.optString("appid_rule", "");
                promiseShareRule2.userWaitTimeMs = string.optLong("wait_time", 0L);
                promiseShareRule2.nextRequestIntervalSecond = string.optLong("interval", 0L);
                promiseShareRule2.buffer = string.optString("buffer", "");
                string = jSONObject.optJSONArray("rules");
                if (string == null) break block14;
                n = 0;
            }
            catch (Exception exception) {
                Log.e(TAG, "coverJson2ShareRule fail, ex = " + exception.getMessage());
            }
            while (true) {
                UrlRule urlRule;
                block15: {
                    UrlRule urlRule2;
                    if (n >= string.length()) break block14;
                    JSONObject jSONObject2 = string.getJSONObject(n);
                    urlRule = urlRule2;
                    urlRule();
                    urlRule2.host = jSONObject2.optString("host");
                    jSONObject2 = jSONObject2.optJSONArray("querys");
                    if (jSONObject2 == null) break block15;
                    int n2 = 0;
                    while (true) {
                        block16: {
                            if (n2 >= jSONObject2.length()) break;
                            if (b.b(jSONObject2.optString(n2, ""))) break block16;
                            urlRule.mustQueryKey.add(jSONObject2.optString(n2, ""));
                        }
                        ++n2;
                    }
                }
                promiseShareRule2.urlRuleList.add(urlRule);
                ++n;
            }
        }
        return promiseShareRule2;
    }

    private static class UrlRule {
        String host = "";
        List<String> mustQueryKey;

        private UrlRule() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.mustQueryKey = arrayList2;
        }
    }

    private static class PromiseShareRule {
        String orgJsonData = "";
        String reqAppid = "";
        int state;
        String appidInRule = "";
        List<UrlRule> urlRuleList;
        long userWaitTimeMs;
        public long nextRequestIntervalSecond;
        String buffer;

        private PromiseShareRule() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.urlRuleList = arrayList2;
            v1.buffer = "";
        }

        public long getLegalUserWaitTime() {
            long l = 5000L;
            long l2 = this.userWaitTimeMs;
            if (l2 <= 100L || l2 >= 60000L) {
                l2 = l;
            }
            Log.d(WXAPiSecurityHelper.TAG, "getLegalUserWaitTime = " + l2);
            return l2;
        }

        public long getLegalReqInterval() {
            long l = 3600L;
            long l2 = this.nextRequestIntervalSecond;
            if (l2 <= 0L || l2 >= 86400L) {
                l2 = l;
            }
            Log.d(WXAPiSecurityHelper.TAG, "getLegalReqInterval = " + l2);
            return l2;
        }
    }

    private static class PassContext {
        String reqSessionId = "";
        String appid = "";
        String inputUrl = "";
        String version = "";
        PromiseShareRule localRule;

        private PassContext() {
            PromiseShareRule promiseShareRule;
            PromiseShareRule promiseShareRule2 = promiseShareRule;
            promiseShareRule = new PromiseShareRule();
            v1.localRule = promiseShareRule2;
        }
    }

    private static class CheckRuleResult {
        public static final int Unknown = 0;
        public static final int Pass = 1;
        public static final int NoPass = 2;

        private CheckRuleResult() {
        }
    }

    public static class ExtraSecurityCheckRes {
        public static final int Directly_Pass = 0;
        public static final int Directly_NoPass = 1;
        public static final int Need_Deep_Check = 2;
    }

    private static class RuleState {
        public static final int None = 0;
        public static final int InRule = 1;
        public static final int NotInRule = 2;

        private RuleState() {
        }
    }

    private static class WXSecurityData {
        long lastStoreTimeStampSecond;
        String appid = "";
        String respDataJson = "";

        private WXSecurityData() {
        }

        public boolean isBasicParamsAllowed() {
            WXSecurityData wXSecurityData = this;
            boolean bl = b.b(wXSecurityData.appid) ^ true;
            boolean bl2 = b.b(wXSecurityData.respDataJson) ^ true;
            long l = this.lastStoreTimeStampSecond;
            return l > 0L && l < System.currentTimeMillis() / 1000L && bl && bl2;
        }
    }

    static interface IHttpCheckCallback {
        public void onHttpCheckFinish(PromiseShareRule var1);
    }

    static interface ISecuritySyncCheck {
        public void onSyncCheckFinish(boolean var1);
    }

    static interface ISecurityCheck {
        public void onCheckFinish(boolean var1);
    }
}

