/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.utils.Log;

public class WXStateSceneDataObject
implements SendMessageToWX.IWXSceneDataObject {
    private static final String TAG = "MicroMsg.SDK.WXStateSceneDataObject";
    private static final String WX_STATE_JUMP_INFO_KEY_IDENTIFIER = "_wxapi_scene_data_state_jump_info_identifier";
    private static final int LENGTH_LIMIT = 10240;
    public String stateId;
    public String stateTitle;
    public String token;
    public IWXStateJumpInfo stateJumpInfo;

    @Override
    public void serialize(Bundle bundle) {
        bundle.putString("_wxapi_scene_data_state_id", this.stateId);
        bundle.putString("_wxapi_scene_data_state_title", this.stateTitle);
        bundle.putString("_wxapi_scene_data_state_token", this.token);
        IWXStateJumpInfo iWXStateJumpInfo = this.stateJumpInfo;
        if (iWXStateJumpInfo != null) {
            bundle.putString(WX_STATE_JUMP_INFO_KEY_IDENTIFIER, iWXStateJumpInfo.getClass().getName());
            this.stateJumpInfo.serialize(bundle);
        }
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.stateId = bundle.getString("_wxapi_scene_data_state_id");
        this.stateTitle = bundle.getString("_wxapi_scene_data_state_title");
        this.token = bundle.getString("_wxapi_scene_data_state_token");
        String string = bundle.getString(WX_STATE_JUMP_INFO_KEY_IDENTIFIER);
        if (string != null) {
            IWXStateJumpInfo iWXStateJumpInfo = (IWXStateJumpInfo)Class.forName(string).newInstance();
            try {
                this.stateJumpInfo = iWXStateJumpInfo;
                iWXStateJumpInfo.unserialize(bundle);
            }
            catch (Exception exception) {
                Log.e(TAG, "get WXSceneDataObject from bundle failed: unknown ident " + string + ", ex = " + exception.getMessage());
            }
        }
    }

    @Override
    public boolean checkArgs() {
        String string = ((WXStateSceneDataObject)((Object)iWXStateJumpInfo)).stateId;
        if (string != null && string.length() > 10240) {
            Log.e(TAG, "checkArgs fail, stateId is invalid");
            return false;
        }
        string = ((WXStateSceneDataObject)((Object)iWXStateJumpInfo)).stateTitle;
        if (string != null && string.length() > 10240) {
            Log.e(TAG, "checkArgs fail, stateId is invalid");
            return false;
        }
        string = ((WXStateSceneDataObject)((Object)iWXStateJumpInfo)).token;
        if (string != null && string.length() > 10240) {
            Log.e(TAG, "checkArgs fail, stateId is invalid");
            return false;
        }
        IWXStateJumpInfo iWXStateJumpInfo = ((WXStateSceneDataObject)((Object)iWXStateJumpInfo)).stateJumpInfo;
        if (iWXStateJumpInfo == null) {
            Log.e(TAG, "checkArgs fail, statsJumpInfo is null");
            return false;
        }
        return iWXStateJumpInfo.checkArgs();
    }

    @Override
    public int getJumpType() {
        IWXStateJumpInfo iWXStateJumpInfo = ((WXStateSceneDataObject)((Object)iWXStateJumpInfo)).stateJumpInfo;
        return iWXStateJumpInfo != null ? iWXStateJumpInfo.type() : 0;
    }

    public static interface IWXStateJumpInfo {
        public static final int WX_STATE_JUMP_TYPE_UNKNOWN = 0;
        public static final int WX_STATE_JUMP_TYPE_URL = 1;

        public int type();

        public void serialize(Bundle var1);

        public void unserialize(Bundle var1);

        public boolean checkArgs();
    }
}

