/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.c;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class MMSharedPreferences
implements SharedPreferences {
    private static final String TAG = "MicroMsg.SDK.SharedPreferences";
    private final ContentResolver cr;
    private final String[] columns = new String[]{"_id", "key", "type", "value"};
    private final HashMap<String, Object> values = new HashMap();
    private REditor editor = null;

    public MMSharedPreferences(Context context) {
        this.cr = context.getContentResolver();
    }

    private Object getValue(String string) {
        try {
            string = this.cr.query(c.b.CONTENT_URI, this.columns, "key = ?", new String[]{string}, null);
            if (string == null) {
                return null;
            }
            int n = string.getColumnIndex("type");
            int n2 = string.getColumnIndex("value");
            Object object = null;
            if (string.moveToFirst()) {
                object = c.a.a(string.getInt(n), string.getString(n2));
            }
            string.close();
            return object;
        }
        catch (Exception exception) {
            Log.e(TAG, "getValue exception:" + exception.getMessage());
            return null;
        }
    }

    public Map<String, ?> getAll() {
        try {
            Cursor cursor = this.cr.query(c.b.CONTENT_URI, this.columns, null, null, null);
            if (cursor == null) {
                return null;
            }
            int n = cursor.getColumnIndex("key");
            int n2 = cursor.getColumnIndex("type");
            int n3 = cursor.getColumnIndex("value");
            while (cursor.moveToNext()) {
                Object object = c.a.a(cursor.getInt(n2), cursor.getString(n3));
                this.values.put(cursor.getString(n), object);
            }
            cursor.close();
            return this.values;
        }
        catch (Exception exception) {
            Log.e(TAG, "getAll exception:" + exception.getMessage());
            return this.values;
        }
    }

    public String getString(String object, String string) {
        if ((object = this.getValue((String)object)) != null && object instanceof String) {
            return (String)object;
        }
        return string;
    }

    public int getInt(String object, int n) {
        if ((object = this.getValue((String)object)) != null && object instanceof Integer) {
            return (Integer)object;
        }
        return n;
    }

    public long getLong(String object, long l) {
        if ((object = this.getValue((String)object)) != null && object instanceof Long) {
            return (Long)object;
        }
        return l;
    }

    public float getFloat(String object, float f2) {
        if ((object = this.getValue((String)object)) != null && object instanceof Float) {
            return ((Float)object).floatValue();
        }
        return f2;
    }

    public boolean getBoolean(String object, boolean bl) {
        if ((object = this.getValue((String)object)) != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    public boolean contains(String string) {
        return this.getValue(string) != null;
    }

    public SharedPreferences.Editor edit() {
        if (this.editor == null) {
            this.editor = new REditor(this.cr);
        }
        return this.editor;
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
    }

    public Set<String> getStringSet(String string, Set<String> set) {
        return null;
    }

    private static class REditor
    implements SharedPreferences.Editor {
        private Map<String, Object> values = new HashMap<String, Object>();
        private Set<String> remove = new HashSet<String>();
        private boolean clear = false;
        private ContentResolver cr;

        public REditor(ContentResolver contentResolver) {
            this.cr = contentResolver;
        }

        public SharedPreferences.Editor putString(String string, String string2) {
            this.values.put(string, string2);
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor putInt(String string, int n) {
            this.values.put(string, n);
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor putLong(String string, long l) {
            this.values.put(string, l);
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor putFloat(String string, float f2) {
            this.values.put(string, Float.valueOf(f2));
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor putBoolean(String string, boolean bl) {
            this.values.put(string, bl);
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor remove(String string) {
            this.remove.add(string);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.clear = true;
            return this;
        }

        public boolean commit() {
            ContentValues contentValues = new ContentValues();
            if (this.clear) {
                this.cr.delete(c.b.CONTENT_URI, null, null);
                this.clear = false;
            }
            for (String string : this.remove) {
                this.cr.delete(c.b.CONTENT_URI, "key = ?", new String[]{string});
            }
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                boolean bl;
                int n;
                int n2;
                Object object = entry.getValue();
                ContentValues contentValues2 = contentValues;
                Object object2 = object;
                if (object2 == null) {
                    Log.e("MicroMsg.SDK.PluginProvider.Resolver", "unresolve failed, null value");
                    n2 = 0;
                } else if (object2 instanceof Integer) {
                    n2 = 1;
                } else if (object2 instanceof Long) {
                    n2 = 2;
                } else if (object2 instanceof String) {
                    n2 = 3;
                } else if (object2 instanceof Boolean) {
                    n2 = 4;
                } else if (object2 instanceof Float) {
                    n2 = 5;
                } else if (object2 instanceof Double) {
                    n2 = 6;
                } else {
                    Log.e("MicroMsg.SDK.PluginProvider.Resolver", "unresolve failed, unknown type=" + object2.getClass().toString());
                    n2 = n = 0;
                }
                if (n2 == 0) {
                    bl = false;
                } else {
                    contentValues2.put("type", Integer.valueOf(n));
                    contentValues2.put("value", object.toString());
                    bl = true;
                }
                if (!bl) continue;
                this.cr.update(c.b.CONTENT_URI, contentValues, "key = ?", new String[]{entry.getKey()});
            }
            return true;
        }

        public void apply() {
        }

        public SharedPreferences.Editor putStringSet(String string, Set<String> set) {
            return null;
        }
    }
}

