/*
 * Decompiled with CFR 0.152.
 */
package tinker.net.dongliu.apk.parser.parser;

import tinker.net.dongliu.apk.parser.bean.ApkMeta;
import tinker.net.dongliu.apk.parser.bean.GlEsVersion;
import tinker.net.dongliu.apk.parser.bean.Permission;
import tinker.net.dongliu.apk.parser.bean.UseFeature;
import tinker.net.dongliu.apk.parser.parser.XmlStreamer;
import tinker.net.dongliu.apk.parser.struct.xml.Attribute;
import tinker.net.dongliu.apk.parser.struct.xml.Attributes;
import tinker.net.dongliu.apk.parser.struct.xml.XmlCData;
import tinker.net.dongliu.apk.parser.struct.xml.XmlNamespaceEndTag;
import tinker.net.dongliu.apk.parser.struct.xml.XmlNamespaceStartTag;
import tinker.net.dongliu.apk.parser.struct.xml.XmlNodeEndTag;
import tinker.net.dongliu.apk.parser.struct.xml.XmlNodeStartTag;

public class ApkMetaTranslator
implements XmlStreamer {
    private String[] tagStack = new String[100];
    private int depth = 0;
    private ApkMeta apkMeta = new ApkMeta();

    @Override
    public void onStartTag(XmlNodeStartTag xmlNodeStartTag) {
        Attributes attributes = xmlNodeStartTag.getAttributes();
        switch (xmlNodeStartTag.getName()) {
            case "application": {
                String icon;
                String label = attributes.get("label");
                if (label != null) {
                    this.apkMeta.setLabel(label);
                }
                if ((icon = attributes.get("icon")) == null) break;
                this.apkMeta.setIcon(icon);
                break;
            }
            case "manifest": {
                this.apkMeta.setPackageName(attributes.get("package"));
                this.apkMeta.setVersionName(attributes.get("versionName"));
                this.apkMeta.setVersionCode(attributes.getLong("versionCode"));
                String installLocation = attributes.get("installLocation");
                if (installLocation == null) break;
                this.apkMeta.setInstallLocation(installLocation);
                break;
            }
            case "uses-sdk": {
                this.apkMeta.setMinSdkVersion(attributes.get("minSdkVersion"));
                this.apkMeta.setTargetSdkVersion(attributes.get("targetSdkVersion"));
                this.apkMeta.setMaxSdkVersion(attributes.get("maxSdkVersion"));
                break;
            }
            case "supports-screens": {
                this.apkMeta.setAnyDensity(attributes.getBoolean("anyDensity", false));
                this.apkMeta.setSmallScreens(attributes.getBoolean("smallScreens", false));
                this.apkMeta.setNormalScreens(attributes.getBoolean("normalScreens", false));
                this.apkMeta.setLargeScreens(attributes.getBoolean("largeScreens", false));
                break;
            }
            case "uses-feature": {
                String name = attributes.get("name");
                boolean required = attributes.getBoolean("required", false);
                if (name != null) {
                    UseFeature useFeature = new UseFeature();
                    useFeature.setName(name);
                    useFeature.setRequired(required);
                    this.apkMeta.addUseFeatures(useFeature);
                    break;
                }
                Integer gl = attributes.getInt("glEsVersion");
                if (gl == null) break;
                int v = gl;
                GlEsVersion glEsVersion = new GlEsVersion();
                glEsVersion.setMajor(v >> 16);
                glEsVersion.setMinor(v & 0xFFFF);
                glEsVersion.setRequired(required);
                this.apkMeta.setGlEsVersion(glEsVersion);
                break;
            }
            case "uses-permission": {
                this.apkMeta.addUsesPermission(attributes.get("name"));
                break;
            }
            case "permission": {
                Permission permission = new Permission();
                permission.setName(attributes.get("name"));
                permission.setLabel(attributes.get("label"));
                permission.setIcon(attributes.get("icon"));
                permission.setGroup(attributes.get("group"));
                permission.setDescription(attributes.get("description"));
                String protectionLevel = attributes.get("android:protectionLevel");
                if (protectionLevel != null) {
                    permission.setProtectionLevel(protectionLevel);
                }
                this.apkMeta.addPermission(permission);
            }
        }
        this.tagStack[this.depth++] = xmlNodeStartTag.getName();
    }

    @Override
    public void onAttribute(Attribute attribute) {
    }

    @Override
    public void onEndTag(XmlNodeEndTag xmlNodeEndTag) {
        --this.depth;
    }

    @Override
    public void onCData(XmlCData xmlCData) {
    }

    @Override
    public void onNamespaceStart(XmlNamespaceStartTag tag) {
    }

    @Override
    public void onNamespaceEnd(XmlNamespaceEndTag tag) {
    }

    public ApkMeta getApkMeta() {
        return this.apkMeta;
    }

    private boolean matchTagPath(String ... tags) {
        if (this.depth != tags.length + 1) {
            return false;
        }
        for (int i = 1; i < this.depth; ++i) {
            if (this.tagStack[i].equals(tags[i - 1])) continue;
            return false;
        }
        return true;
    }

    private boolean matchLastTag(String tag) {
        return this.tagStack[this.depth - 1].endsWith(tag);
    }
}

