/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.geolocation;

import android.os.SystemClock;
import android.text.TextUtils;
import java.util.Locale;

public class TencentGeofence {
    private final int a;
    private final double b;
    private final double c;
    private final float d;
    private final long e;
    private final String f;
    private final long g;

    private TencentGeofence(int n2, double d2, double d3, float f2, long l2, String string) {
        this.a = n2;
        this.b = d2;
        this.c = d3;
        this.d = f2;
        this.g = l2;
        this.e = SystemClock.elapsedRealtime() + l2;
        this.f = string;
    }

    public double getLatitude() {
        return this.b;
    }

    public double getLongitude() {
        return this.c;
    }

    public float getRadius() {
        return this.d;
    }

    public long getExpireAt() {
        return this.e;
    }

    public long getDuration() {
        return this.g;
    }

    public String getTag() {
        return this.f;
    }

    private static void a(int n2) {
        if (n2 != 0) {
            throw new IllegalArgumentException("invalid type: " + n2);
        }
    }

    private static String b(int n2) {
        switch (n2) {
            case 0: {
                return "CIRCLE";
            }
        }
        TencentGeofence.a(n2);
        return null;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.b);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.c);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        n3 = 31 * n3 + (this.f == null ? 0 : this.f.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TencentGeofence tencentGeofence = (TencentGeofence)object;
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(tencentGeofence.b)) {
            return false;
        }
        if (Double.doubleToLongBits(this.c) != Double.doubleToLongBits(tencentGeofence.c)) {
            return false;
        }
        return !(this.f == null ? tencentGeofence.f != null : !this.f.equals(tencentGeofence.f));
    }

    public String toString() {
        return String.format(Locale.US, "TencentGeofence[tag=%s, type=%s, loc=(%.6f, %.6f), radius=%.2fm life=%.2fs]", this.f, TencentGeofence.b(this.a), this.b, this.c, Float.valueOf(this.d), (double)(this.e - SystemClock.elapsedRealtime()) / 1000.0);
    }

    public static class Builder {
        private double a;
        private double b;
        private float c;
        private long d;
        private String e;

        public Builder setCircularRegion(double d2, double d3, float f2) {
            Builder.a(f2);
            Builder.a(d2, d3);
            this.a = d2;
            this.b = d3;
            this.c = f2;
            return this;
        }

        public Builder setExpirationDuration(long l2) {
            Builder.a(l2);
            this.d = l2;
            return this;
        }

        public Builder setTag(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new NullPointerException();
            }
            this.e = string;
            return this;
        }

        public TencentGeofence build() {
            return new TencentGeofence(0, this.a, this.b, this.c, this.d, this.e);
        }

        private static void a(long l2) {
            if (l2 < 0L) {
                throw new IllegalArgumentException("invalid duration: " + l2);
            }
        }

        private static void a(float f2) {
            if (f2 <= 0.0f) {
                throw new IllegalArgumentException("invalid radius: " + f2);
            }
        }

        private static void a(double d2, double d3) {
            if (d2 > 90.0 || d2 < -90.0) {
                throw new IllegalArgumentException("invalid latitude: " + d2);
            }
            if (d3 > 180.0 || d3 < -180.0) {
                throw new IllegalArgumentException("invalid longitude: " + d3);
            }
        }
    }
}

