/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import java.util.ArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.jmx.AbstractMBean;
import org.hyperic.sigar.jmx.ReflectedMBean;
import org.hyperic.sigar.jmx.SigarLoadAverage;
import org.hyperic.sigar.jmx.SigarRegistryMBean;

public class SigarRegistry
implements MBeanRegistration,
SigarRegistryMBean {
    public static final String MBEAN_DOMAIN = "sigar";
    public static final String MBEAN_ATTR_TYPE = "Type";
    private static final String MBEAN_TYPE = "SigarRegistry";
    private static final int CACHE_EXPIRE = 60000;
    private Sigar sigarImpl;
    private SigarProxy sigar;
    private String objectName;
    private ArrayList managedBeans;
    private MBeanServer mbeanServer;

    public SigarRegistry() {
    }

    public SigarRegistry(SigarProxy sigar) {
        this.init(sigar);
    }

    private void init(SigarProxy sigar) {
        this.sigar = sigar;
        this.objectName = "sigar:Type=SigarRegistry";
        this.managedBeans = new ArrayList();
    }

    public String getObjectName() {
        return this.objectName;
    }

    private void registerMBean(AbstractMBean mbean) {
        try {
            ObjectName name = new ObjectName(mbean.getObjectName());
            if (this.mbeanServer.isRegistered(name)) {
                return;
            }
            ObjectInstance instance = this.mbeanServer.registerMBean(mbean, name);
            this.managedBeans.add(instance.getObjectName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.sigar == null) {
            this.sigarImpl = new Sigar();
            this.init(SigarProxyCache.newInstance(this.sigarImpl, 60000));
        }
        this.mbeanServer = server;
        if (name == null) {
            return new ObjectName(this.getObjectName());
        }
        return name;
    }

    public void postRegister(Boolean success) {
        ReflectedMBean mbean;
        CpuInfo[] info;
        if (!success.booleanValue()) {
            return;
        }
        try {
            info = this.sigar.getCpuInfoList();
        }
        catch (SigarException e) {
            info = new CpuInfo[]{};
        }
        for (int i = 0; i < info.length; ++i) {
            String idx = String.valueOf(i);
            mbean = new ReflectedMBean(this.sigar, "CpuCore", idx);
            mbean.setType("CpuList");
            this.registerMBean(mbean);
            mbean = new ReflectedMBean(this.sigar, "CpuCoreUsage", idx);
            mbean.setType("CpuPercList");
            this.registerMBean(mbean);
        }
        mbean = new ReflectedMBean(this.sigar, "Cpu");
        mbean.putAttributes(info[0]);
        this.registerMBean(mbean);
        mbean = new ReflectedMBean(this.sigar, "CpuUsage");
        mbean.setType("CpuPerc");
        this.registerMBean(mbean);
        try {
            FileSystem[] fslist = this.sigar.getFileSystemList();
            for (int i = 0; i < fslist.length; ++i) {
                FileSystem fs = fslist[i];
                if (fs.getType() != 2) continue;
                String name = fs.getDirName();
                mbean = new ReflectedMBean(this.sigar, "FileSystem", name);
                mbean.setType(mbean.getType() + "Usage");
                mbean.putAttributes(fs);
                this.registerMBean(mbean);
            }
        }
        catch (SigarException fslist) {
            // empty catch block
        }
        try {
            String[] ifnames = this.sigar.getNetInterfaceList();
            for (int i = 0; i < ifnames.length; ++i) {
                String name = ifnames[i];
                NetInterfaceConfig ifconfig = this.sigar.getNetInterfaceConfig(name);
                try {
                    this.sigar.getNetInterfaceStat(name);
                }
                catch (SigarException e) {
                    continue;
                }
                mbean = new ReflectedMBean(this.sigar, "NetInterface", name);
                mbean.setType(mbean.getType() + "Stat");
                mbean.putAttributes(ifconfig);
                this.registerMBean(mbean);
            }
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        mbean = new ReflectedMBean(this.sigar, "NetInfo");
        try {
            mbean.putAttribute("FQDN", this.sigar.getFQDN());
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        this.registerMBean(mbean);
        this.registerMBean(new ReflectedMBean(this.sigar, "Mem"));
        this.registerMBean(new ReflectedMBean(this.sigar, "Swap"));
        this.registerMBean(new SigarLoadAverage(this.sigar));
        this.registerMBean(new ReflectedMBean(this.sigar, "ProcStat"));
        this.registerMBean(new ReflectedMBean(this.sigar, "SigarVersion"));
    }

    public void preDeregister() throws Exception {
        for (int i = this.managedBeans.size() - 1; i >= 0; --i) {
            ObjectName next = (ObjectName)this.managedBeans.remove(i);
            if (!this.mbeanServer.isRegistered(next)) continue;
            try {
                this.mbeanServer.unregisterMBean(next);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void postDeregister() {
        this.mbeanServer = null;
        if (this.sigarImpl != null) {
            this.sigarImpl.close();
            this.sigarImpl = null;
            this.sigar = null;
        }
    }
}

