/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.memory.leakdetect;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.tencent.bugly.common.utils.AndroidVersion;
import com.tencent.rmonitor.common.logger.Logger;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

public class ActivityLeakSolution {
    private static boolean Dr = false;

    public static void setSwitchLeakSolution(boolean bl2) {
        Dr = bl2;
    }

    public static void fixInputMethodManagerLeak(@Nullable Context context) {
        if (!Dr) {
            return;
        }
        if (context == null) {
            return;
        }
        InputMethodManager inputMethodManager = null;
        try {
            inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception("RMonitor_MemoryLeak_ActivityLeakSolution", throwable);
        }
        if (inputMethodManager == null) {
            return;
        }
        String[] stringArray = new String[]{"mCurRootView", "mServedView", "mNextServedView"};
        for (int i2 = 0; i2 < 3; ++i2) {
            Object object = stringArray[i2];
            try {
                Object object2;
                object = inputMethodManager.getClass().getDeclaredField((String)object);
                if (!((AccessibleObject)object).isAccessible()) {
                    ((Field)object).setAccessible(true);
                }
                if (!((object2 = ((Field)object).get(inputMethodManager)) instanceof View)) continue;
                if ((object2 = (View)object2).getContext() == context) {
                    ((Field)object).set(inputMethodManager, null);
                    continue;
                }
                Logger.INSTANCE.d("RMonitor_MemoryLeak_ActivityLeakSolution", "fixInputMethodManagerLeak break, context not suitable", ", get_context=", object2.getContext().toString(), ", dest_context=", context.toString());
                return;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception("RMonitor_MemoryLeak_ActivityLeakSolution", throwable);
            }
        }
    }

    public static void fixAudioManagerLeak(@NonNull Context context) {
        if (!Dr || AndroidVersion.isOverM()) {
            return;
        }
        try {
            context = (AudioManager)context.getSystemService("audio");
            Field field = context.getClass().getDeclaredField("mContext");
            field.setAccessible(true);
            field.set(context, null);
            return;
        }
        catch (Exception exception) {
            Logger.INSTANCE.e("RMonitor_MemoryLeak_ActivityLeakSolution", exception.toString());
            return;
        }
    }
}

