/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.tencent.rmonitor.base.meta.BaseInfo;
import com.tencent.rmonitor.common.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0015\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0019\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/tencent/rmonitor/common/util/AppVersionHelper;", "", "()V", "META_BUGLY_APP_VERSION", "", "META_RDM_UUID", "TAG", "appVersion", "appVersionFromMeta", "buildNo", "buildNoFromMeta", "hasParseMetadata", "", "hasParsePackageInfo", "manifestVersionCode", "manifestVersionName", "userSetAppVersion", "apkInDebug", "context", "Landroid/content/Context;", "checkAndGetAppVersion", "checkAndGetUuid", "checkAppVersion", "", "parseAppVersionFromPackageInfo", "parseMetaData", "setProductVersion", "productVersion", "setRdmUuid", "rdmUuid", "bugly-pro_release"})
public final class AppVersionHelper {
    private static final String TAG = "RMonitor_AppVersionHelper";
    @NotNull
    public static final String META_BUGLY_APP_VERSION = "BUGLY_APP_VERSION";
    @NotNull
    public static final String META_RDM_UUID = "com.tencent.rdm.uuid";
    private static String appVersion;
    private static boolean userSetAppVersion;
    private static String buildNo;
    private static String manifestVersionName;
    private static String manifestVersionCode;
    private static boolean hasParsePackageInfo;
    private static String appVersionFromMeta;
    private static String buildNoFromMeta;
    private static boolean hasParseMetadata;
    public static final AppVersionHelper INSTANCE;

    private final void parseAppVersionFromPackageInfo(Context context) {
        if (context == null) {
            Logger.INSTANCE.i(TAG, "parseAppVersionFromPackageInfo for context is null");
            return;
        }
        if (hasParsePackageInfo) {
            return;
        }
        hasParsePackageInfo = true;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            if (packageInfo != null) {
                context = packageInfo;
                String string = packageInfo.versionName;
                if (string == null) {
                    string = "";
                }
                manifestVersionName = string;
                manifestVersionCode = String.valueOf(context.versionCode);
            }
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception(TAG, throwable);
        }
        Logger.INSTANCE.i(TAG, "parseAppVersionFromPackageInfo, manifestVersionName: " + manifestVersionName + ", manifestVersionCode: " + manifestVersionCode);
    }

    private final void parseMetaData(Context object) {
        if (object == null) {
            Logger.INSTANCE.i(TAG, "parseMetaData fail for context is null");
            return;
        }
        if (hasParseMetadata) {
            return;
        }
        hasParseMetadata = true;
        try {
            ApplicationInfo applicationInfo = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"manager.getApplicationIn\u2026ageManager.GET_META_DATA)");
            object = applicationInfo;
            if (applicationInfo.metaData != null) {
                Object object2;
                Object object3 = ((ApplicationInfo)object).metaData.get(META_BUGLY_APP_VERSION);
                object = ((ApplicationInfo)object).metaData.get(META_RDM_UUID);
                Object object4 = object3;
                if (object4 == null || (object4 = object4.toString()) == null) {
                    object4 = appVersionFromMeta = "";
                }
                if ((object2 = object) == null || (object2 = object2.toString()) == null) {
                    object2 = "";
                }
                buildNoFromMeta = object2;
            }
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception(TAG, throwable);
        }
        Logger.INSTANCE.i(TAG, "parseMetaData, appVersionFromMeta: " + appVersionFromMeta + ", buildNoFromMeta: " + buildNoFromMeta);
    }

    private final void checkAppVersion() {
        if (userSetAppVersion) {
            Logger.INSTANCE.i(TAG, "checkAppVersion for userSetVersion is true");
            return;
        }
        String string = appVersion;
        if (string == null || ((CharSequence)string).length() == 0) {
            Logger.INSTANCE.i(TAG, "checkAppVersion for versionName is null or empty");
            return;
        }
        int n2 = 0;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        int n3 = cArray2.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (cArray2[i2] != '.') continue;
            ++n2;
        }
        if (n2 < 3) {
            string = string + '.' + manifestVersionCode;
            Logger.INSTANCE.i(TAG, "checkAppVersion, old:" + appVersion + ", new: " + string);
            appVersion = string;
        }
    }

    public final void setProductVersion(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"productVersion");
        Logger.INSTANCE.i(TAG, "setProductVersion, old:" + appVersion + ", new: " + string);
        if (((CharSequence)string).length() == 0) {
            appVersion = "";
            BaseInfo.userMeta.appVersion = "";
            userSetAppVersion = false;
            hasParseMetadata = false;
            hasParsePackageInfo = false;
            return;
        }
        appVersion = string;
        BaseInfo.userMeta.appVersion = string;
        userSetAppVersion = true;
    }

    public final void setRdmUuid(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"rdmUuid");
        Logger.INSTANCE.i(TAG, "setRdmUuid, old:" + buildNo + ", new: " + string);
        if (((CharSequence)string).length() == 0) {
            buildNo = "";
            BaseInfo.userMeta.buildNumber = "";
            hasParseMetadata = false;
            return;
        }
        buildNo = string;
        BaseInfo.userMeta.buildNumber = string;
    }

    @NotNull
    public final String checkAndGetUuid(@Nullable Context context) {
        if (TextUtils.isEmpty((CharSequence)buildNo)) {
            this.parseMetaData(context);
            if (!TextUtils.isEmpty((CharSequence)buildNoFromMeta)) {
                buildNo = buildNoFromMeta;
            }
        }
        return buildNo;
    }

    @NotNull
    public final String checkAndGetAppVersion(@Nullable Context context) {
        if (TextUtils.isEmpty((CharSequence)appVersion)) {
            this.parseAppVersionFromPackageInfo(context);
            if (!TextUtils.isEmpty((CharSequence)manifestVersionName)) {
                appVersion = manifestVersionName;
            }
            this.parseMetaData(context);
            if (!TextUtils.isEmpty((CharSequence)appVersionFromMeta)) {
                appVersion = appVersionFromMeta;
            }
        }
        this.checkAppVersion();
        return appVersion;
    }

    public final boolean apkInDebug(@Nullable Context context) {
        boolean bl2;
        if (context == null) {
            return false;
        }
        try {
            context = context.getApplicationInfo();
            bl2 = context != null && (context.flags & 2) != 0;
        }
        catch (Throwable throwable) {
            bl2 = false;
        }
        return bl2;
    }

    private AppVersionHelper() {
    }

    static {
        INSTANCE = new AppVersionHelper();
        appVersion = "";
        buildNo = "";
        manifestVersionName = "";
        manifestVersionCode = "";
        appVersionFromMeta = "";
        buildNoFromMeta = "";
    }
}

