/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Debug;
import android.text.TextUtils;
import com.tencent.bugly.common.utils.ProcessUtil;
import com.tencent.rmonitor.common.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/tencent/rmonitor/common/util/AppInfo;", "", "()V", "Companion", "PssInfo", "bugly-pro_release"})
public final class AppInfo {
    private static final String TAG = "RMonitor_common_AppInfo";
    private static final long PSS_INFO_VALIDATE_IN_MILLIS = 10000L;
    private static PssInfo pssInfo;
    private static String appName;
    public static final Companion Companion;

    static {
        Companion = new Companion(0);
        pssInfo = new PssInfo();
        appName = "";
    }

    public static final /* synthetic */ void access$setPssInfo$cp(PssInfo pssInfo) {
        AppInfo.pssInfo = pssInfo;
    }

    @JvmStatic
    @NotNull
    public static final String obtainProcessName(@Nullable Context context) {
        return com.tencent.rmonitor.common.util.AppInfo$Companion.gl();
    }

    @JvmStatic
    @NotNull
    public static final String obtainProcessPackageName(@Nullable Context context) {
        return com.tencent.rmonitor.common.util.AppInfo$Companion.obtainProcessPackageName(context);
    }

    @JvmStatic
    @NotNull
    public static final String getAppName(@Nullable Context context) {
        return com.tencent.rmonitor.common.util.AppInfo$Companion.getAppName(context);
    }

    @JvmStatic
    public static final long getPssMemory() {
        return com.tencent.rmonitor.common.util.AppInfo$Companion.getPssMemory();
    }

    @JvmStatic
    public static final boolean isApkInDebug(@NotNull Context context) {
        return com.tencent.rmonitor.common.util.AppInfo$Companion.isApkInDebug(context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/tencent/rmonitor/common/util/AppInfo$PssInfo;", "", "()V", "pssSize", "", "getPssSize", "()J", "setPssSize", "(J)V", "timeStamp", "getTimeStamp", "setTimeStamp", "bugly-pro_release"})
    public static final class PssInfo {
        private long pssSize;
        private long timeStamp;

        public final long getPssSize() {
            return this.pssSize;
        }

        public final void setPssSize(long l2) {
            this.pssSize = l2;
        }

        public final long getTimeStamp() {
            return this.timeStamp;
        }

        public final void setTimeStamp(long l2) {
            this.timeStamp = l2;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010\u0012\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/tencent/rmonitor/common/util/AppInfo$Companion;", "", "()V", "PSS_INFO_VALIDATE_IN_MILLIS", "", "TAG", "", "appName", "pssInfo", "Lcom/tencent/rmonitor/common/util/AppInfo$PssInfo;", "getAppName", "context", "Landroid/content/Context;", "getPssMemory", "isApkInDebug", "", "obtainProcessName", "ctx", "obtainProcessPackageName", "bugly-pro_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public static String gl() {
            return ProcessUtil.Companion.aS();
        }

        @JvmStatic
        @NotNull
        public static String obtainProcessPackageName(@Nullable Context context) {
            if (context != null) {
                String string = context.getPackageName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ctx.packageName");
                return string;
            }
            return "";
        }

        @JvmStatic
        @NotNull
        public static String getAppName(@Nullable Context context) {
            CharSequence charSequence;
            if (!TextUtils.isEmpty((CharSequence)appName)) {
                return appName;
            }
            CharSequence charSequence2 = null;
            Context context2 = context;
            if (context2 != null) {
                context = context2;
                try {
                    ApplicationInfo applicationInfo = context.getApplicationInfo();
                    charSequence2 = context.getPackageManager().getApplicationLabel(applicationInfo);
                }
                catch (Throwable throwable) {
                    Logger.INSTANCE.exception(AppInfo.TAG, throwable);
                }
            }
            if ((charSequence = charSequence2) == null) {
                charSequence = "";
            }
            appName = String.valueOf(charSequence);
            Logger.INSTANCE.d(AppInfo.TAG, "getAppName, name: " + appName);
            return appName;
        }

        @JvmStatic
        public static long getPssMemory() {
            try {
                long l2 = System.currentTimeMillis();
                if (l2 - pssInfo.getTimeStamp() < 10000L) {
                    return pssInfo.getPssSize() * 1024L;
                }
                pssInfo.setTimeStamp(l2);
                pssInfo.setPssSize(Debug.getPss());
                return pssInfo.getPssSize() * 1024L;
            }
            catch (Exception exception) {
                Logger.INSTANCE.exception(AppInfo.TAG, exception);
                return 0L;
            }
        }

        @JvmStatic
        public static boolean isApkInDebug(@NotNull Context context) {
            boolean bl2;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                bl2 = (context.getApplicationInfo().flags & 2) != 0;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.exception(AppInfo.TAG, throwable);
                bl2 = false;
            }
            return bl2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(byte by2) {
            this();
        }
    }
}

