/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.utils;

import android.support.annotation.Keep;
import com.tencent.rmonitor.common.logger.Logger;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0006J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/tencent/bugly/common/utils/RecyclablePool;", "", "clz", "Ljava/lang/Class;", "Lcom/tencent/bugly/common/utils/RecyclablePool$Recyclable;", "cap", "", "(Ljava/lang/Class;I)V", "capacity", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "obtainCount", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "recycleCount", "getObtainCount", "getRecycleCount", "obtain", "recycle", "", "recyclableObject", "Companion", "Recyclable", "bugly-pro_release"})
@Keep
public final class RecyclablePool {
    private final ConcurrentLinkedQueue<Recyclable> queue;
    private final int capacity;
    private AtomicInteger count;
    private AtomicInteger obtainCount;
    private AtomicInteger recycleCount;
    @NotNull
    public static final String TAG = "Bugly_RPool";
    public static final Companion Companion = new Companion(0);

    @Nullable
    public final Recyclable obtain(@NotNull Class<? extends Recyclable> clazz) {
        Recyclable recyclable;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clz");
        this.obtainCount.incrementAndGet();
        Recyclable recyclable2 = null;
        if (!((Collection)this.queue).isEmpty() && (recyclable2 = this.queue.poll()) != null) {
            recyclable = recyclable2;
            this.count.decrementAndGet();
            if (recyclable.isInPool()) {
                recyclable.outPool();
            } else {
                recyclable2 = null;
                Logger.INSTANCE.e(TAG, "recyclable object not in pool");
            }
        }
        try {
            Recyclable recyclable3 = recyclable2;
            if (recyclable3 == null) {
                recyclable3 = clazz.newInstance();
            }
            recyclable = recyclable3;
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.e(TAG, String.valueOf(throwable));
            recyclable = null;
        }
        return recyclable;
    }

    public final void recycle(@Nullable Recyclable recyclable) {
        this.recycleCount.incrementAndGet();
        Recyclable recyclable2 = recyclable;
        if (recyclable2 != null) {
            recyclable = recyclable2;
            if (recyclable2.isInPool()) {
                Logger.INSTANCE.e(TAG, "recyclable object already in pool");
                return;
            }
            recyclable.reset();
            if (this.count.get() < this.capacity && this.queue.offer(recyclable)) {
                this.count.incrementAndGet();
                recyclable.inPool();
            }
            return;
        }
    }

    public final int getObtainCount() {
        return this.obtainCount.get();
    }

    public final int getRecycleCount() {
        return this.recycleCount.get();
    }

    public RecyclablePool(@NotNull Class<? extends Recyclable> clazz, int n2) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clz");
        this.queue = new ConcurrentLinkedQueue();
        this.capacity = n2;
        this.count = new AtomicInteger();
        this.obtainCount = new AtomicInteger();
        this.recycleCount = new AtomicInteger();
        int n3 = this.capacity;
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                this.recycle(clazz.newInstance());
                continue;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.e(TAG, "init ".concat(String.valueOf(throwable)));
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\u0006J\b\u0010\b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/tencent/bugly/common/utils/RecyclablePool$Recyclable;", "", "()V", "isInPool", "", "inPool", "", "outPool", "reset", "bugly-pro_release"})
    @Keep
    public static class Recyclable {
        private boolean isInPool;

        public void reset() {
        }

        public final boolean isInPool() {
            return this.isInPool;
        }

        public final void inPool() {
            this.isInPool = true;
        }

        public final void outPool() {
            this.isInPool = false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/bugly/common/utils/RecyclablePool$Companion;", "", "()V", "TAG", "", "bugly-pro_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by2) {
            this();
        }
    }
}

