/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.replay;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.tencent.bugly.common.replay.BuglyReplayOptions;
import com.tencent.bugly.common.replay.GeneratedVideo;
import com.tencent.bugly.common.replay.ReplayCache;
import com.tencent.bugly.common.replay.ReplayFrame;
import com.tencent.bugly.common.replay.video.MuxerConfig;
import com.tencent.bugly.common.replay.video.SimpleVideoEncoder;
import com.tencent.bugly.proguard.bo;
import com.tencent.rmonitor.common.logger.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b)J\"\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u0006J\b\u0010+\u001a\u00020#H\u0016JJ\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00142\b\b\u0002\u00105\u001a\u00020\u001aJ\u0010\u00106\u001a\u00020#2\u0006\u00107\u001a\u00020\u001aH\u0002J\u0012\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010\rH\u0002J\u001f\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020\u00062\b\u0010=\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b>J\u0017\u0010?\u001a\u0004\u0018\u00010\u00062\u0006\u0010@\u001a\u00020'H\u0000\u00a2\u0006\u0002\bAR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u001a8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001f\u001a\u0004\u0018\u00010\u001a8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001e\u001a\u0004\b \u0010\u001c\u00a8\u0006B"}, d2={"Lcom/tencent/bugly/common/replay/ReplayCache;", "Ljava/io/Closeable;", "options", "Lcom/tencent/bugly/common/replay/BuglyReplayOptions;", "(Lcom/tencent/bugly/common/replay/BuglyReplayOptions;)V", "TAG", "", "encoder", "Lcom/tencent/bugly/common/replay/video/SimpleVideoEncoder;", "encoderLock", "Lcom/tencent/bugly/common/replay/tool/AutoClosableReentrantLock;", "frames", "", "Lcom/tencent/bugly/common/replay/ReplayFrame;", "getFrames$bugly_pro_release", "()Ljava/util/List;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "maxFrameCount", "", "getMaxFrameCount$bugly_pro_release", "()I", "ongoingSegment", "Ljava/util/LinkedHashMap;", "ongoingSegmentFile", "Ljava/io/File;", "getOngoingSegmentFile$bugly_pro_release", "()Ljava/io/File;", "ongoingSegmentFile$delegate", "Lkotlin/Lazy;", "replayCacheDir", "getReplayCacheDir$bugly_pro_release", "replayCacheDir$delegate", "addFrame", "", "bitmap", "Landroid/graphics/Bitmap;", "frameTimestamp", "", "screen", "addFrame$bugly_pro_release", "screenshot", "close", "createVideoOf", "Lcom/tencent/bugly/common/replay/GeneratedVideo;", "duration", "from", "segmentId", "height", "width", "frameRate", "bitRate", "videoFile", "deleteFile", "file", "encode", "", "frame", "persistSegmentValues", "key", "value", "persistSegmentValues$bugly_pro_release", "rotate", "until", "rotate$bugly_pro_release", "bugly-pro_release"})
public final class ReplayCache
implements Closeable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final String TAG = "ReplayCache";
    private final AtomicBoolean isClosed;
    private final bo encoderLock;
    private final bo lock;
    private SimpleVideoEncoder encoder;
    @Nullable
    private final Lazy replayCacheDir$delegate;
    @NotNull
    private final List<ReplayFrame> frames;
    private final int maxFrameCount = 30;
    private final LinkedHashMap<String, String> ongoingSegment;
    @Nullable
    private final Lazy ongoingSegmentFile$delegate;
    private final BuglyReplayOptions options;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ReplayCache.class), "replayCacheDir", "getReplayCacheDir$bugly_pro_release()Ljava/io/File;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ReplayCache.class), "ongoingSegmentFile", "getOngoingSegmentFile$bugly_pro_release()Ljava/io/File;"))};
    }

    @Nullable
    public final File getReplayCacheDir$bugly_pro_release() {
        return (File)this.replayCacheDir$delegate.getValue();
    }

    @NotNull
    public final List<ReplayFrame> getFrames$bugly_pro_release() {
        return this.frames;
    }

    public final int getMaxFrameCount$bugly_pro_release() {
        return this.maxFrameCount;
    }

    @Nullable
    public final File getOngoingSegmentFile$bugly_pro_release() {
        return (File)this.ongoingSegmentFile$delegate.getValue();
    }

    public final void addFrame$bugly_pro_release(@NotNull Bitmap bitmap, long l2, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        if (this.getReplayCacheDir$bugly_pro_release() == null || bitmap.isRecycled()) {
            return;
        }
        File file = this.getReplayCacheDir$bugly_pro_release();
        if (file != null) {
            file.mkdirs();
        }
        Object object = new File(this.getReplayCacheDir$bugly_pro_release(), l2 + ".jpg");
        ((File)object).createNewFile();
        File file2 = object;
        object = file2;
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            FileOutputStream fileOutputStream = (FileOutputStream)object;
            bitmap.compress(Bitmap.CompressFormat.JPEG, this.options.getQuality().screenshotQuality, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally((Closeable)object, null);
        this.addFrame(file2, l2, string);
    }

    public static /* synthetic */ void addFrame$bugly_pro_release$default(ReplayCache replayCache, Bitmap bitmap, long l2, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        replayCache.addFrame$bugly_pro_release(bitmap, l2, string);
    }

    public final void addFrame(@NotNull File object, long l2, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"screenshot");
        object = new ReplayFrame((File)object, l2, string);
        ((Collection)this.frames).add(object);
        if (this.frames.size() > this.maxFrameCount) {
            this.frames.get(0).getScreenshot().delete();
            this.frames.remove(0);
        }
    }

    public static /* synthetic */ void addFrame$default(ReplayCache replayCache, File file, long l2, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        replayCache.addFrame(file, l2, string);
    }

    @Nullable
    public final GeneratedVideo createVideoOf(long l2, long l3, int n2, int n3, int n4, int n5, int n6, @NotNull File file) {
        long l4;
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"videoFile");
        if (file.exists() && file.length() > 0L) {
            file.delete();
        }
        if (this.frames.isEmpty()) {
            Logger.INSTANCE.d(this.TAG, "No captured frames, skipping generating a video segment");
            return null;
        }
        ReplayCache replayCache = this;
        AutoCloseable autoCloseable = replayCache.encoderLock.ao();
        ReplayCache replayCache2 = replayCache;
        Object object3 = null;
        try {
            object2 = new SimpleVideoEncoder(new MuxerConfig(file, n4, n3, n5, n6, null, 32, null), null, 2, null);
            ((SimpleVideoEncoder)object2).start();
            object = object2;
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object3 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object3);
                throw throwable3;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
        replayCache2.encoder = object3 = object;
        long l5 = 1000L;
        if (n5 > 0) {
            l5 = 1000L / (long)n5;
        }
        int n7 = 0;
        object = (ReplayFrame)CollectionsKt.first(this.frames);
        long l6 = l3;
        LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((long)l6, (long)(l6 + l2))), (long)l5);
        long l7 = longProgression.getFirst();
        long l8 = longProgression.getLast();
        long l9 = longProgression.getStep();
        long l10 = l7;
        long l11 = l8;
        if (l9 >= 0L ? l10 <= l11 : l10 >= l11) {
            while (true) {
                for (ReplayFrame replayFrame : this.frames) {
                    long l12 = replayFrame.getTimestamp();
                    if (l7 <= l12 && l7 + l5 >= l12) {
                        object = replayFrame;
                        break;
                    }
                    if (replayFrame.getTimestamp() <= l7 + l5) continue;
                }
                if (this.encode((ReplayFrame)object)) {
                    ++n7;
                } else if (object != null) {
                    this.deleteFile(((ReplayFrame)object).getScreenshot());
                    this.frames.remove(object);
                    object = null;
                }
                if (l7 == l8) break;
                l7 += l9;
            }
        }
        if (n7 == 0) {
            Logger.INSTANCE.d(this.TAG, "Generated a video with no frames, not capturing a replay segment");
            this.deleteFile(file);
            return null;
        }
        object2 = this.encoderLock.ao();
        Throwable throwable = null;
        try {
            SimpleVideoEncoder simpleVideoEncoder = this.encoder;
            if (simpleVideoEncoder != null) {
                simpleVideoEncoder.release();
            }
            SimpleVideoEncoder simpleVideoEncoder2 = this.encoder;
            l4 = simpleVideoEncoder2 != null ? simpleVideoEncoder2.getDuration() : 0L;
            this.encoder = null;
        }
        catch (Throwable throwable4) {
            try {
                Throwable throwable5 = throwable4;
                throwable = throwable4;
                throw throwable5;
            }
            catch (Throwable throwable6) {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
                throw throwable6;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)object2, null);
        this.rotate$bugly_pro_release(l3 + l2);
        return new GeneratedVideo(file, n7, l4);
    }

    public static /* synthetic */ GeneratedVideo createVideoOf$default(ReplayCache replayCache, long l2, long l3, int n2, int n3, int n4, int n5, int n6, File file, int n7, Object object) {
        if ((n7 & 0x80) != 0) {
            file = new File(replayCache.getReplayCacheDir$bugly_pro_release(), n2 + ".mp4");
        }
        return replayCache.createVideoOf(l2, l3, n2, n3, n4, n5, n6, file);
    }

    private final boolean encode(ReplayFrame object) {
        boolean bl2;
        if (object == null) {
            return false;
        }
        try {
            object = BitmapFactory.decodeFile((String)((ReplayFrame)object).getScreenshot().getAbsolutePath());
            AutoCloseable autoCloseable = this.encoderLock.ao();
            Throwable throwable = null;
            try {
                SimpleVideoEncoder simpleVideoEncoder = this.encoder;
                if (simpleVideoEncoder != null) {
                    Object object2 = object;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"bitmap");
                    simpleVideoEncoder.encode((Bitmap)object2);
                }
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    throw throwable3;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
            object.recycle();
            bl2 = true;
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception(this.TAG, "Unable to decode bitmap and encode it into a video, skipping frame", throwable);
            bl2 = false;
        }
        return bl2;
    }

    private final void deleteFile(File file) {
        try {
            if (!file.delete()) {
                String[] stringArray = new String[3];
                stringArray[0] = this.TAG;
                stringArray[1] = "Failed to delete replay frame: %s";
                String string = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
                stringArray[2] = string;
                Logger.INSTANCE.e(stringArray);
                return;
            }
        }
        catch (Throwable throwable) {
            String[] stringArray = new String[3];
            stringArray[0] = this.TAG;
            stringArray[1] = "Failed to delete replay frame: %s";
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
            stringArray[2] = string;
            Logger.INSTANCE.e(stringArray);
        }
    }

    @Nullable
    public final String rotate$bugly_pro_release(long l2) {
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        new Ref.ObjectRef().element = null;
        CollectionsKt.removeAll(this.frames, (Function1)((Function1)new Function1<ReplayFrame, Boolean>(this, l2, objectRef){
            final /* synthetic */ ReplayCache this$0;
            final /* synthetic */ long $until;
            final /* synthetic */ Ref.ObjectRef $screen;

            public final /* synthetic */ Object invoke(Object object) {
                return this.invoke((ReplayFrame)object);
            }

            public final boolean invoke(@NotNull ReplayFrame replayFrame) {
                Intrinsics.checkParameterIsNotNull((Object)replayFrame, (String)"it");
                if (replayFrame.getTimestamp() < this.$until) {
                    ReplayCache.access$deleteFile(this.this$0, replayFrame.getScreenshot());
                    return true;
                }
                if ((String)this.$screen.element == null) {
                    this.$screen.element = replayFrame.getScreen();
                }
                return false;
            }
            {
                this.this$0 = replayCache;
                this.$until = l2;
                this.$screen = objectRef;
                super(1);
            }
        }));
        return (String)objectRef.element;
    }

    @Override
    public final void close() {
        AutoCloseable autoCloseable = this.encoderLock.ao();
        Throwable throwable = null;
        try {
            SimpleVideoEncoder simpleVideoEncoder = this.encoder;
            if (simpleVideoEncoder != null) {
                simpleVideoEncoder.release();
            }
            this.encoder = null;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                throw throwable4;
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
        this.isClosed.set(true);
    }

    public final void persistSegmentValues$bugly_pro_release(@NotNull String object, @Nullable String string) {
        AutoCloseable autoCloseable;
        block18: {
            Throwable throwable;
            block16: {
                Intrinsics.checkParameterIsNotNull((Object)object, (String)"key");
                autoCloseable = this.lock.ao();
                throwable = null;
                if (!this.isClosed.get()) break block16;
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
                return;
            }
            try {
                File file = this.getOngoingSegmentFile$bugly_pro_release();
                if (file == null || !file.exists()) {
                    File file2 = this.getOngoingSegmentFile$bugly_pro_release();
                    if (file2 != null) {
                        file2.createNewFile();
                    }
                }
                if (this.ongoingSegment.isEmpty()) {
                    File file3 = this.getOngoingSegmentFile$bugly_pro_release();
                    if (file3 != null) {
                        Object object2 = file3;
                        Object object3 = Charsets.UTF_8;
                        object2 = new FileInputStream((File)object2);
                        Object object4 = new InputStreamReader((InputStream)object2, (Charset)object3);
                        object2 = new BufferedReader((Reader)object4, 8192);
                        object3 = null;
                        try {
                            object4 = TextStreamsKt.lineSequence((BufferedReader)((BufferedReader)object2));
                            Map map = this.ongoingSegment;
                            object4 = object4.iterator();
                            while (object4.hasNext()) {
                                Object object5 = object4.next();
                                Map map2 = map;
                                object5 = StringsKt.split$default((CharSequence)((String)object5), (String[])new String[]{"="}, (boolean)false, (int)2, (int)2, null);
                                String string2 = (String)object5.get(0);
                                object5 = (String)object5.get(1);
                                object5 = TuplesKt.to((Object)string2, (Object)object5);
                                map2.put(object5.getFirst(), object5.getSecond());
                            }
                        }
                        catch (Throwable throwable2) {
                            try {
                                object4 = throwable2;
                                object3 = throwable2;
                                throw object4;
                            }
                            catch (Throwable throwable3) {
                                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                                throw throwable3;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)object2, null);
                    }
                }
                if (string == null) {
                    this.ongoingSegment.remove(object);
                } else {
                    ((Map)this.ongoingSegment).put(object, string);
                }
                File file4 = this.getOngoingSegmentFile$bugly_pro_release();
                if (file4 == null) break block18;
                Set<Map.Entry<String, String>> set = this.ongoingSegment.entrySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"ongoingSegment.entries");
                FilesKt.writeText$default((File)file4, (String)CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, (Function1)persistSegmentValues.1.2.INSTANCE, (int)30, null), null, (int)2, null);
            }
            catch (Throwable throwable4) {
                try {
                    object = throwable4;
                    throwable = throwable4;
                    throw object;
                }
                catch (Throwable throwable5) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    throw throwable5;
                }
            }
        }
        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, null);
        return;
    }

    public ReplayCache(@NotNull BuglyReplayOptions object) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"options");
        this.options = object;
        this.TAG = "ReplayCache";
        this.isClosed = new AtomicBoolean(false);
        this.encoderLock = new bo();
        this.lock = new bo();
        this.replayCacheDir$delegate = LazyKt.lazy((Function0)replayCacheDir.2.INSTANCE);
        object = this;
        ((ReplayCache)object).frames = list = (List)new ArrayList();
        this.maxFrameCount = 30;
        this.ongoingSegment = new LinkedHashMap();
        this.ongoingSegmentFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ ReplayCache this$0;

            @Nullable
            public final File invoke() {
                if (this.this$0.getReplayCacheDir$bugly_pro_release() == null) {
                    return null;
                }
                File file = new File(this.this$0.getReplayCacheDir$bugly_pro_release(), ".ongoing_segment");
                if (!file.exists()) {
                    file.createNewFile();
                }
                return file;
            }
            {
                this.this$0 = replayCache;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ void access$deleteFile(ReplayCache replayCache, File file) {
        replayCache.deleteFile(file);
    }
}

