/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.replay;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuglyReplayOptions {
    public static final String TEXT_VIEW_CLASS_NAME = "android.widget.TextView";
    public static final String IMAGE_VIEW_CLASS_NAME = "android.widget.ImageView";
    public static final String WEB_VIEW_CLASS_NAME = "android.webkit.WebView";
    public static final String VIDEO_VIEW_CLASS_NAME = "android.widget.VideoView";
    public static final String ANDROIDX_MEDIA_VIEW_CLASS_NAME = "androidx.media3.ui.PlayerView";
    public static final String EXOPLAYER_CLASS_NAME = "com.google.android.exoplayer2.ui.PlayerView";
    public static final String EXOPLAYER_STYLED_CLASS_NAME = "com.google.android.exoplayer2.ui.StyledPlayerView";
    public static int MASK_KEY = 3689;
    private Set<String> dz = new CopyOnWriteArraySet<String>();
    @Nullable
    private String dA = null;
    @Nullable
    private String dB = null;
    private BuglyReplayQuality cs = BuglyReplayQuality.MEDIUM;
    private int frameRate = 1;

    public final void setMaskAllText(boolean bl2) {
        if (bl2) {
            this.dz.remove(TEXT_VIEW_CLASS_NAME);
            return;
        }
        this.dz.add(TEXT_VIEW_CLASS_NAME);
    }

    public final void setMaskAllImages(boolean bl2) {
        if (bl2) {
            this.dz.remove(IMAGE_VIEW_CLASS_NAME);
            return;
        }
        this.dz.add(IMAGE_VIEW_CLASS_NAME);
    }

    @NotNull
    public final Set<String> getUnmaskViewClasses() {
        return this.dz;
    }

    public final void addUnmaskViewClass(@NotNull String string) {
        this.dz.add(string);
    }

    public final void removeUnmaskViewClass(@NotNull String string) {
        this.dz.remove(string);
    }

    @NotNull
    public final BuglyReplayQuality getQuality() {
        return this.cs;
    }

    public final void setQuality(@NotNull BuglyReplayQuality buglyReplayQuality) {
        this.cs = buglyReplayQuality;
    }

    public final void setMaskKey(int n2) {
        MASK_KEY = n2;
    }

    public final void setFrameRate(int n2) {
        this.frameRate = n2;
    }

    public final int getFrameRate() {
        return this.frameRate;
    }

    @Nullable
    public final String getMaskViewContainerClass() {
        return this.dA;
    }

    @Nullable
    public final String getUnmaskViewContainerClass() {
        return this.dB;
    }

    public static enum BuglyReplayQuality {
        LOW(0.8f, 50000, 50),
        MEDIUM(1.0f, 75000, 75),
        HIGH(1.0f, 100000, 100);

        public final float sizeScale;
        public final int bitRate;
        public final int screenshotQuality;

        private BuglyReplayQuality(float f2, int n3, int n4) {
            this.sizeScale = f2;
            this.bitRate = n3;
            this.screenshotQuality = n4;
        }
    }
}

