/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Handler;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.tencent.bugly.common.network.Apn;
import com.tencent.bugly.common.network.INetworkStateListener;
import com.tencent.bugly.common.network.NetworkState;
import com.tencent.bugly.common.network.NetworkWatcher;
import com.tencent.bugly.common.network.NetworkWatcher$WhenMappings;
import com.tencent.bugly.common.thread.ThreadManager;
import com.tencent.bugly.common.utils.AndroidVersion;
import com.tencent.bugly.proguard.cf;
import com.tencent.bugly.proguard.ci;
import com.tencent.rmonitor.common.logger.Logger;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\rJ\b\u0010\"\u001a\u0004\u0018\u00010\u0004J\u0006\u0010#\u001a\u00020\u001cJ\u0006\u0010$\u001a\u00020\rJ\u0006\u0010%\u001a\u00020\rJ\u0018\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\u001cH\u0002J\u0018\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u0016J\b\u00100\u001a\u00020\u001cH\u0002J\u0006\u00101\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\"\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015j\n\u0012\u0004\u0012\u00020\u0016\u0018\u0001`\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u00062"}, d2={"Lcom/tencent/bugly/common/network/NetworkWatcher;", "", "()V", "ACTION_CONN_CHANGE", "", "TAG", "apn", "Lcom/tencent/bugly/common/network/Apn;", "getApn", "()Lcom/tencent/bugly/common/network/Apn;", "handler", "Landroid/os/Handler;", "isInited", "", "isNetAvailable", "()Z", "setNetAvailable", "(Z)V", "isWifiAvailable", "setWifiAvailable", "mListeners", "Ljava/util/HashSet;", "Lcom/tencent/bugly/common/network/INetworkStateListener;", "Lkotlin/collections/HashSet;", "netStatusReceive", "com/tencent/bugly/common/network/NetworkWatcher$netStatusReceive$1", "Lcom/tencent/bugly/common/network/NetworkWatcher$netStatusReceive$1;", "checkConnInfo", "", "networkState", "Lcom/tencent/bugly/common/network/NetworkState;", "getMobileDetailState", "getNetworkState", "fetchMobileDetailState", "getOperatorName", "init", "isNetworkConnectedRealtime", "isWiFiConnectedRealtime", "isWiFiType", "connManager", "Landroid/net/ConnectivityManager;", "activeNetInfo", "Landroid/net/NetworkInfo;", "notifyListener", "processApn", "it", "registerListener", "listener", "resetApn", "unInit", "bugly-pro_release"})
public final class NetworkWatcher {
    private static final String TAG = "Bugly_NetWatcher";
    private static final String ACTION_CONN_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
    private static HashSet<INetworkStateListener> mListeners;
    private static Handler handler;
    private static volatile boolean isInited;
    private static volatile Apn apn;
    private static volatile boolean isWifiAvailable;
    private static volatile boolean isNetAvailable;
    private static final netStatusReceive.1 netStatusReceive;
    public static final NetworkWatcher INSTANCE;

    private final Apn getApn() {
        if (apn == Apn.TYPE_INIT) {
            this.resetApn();
        }
        return apn;
    }

    public final boolean isWifiAvailable() {
        return isWifiAvailable;
    }

    public final void setWifiAvailable(boolean bl2) {
        isWifiAvailable = bl2;
    }

    public final boolean isNetAvailable() {
        return isNetAvailable;
    }

    public final void setNetAvailable(boolean bl2) {
        isNetAvailable = bl2;
    }

    public final void init() {
        if (isInited) {
            return;
        }
        Logger.INSTANCE.i(TAG, "init");
        Class<NetworkWatcher> clazz = NetworkWatcher.class;
        synchronized (NetworkWatcher.class) {
            if (!isInited) {
                Context context = cf.aI();
                if (context != null) {
                    Context context2 = context;
                    try {
                        context2.registerReceiver((BroadcastReceiver)netStatusReceive, new IntentFilter(ACTION_CONN_CHANGE));
                    }
                    catch (Throwable throwable) {
                        Logger.INSTANCE.e(TAG, "unInit, ".concat(String.valueOf(throwable)));
                    }
                }
                handler = new Handler(ThreadManager.Companion.getMonitorThreadLooper());
                isInited = true;
                INSTANCE.checkConnInfo();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final void unInit() {
        Class<NetworkWatcher> clazz = NetworkWatcher.class;
        synchronized (NetworkWatcher.class) {
            if (isInited) {
                try {
                    Context context = cf.aI();
                    if (context != null) {
                        context.unregisterReceiver((BroadcastReceiver)netStatusReceive);
                    }
                }
                catch (Throwable throwable) {
                    Logger.INSTANCE.e(TAG, "unInit, ".concat(String.valueOf(throwable)));
                }
                isInited = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final void registerListener(@NotNull INetworkStateListener iNetworkStateListener) {
        Intrinsics.checkParameterIsNotNull((Object)iNetworkStateListener, (String)"listener");
        if (mListeners == null) {
            mListeners = new HashSet();
        }
        if (mListeners != null) {
            HashSet<INetworkStateListener> hashSet = mListeners;
            if (hashSet == null) {
                Intrinsics.throwNpe();
            }
            if (!hashSet.contains(iNetworkStateListener)) {
                HashSet<INetworkStateListener> hashSet2 = mListeners;
                if (hashSet2 == null) {
                    Intrinsics.throwNpe();
                }
                hashSet2.add(iNetworkStateListener);
            }
        }
    }

    private final void notifyListener() {
        int n2;
        switch (NetworkWatcher$WhenMappings.$EnumSwitchMapping$0[this.getApn().ordinal()]) {
            case 1: {
                int n3 = 1;
                break;
            }
            case 2: {
                int n3 = 3;
                break;
            }
            default: {
                int n3 = n2 = 2;
            }
        }
        if (mListeners != null) {
            HashSet<INetworkStateListener> hashSet = mListeners;
            if (hashSet == null) {
                Intrinsics.throwNpe();
            }
            Iterator<INetworkStateListener> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                iterator.next().onNetworkStateChanged(n2);
            }
        }
    }

    private final void checkConnInfo() {
        boolean bl2;
        this.resetApn();
        switch (NetworkWatcher$WhenMappings.$EnumSwitchMapping$1[this.getApn().ordinal()]) {
            case 1: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        isWifiAvailable = bl2;
        isNetAvailable = this.getApn() != Apn.TYPE_UNKNOWN;
        this.notifyListener();
    }

    private final Apn processApn(String string, NetworkState networkState) {
        int n2 = -1;
        switch (string.hashCode()) {
            case 618596989: {
                if (!string.equals("\u4e2d\u56fd\u79fb\u52a8")) break;
                n2 = 1;
                break;
            }
            case 618558396: {
                if (!string.equals("\u4e2d\u56fd\u7535\u4fe1")) break;
                n2 = 2;
                break;
            }
            case 618663094: {
                if (!string.equals("\u4e2d\u56fd\u8054\u901a")) break;
                n2 = 3;
                break;
            }
        }
        switch (n2) {
            case 1: {
                switch (NetworkWatcher$WhenMappings.$EnumSwitchMapping$2[networkState.ordinal()]) {
                    case 1: {
                        return Apn.T_APN_CMNET;
                    }
                    case 2: {
                        return Apn.T_APN_CM3G;
                    }
                }
                return Apn.T_APN_CMLTE;
            }
            case 2: {
                switch (NetworkWatcher$WhenMappings.$EnumSwitchMapping$3[networkState.ordinal()]) {
                    case 1: {
                        return Apn.TYPE_UNKNOWN;
                    }
                    case 2: {
                        return Apn.T_APN_CTNET;
                    }
                }
                return Apn.T_APN_CTLTE;
            }
            case 3: {
                switch (NetworkWatcher$WhenMappings.$EnumSwitchMapping$4[networkState.ordinal()]) {
                    case 1: {
                        return Apn.T_APN_UNINET;
                    }
                    case 2: {
                        return Apn.T_APN_3GNET;
                    }
                }
                return Apn.T_APN_WONET;
            }
        }
        return Apn.TYPE_NET;
    }

    private final Apn getApn(NetworkState networkState) {
        String string;
        Object object = this.getOperatorName();
        if (object == null || (object = INSTANCE.processApn(string = object, networkState)) == null) {
            object = Apn.TYPE_NET;
        }
        return object;
    }

    private final void resetApn() {
        Enum enum_;
        try {
            Apn apn;
            enum_ = this.getNetworkState(true);
            switch (NetworkWatcher$WhenMappings.$EnumSwitchMapping$5[enum_.ordinal()]) {
                case 1: {
                    apn = Apn.TYPE_WIFI;
                    break;
                }
                case 2: {
                    apn = Apn.TYPE_UNKNOWN;
                    break;
                }
                default: {
                    apn = this.getApn((NetworkState)enum_);
                }
            }
            enum_ = apn;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)(exception + ": cannot get apn from network state, so use default"));
            enum_ = Apn.TYPE_UNKNOWN;
        }
        apn = enum_;
    }

    @Nullable
    public final String getOperatorName() {
        Context context = cf.aI();
        Object object = context != null ? context.getSystemService("phone") : null;
        if (!(object instanceof TelephonyManager)) {
            object = null;
        }
        TelephonyManager telephonyManager = (TelephonyManager)object;
        if (telephonyManager != null) {
            return telephonyManager.getSimOperatorName();
        }
        return null;
    }

    private final NetworkState getMobileDetailState() {
        try {
            Integer n2;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            if (!ci.a(cf.aI(), "android.permission.READ_PHONE_STATE")) {
                                return NetworkState.NETWORK_MOBILE;
                            }
                            Context context = cf.aI();
                            Object object = context != null ? context.getSystemService("phone") : null;
                            if (!(object instanceof TelephonyManager)) {
                                object = null;
                            }
                            TelephonyManager telephonyManager = (TelephonyManager)object;
                            Integer n3 = n2 = telephonyManager != null ? Integer.valueOf(telephonyManager.getNetworkType()) : null;
                            if (n3 != null && n3 == 1) break block11;
                            Integer n4 = n2;
                            if (n4 != null && n4 == 4) break block11;
                            Integer n5 = n2;
                            if (n5 != null && n5 == 2) break block11;
                            Integer n6 = n2;
                            if (n6 != null && n6 == 7) break block11;
                            Integer n7 = n2;
                            if (n7 == null || n7 != 11) break block12;
                        }
                        return NetworkState.NETWORK_2G;
                    }
                    Integer n8 = n2;
                    if (n8 != null && n8 == 6) break block13;
                    Integer n9 = n2;
                    if (n9 != null && n9 == 3) break block13;
                    Integer n10 = n2;
                    if (n10 != null && n10 == 5) break block13;
                    Integer n11 = n2;
                    if (n11 != null && n11 == 8) break block13;
                    Integer n12 = n2;
                    if (n12 != null && n12 == 9) break block13;
                    Integer n13 = n2;
                    if (n13 != null && n13 == 10) break block13;
                    Integer n14 = n2;
                    if (n14 != null && n14 == 12) break block13;
                    Integer n15 = n2;
                    if (n15 != null && n15 == 14) break block13;
                    Integer n16 = n2;
                    if (n16 == null || n16 != 15) break block14;
                }
                return NetworkState.NETWORK_3G;
            }
            Integer n17 = n2;
            if (n17 != null && n17 == 13) {
                return NetworkState.NETWORK_4G;
            }
            return NetworkState.NETWORK_MOBILE;
        }
        catch (Throwable throwable) {
            Logger.INSTANCE.exception(TAG, throwable);
            return NetworkState.NETWORK_MOBILE;
        }
    }

    public final boolean isWiFiConnectedRealtime() {
        return this.getNetworkState(false) == NetworkState.NETWORK_WIFI;
    }

    public final boolean isNetworkConnectedRealtime() {
        return this.getNetworkState(false) != NetworkState.NETWORK_NONE;
    }

    private final boolean isWiFiType(ConnectivityManager connectivityManager, NetworkInfo networkInfo2) {
        if (!AndroidVersion.Companion.isOverL()) {
            if (networkInfo2.isConnectedOrConnecting() && networkInfo2.getType() == 1) {
                return true;
            }
        } else {
            for (Network network : connectivityManager.getAllNetworks()) {
                NetworkInfo networkInfo;
                if (connectivityManager.getNetworkInfo(network) == null) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)networkInfo, (String)"it");
                if (networkInfo.getType() != 1 || networkInfo.getState() != NetworkInfo.State.CONNECTED && networkInfo.getState() != NetworkInfo.State.CONNECTING) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final NetworkState getNetworkState(boolean bl2) {
        Context context = cf.aI();
        Object object = context != null ? context.getSystemService("connectivity") : null;
        if (!(object instanceof ConnectivityManager)) {
            object = null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        if (connectivityManager == null) {
            return NetworkState.NETWORK_NONE;
        }
        ConnectivityManager connectivityManager2 = connectivityManager;
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isAvailable()) {
            return NetworkState.NETWORK_NONE;
        }
        if (this.isWiFiType(connectivityManager2, networkInfo)) {
            return NetworkState.NETWORK_WIFI;
        }
        if (bl2) {
            return this.getMobileDetailState();
        }
        return NetworkState.NETWORK_MOBILE;
    }

    private NetworkWatcher() {
    }

    static {
        INSTANCE = new NetworkWatcher();
        apn = Apn.TYPE_INIT;
        netStatusReceive = new BroadcastReceiver(){

            public final void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                if (cf.aI() != null) {
                    Handler handler = NetworkWatcher.access$getHandler$p(NetworkWatcher.INSTANCE);
                    if (handler != null) {
                        handler.post((Runnable)netStatusReceive.onReceive.1.INSTANCE);
                        return;
                    }
                }
            }
        };
    }

    public static final /* synthetic */ Handler access$getHandler$p(NetworkWatcher networkWatcher) {
        return handler;
    }

    public static final /* synthetic */ void access$setHandler$p(NetworkWatcher networkWatcher, Handler handler) {
        NetworkWatcher.handler = handler;
    }

    public static final /* synthetic */ void access$checkConnInfo(NetworkWatcher networkWatcher) {
        networkWatcher.checkConnInfo();
    }
}

