/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.common.looper;

import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Printer;
import com.tencent.bugly.common.looper.ILooperDispatchListener;
import com.tencent.bugly.common.looper.LooperPrinter;
import com.tencent.bugly.common.utils.AndroidVersion;
import com.tencent.bugly.proguard.ax;
import com.tencent.bugly.proguard.cp;
import com.tencent.bugly.proguard.hc;
import com.tencent.bugly.proguard.hx;
import com.tencent.rmonitor.common.logger.Logger;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000f\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0012J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010%\u001a\u00020\u0007H\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010&\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010*\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/tencent/bugly/common/looper/LooperDispatchWatcher;", "Landroid/os/MessageQueue$IdleHandler;", "Lcom/tencent/bugly/common/looper/LooperPrinter$IDispatch;", "looper", "Landroid/os/Looper;", "(Landroid/os/Looper;)V", "isStart", "", "lastCheckPrinterTime", "", "listeners", "Ljava/util/HashSet;", "Lcom/tencent/bugly/common/looper/ILooperDispatchListener;", "Lkotlin/collections/HashSet;", "printer", "Lcom/tencent/bugly/common/looper/LooperPrinter;", "startTime", "addIdleHandler", "", "addListener", "listener", "checkAndStart", "checkAndStop", "checkValid", "Landroid/util/Printer;", "clearListeners", "dealOriginPrinter", "originPrinter", "dispatch", "isBegin", "log", "", "dispatchEnd", "msg", "endTime", "duration", "dispatchStart", "ignoreOriginPrinter", "queueIdle", "release", "removeIdleHandler", "removeListener", "resetPrinter", "resetPrinterWithOriginPrinter", "resetPrinterWithoutOriginPrinter", "Companion", "bugly-pro_release"})
public final class LooperDispatchWatcher
implements MessageQueue.IdleHandler,
LooperPrinter.IDispatch {
    private final HashSet<ILooperDispatchListener> listeners;
    private LooperPrinter printer;
    private long lastCheckPrinterTime;
    private boolean isStart;
    private long startTime;
    private final Looper looper;
    private static final String TAG = "RMonitor_looper_DispatchWatcher";
    private static final long CHECK_TIME_IN_MS = 60000L;
    private static final int MAX_CHECK_COUNT = 100;
    private static final ThreadLocal<LooperDispatchWatcher> watcher;
    private static final ConcurrentHashMap<Looper, Handler> handlerMap;
    public static final Companion Companion;

    public final boolean isStart() {
        return this.isStart;
    }

    public final void checkAndStart() {
        if (this.isStart || this.listeners.size() == 0) {
            return;
        }
        String[] stringArray = new String[2];
        stringArray[0] = TAG;
        StringBuilder stringBuilder = new StringBuilder("checkAndStart in ");
        Thread thread = this.looper.getThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"looper.thread");
        stringArray[1] = stringBuilder.append(thread.getName()).toString();
        Logger.INSTANCE.d(stringArray);
        this.isStart = true;
        LooperDispatchWatcher looperDispatchWatcher = this;
        looperDispatchWatcher.resetPrinter(looperDispatchWatcher.looper);
        LooperDispatchWatcher looperDispatchWatcher2 = this;
        looperDispatchWatcher2.addIdleHandler(looperDispatchWatcher2.looper);
    }

    public final void checkAndStop() {
        if (!this.isStart || this.listeners.size() > 0) {
            return;
        }
        String[] stringArray = new String[2];
        stringArray[0] = TAG;
        StringBuilder stringBuilder = new StringBuilder("checkAndStop in ");
        Thread thread = this.looper.getThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"looper.thread");
        stringArray[1] = stringBuilder.append(thread.getName()).toString();
        Logger.INSTANCE.d(stringArray);
        this.release();
        this.isStart = false;
    }

    public final void addListener(@NotNull ILooperDispatchListener iLooperDispatchListener) {
        Intrinsics.checkParameterIsNotNull((Object)iLooperDispatchListener, (String)"listener");
        this.listeners.add(iLooperDispatchListener);
    }

    public final void removeListener(@NotNull ILooperDispatchListener iLooperDispatchListener) {
        Intrinsics.checkParameterIsNotNull((Object)iLooperDispatchListener, (String)"listener");
        this.listeners.remove(iLooperDispatchListener);
    }

    public final void clearListeners() {
        this.listeners.clear();
    }

    public final boolean queueIdle() {
        if (SystemClock.uptimeMillis() - this.lastCheckPrinterTime >= 60000L) {
            LooperDispatchWatcher looperDispatchWatcher = this;
            looperDispatchWatcher.resetPrinter(looperDispatchWatcher.looper);
            this.lastCheckPrinterTime = SystemClock.uptimeMillis();
        }
        return true;
    }

    private final synchronized void release() {
        LooperPrinter looperPrinter = this.printer;
        if (looperPrinter != null) {
            LooperPrinter looperPrinter2 = looperPrinter;
            if (Logger.verbos) {
                String[] stringArray = new String[2];
                stringArray[0] = TAG;
                StringBuilder stringBuilder = new StringBuilder("release printer[").append(looperPrinter2).append("] originPrinter[").append(looperPrinter2.getOrigin()).append("] in ");
                Thread thread = this.looper.getThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"looper.thread");
                stringArray[1] = stringBuilder.append(thread.getName()).toString();
                Logger.INSTANCE.v(stringArray);
            }
            this.looper.setMessageLogging(looperPrinter2.getOrigin());
            LooperDispatchWatcher looperDispatchWatcher = this;
            looperDispatchWatcher.removeIdleHandler(looperDispatchWatcher.looper);
        }
        this.printer = null;
    }

    private final synchronized void addIdleHandler(Looper looper) {
        if (AndroidVersion.Companion.isOverM()) {
            looper.getQueue().addIdleHandler((MessageQueue.IdleHandler)this);
            return;
        }
        try {
            cp.c(looper).addIdleHandler((MessageQueue.IdleHandler)this);
            return;
        }
        catch (Throwable throwable) {
            StringBuilder stringBuilder = new StringBuilder("addIdleHandler in ");
            Thread thread = looper.getThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"looper.thread");
            Logger.INSTANCE.exception(TAG, stringBuilder.append(thread.getName()).append(", ").toString(), throwable);
            return;
        }
    }

    private final synchronized void removeIdleHandler(Looper looper) {
        if (AndroidVersion.Companion.isOverM()) {
            looper.getQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
            return;
        }
        try {
            cp.c(looper).removeIdleHandler((MessageQueue.IdleHandler)this);
            return;
        }
        catch (Throwable throwable) {
            StringBuilder stringBuilder = new StringBuilder("removeIdleHandler in ");
            Thread thread = looper.getThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"looper.thread");
            Logger.INSTANCE.exception(TAG, stringBuilder.append(thread.getName()).append(", ").toString(), throwable);
            return;
        }
    }

    private final synchronized void resetPrinter(Looper looper) {
        if (this.ignoreOriginPrinter()) {
            this.resetPrinterWithoutOriginPrinter(looper);
            return;
        }
        this.resetPrinterWithOriginPrinter(looper);
    }

    private final void resetPrinterWithoutOriginPrinter(Looper looper) {
        if (this.printer == null) {
            this.printer = new LooperPrinter(null, this);
        }
        looper.setMessageLogging((Printer)this.printer);
    }

    private final void resetPrinterWithOriginPrinter(Looper looper) {
        Printer printer = cp.b(looper);
        if (printer == this.printer && this.printer != null) {
            return;
        }
        if (this.printer != null) {
            String[] stringArray = new String[2];
            stringArray[0] = TAG;
            StringBuilder stringBuilder = new StringBuilder("resetPrinter maybe printer[").append(this.printer).append("] was replace by other[").append(printer).append("] in ");
            Thread thread = looper.getThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"looper.thread");
            stringArray[1] = stringBuilder.append(thread.getName()).append(' ').toString();
            Logger.INSTANCE.w(stringArray);
        }
        this.printer = new LooperPrinter(this.dealOriginPrinter(printer), this);
        looper.setMessageLogging((Printer)this.printer);
        if (printer != null || Logger.debug) {
            String[] stringArray = new String[2];
            stringArray[0] = TAG;
            StringBuilder stringBuilder = new StringBuilder("resetPrinter printer[").append(this.printer).append("] originPrinter[").append(printer).append("] in ");
            Thread thread = looper.getThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"looper.thread");
            stringArray[1] = stringBuilder.append(thread.getName()).toString();
            Logger.INSTANCE.w(stringArray);
        }
    }

    private final boolean ignoreOriginPrinter() {
        boolean bl2 = false;
        hx hx2 = hc.fh().aB("common");
        if (hx2 instanceof ax && ((ax)hx2).ignoreOriginPrinter()) {
            bl2 = true;
        }
        return bl2;
    }

    @Nullable
    public final Printer dealOriginPrinter(@Nullable Printer printer) {
        int n2 = 0;
        while (printer instanceof LooperPrinter) {
            printer = ((LooperPrinter)printer).getOrigin();
            if (++n2 < 100) continue;
            printer = null;
            break;
        }
        return printer;
    }

    @Override
    public final boolean checkValid(@NotNull Printer printer) {
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        return printer == this.printer && this.printer != null;
    }

    @Override
    public final void dispatch(boolean bl2, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"log");
        if (bl2) {
            this.startTime = SystemClock.uptimeMillis();
            this.dispatchStart(string, this.startTime);
            return;
        }
        if (this.startTime != 0L) {
            long l2 = SystemClock.uptimeMillis();
            long l3 = l2 - this.startTime;
            this.startTime = 0L;
            this.dispatchEnd(string, l2, l3);
        }
    }

    private final void dispatchStart(String string, long l2) {
        for (ILooperDispatchListener iLooperDispatchListener : (Iterable)this.listeners) {
            if (!iLooperDispatchListener.isOpen()) continue;
            iLooperDispatchListener.onDispatchStart(string, l2);
        }
    }

    private final void dispatchEnd(String string, long l2, long l3) {
        for (ILooperDispatchListener iLooperDispatchListener : (Iterable)this.listeners) {
            if (!iLooperDispatchListener.isOpen()) continue;
            iLooperDispatchListener.onDispatchEnd(string, l2, l3);
        }
    }

    public LooperDispatchWatcher(@NotNull Looper looper) {
        Intrinsics.checkParameterIsNotNull((Object)looper, (String)"looper");
        this.looper = looper;
        this.listeners = new HashSet();
    }

    static {
        Companion = new Companion(0);
        watcher = new ThreadLocal();
        handlerMap = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001a\u0010\u001b\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/tencent/bugly/common/looper/LooperDispatchWatcher$Companion;", "", "()V", "CHECK_TIME_IN_MS", "", "MAX_CHECK_COUNT", "", "TAG", "", "handlerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Landroid/os/Looper;", "Landroid/os/Handler;", "watcher", "Ljava/lang/ThreadLocal;", "Lcom/tencent/bugly/common/looper/LooperDispatchWatcher;", "fetchHandler", "looper", "createWhenNotExist", "", "fetchWatcher", "forceStop", "", "register", "listener", "Lcom/tencent/bugly/common/looper/ILooperDispatchListener;", "release", "unregister", "bugly-pro_release"})
    public static final class Companion {
        public static void a(@Nullable Looper looper, @Nullable ILooperDispatchListener iLooperDispatchListener) {
            if (iLooperDispatchListener == null || looper == null) {
                return;
            }
            Handler handler = com.tencent.bugly.common.looper.LooperDispatchWatcher$Companion.a(looper, true);
            if (handler != null) {
                handler.post(new Runnable(looper, iLooperDispatchListener){
                    final /* synthetic */ Looper $looper;
                    final /* synthetic */ ILooperDispatchListener $listener;

                    public final void run() {
                        LooperDispatchWatcher looperDispatchWatcher = com.tencent.bugly.common.looper.LooperDispatchWatcher$Companion.b(this.$looper, true);
                        if (looperDispatchWatcher != null) {
                            LooperDispatchWatcher looperDispatchWatcher2 = looperDispatchWatcher;
                            looperDispatchWatcher.addListener(this.$listener);
                            looperDispatchWatcher2.checkAndStart();
                            return;
                        }
                    }
                    {
                        this.$looper = looper;
                        this.$listener = iLooperDispatchListener;
                    }
                });
                return;
            }
        }

        public static void b(@Nullable Looper looper, @Nullable ILooperDispatchListener iLooperDispatchListener) {
            if (iLooperDispatchListener == null || looper == null) {
                return;
            }
            Handler handler = com.tencent.bugly.common.looper.LooperDispatchWatcher$Companion.a(looper, false);
            if (handler != null) {
                handler.post(new Runnable(looper, iLooperDispatchListener){
                    final /* synthetic */ Looper $looper;
                    final /* synthetic */ ILooperDispatchListener $listener;

                    public final void run() {
                        LooperDispatchWatcher looperDispatchWatcher = com.tencent.bugly.common.looper.LooperDispatchWatcher$Companion.b(this.$looper, false);
                        if (looperDispatchWatcher != null) {
                            LooperDispatchWatcher looperDispatchWatcher2 = looperDispatchWatcher;
                            looperDispatchWatcher.removeListener(this.$listener);
                            looperDispatchWatcher2.checkAndStop();
                            if (!looperDispatchWatcher2.isStart()) {
                                com.tencent.bugly.common.looper.LooperDispatchWatcher$Companion.a(this.$looper);
                            }
                            return;
                        }
                    }
                    {
                        this.$looper = looper;
                        this.$listener = iLooperDispatchListener;
                    }
                });
                return;
            }
        }

        private static Handler a(Looper looper, boolean bl2) {
            Handler handler = (Handler)handlerMap.get(looper);
            if (handler == null && bl2) {
                handler = new Handler(looper);
                ((Map)handlerMap).put(looper, handler);
                Logger.INSTANCE.i(LooperDispatchWatcher.TAG, "create handler of looper[" + looper + ']');
            }
            return handler;
        }

        private Companion() {
        }

        public static final /* synthetic */ LooperDispatchWatcher b(Looper looper, boolean bl2) {
            boolean bl3 = bl2;
            Looper looper2 = looper;
            LooperDispatchWatcher looperDispatchWatcher = (LooperDispatchWatcher)watcher.get();
            if (looperDispatchWatcher == null && bl3) {
                looperDispatchWatcher = new LooperDispatchWatcher(looper2);
                watcher.set(looperDispatchWatcher);
                Logger.INSTANCE.i(LooperDispatchWatcher.TAG, "create watcher of looper[" + looper2 + ']');
            }
            return looperDispatchWatcher;
        }

        public static final /* synthetic */ void a(Looper looper) {
            watcher.remove();
            handlerMap.remove(looper);
            Logger.INSTANCE.i(LooperDispatchWatcher.TAG, "release watcher and handler of looper[" + looper + ']');
        }

        public /* synthetic */ Companion(byte by2) {
            this();
        }
    }
}

