/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.container;

import com.google.inject.Inject;
import com.tencent.ads.ApiContainer;
import com.tencent.ads.ApiException;
import com.tencent.ads.anno.*;
import com.tencent.ads.api.QualificationsApi;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.QualificationsAddRequest;
import com.tencent.ads.model.QualificationsAddResponse;
import com.tencent.ads.model.QualificationsAddResponseData;
import com.tencent.ads.model.QualificationsDeleteRequest;
import com.tencent.ads.model.QualificationsDeleteResponse;
import com.tencent.ads.model.QualificationsDeleteResponseData;
import com.tencent.ads.model.QualificationsGetResponse;
import com.tencent.ads.model.QualificationsGetResponseData;
import com.tencent.ads.model.QualificationsUpdateRequest;
import com.tencent.ads.model.QualificationsUpdateResponse;
import com.tencent.ads.model.QualificationsUpdateResponseData;
import java.util.List;

public class QualificationsApiContainer extends ApiContainer {

  @Inject QualificationsApi api;

  /**
   * 创建广告主资质
   *
   * @param data (required)
   * @return QualificationsAddResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public QualificationsAddResponseData qualificationsAdd(QualificationsAddRequest data)
      throws ApiException, TencentAdsResponseException {
    QualificationsAddResponse resp = api.qualificationsAdd(data);
    handleResponse(gson.toJson(resp));
    return resp.getData();
  }

  /**
   * 删除广告主资质
   *
   * @param data (required)
   * @return QualificationsDeleteResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public QualificationsDeleteResponseData qualificationsDelete(QualificationsDeleteRequest data)
      throws ApiException, TencentAdsResponseException {
    QualificationsDeleteResponse resp = api.qualificationsDelete(data);
    handleResponse(gson.toJson(resp));
    return resp.getData();
  }

  /**
   * 获取广告主资质
   *
   * @param accountId (required)
   * @param qualificationType (required)
   * @param filtering (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return QualificationsGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public QualificationsGetResponseData qualificationsGet(
      Long accountId,
      String qualificationType,
      List<FilteringStruct> filtering,
      List<String> fields)
      throws ApiException, TencentAdsResponseException {
    QualificationsGetResponse resp =
        api.qualificationsGet(accountId, qualificationType, filtering, fields);
    handleResponse(gson.toJson(resp));
    return resp.getData();
  }

  /**
   * 更新广告主资质
   *
   * @param data (required)
   * @return QualificationsUpdateResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public QualificationsUpdateResponseData qualificationsUpdate(QualificationsUpdateRequest data)
      throws ApiException, TencentAdsResponseException {
    QualificationsUpdateResponse resp = api.qualificationsUpdate(data);
    handleResponse(gson.toJson(resp));
    return resp.getData();
  }
}
