/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.WechatAds;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.ApiException;
import com.tencent.ads.TencentAds;
import com.tencent.ads.examples.WechatAds.AddWechatMomentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AdcreativeCreativeElementsMp;
import com.tencent.ads.model.AdcreativesAddRequest;
import com.tencent.ads.model.AdcreativesAddResponseData;
import com.tencent.ads.model.AdgroupsAddRequest;
import com.tencent.ads.model.AdgroupsAddResponseData;
import com.tencent.ads.model.AdsAddRequest;
import com.tencent.ads.model.AdsAddResponseData;
import com.tencent.ads.model.AgeStruct;
import com.tencent.ads.model.BillingEvent;
import com.tencent.ads.model.CampaignType;
import com.tencent.ads.model.CampaignsAddRequest;
import com.tencent.ads.model.CampaignsAddResponseData;
import com.tencent.ads.model.DestinationType;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.GeoLocations;
import com.tencent.ads.model.ImagesAddResponseData;
import com.tencent.ads.model.LinkNameTypeMP;
import com.tencent.ads.model.LinkPageSpec;
import com.tencent.ads.model.LinkPageType;
import com.tencent.ads.model.OptimizationGoal;
import com.tencent.ads.model.OverrideCanvasHeadOption;
import com.tencent.ads.model.PageSpec;
import com.tencent.ads.model.PromotedObjectType;
import com.tencent.ads.model.PromotedObjectsAddRequest;
import com.tencent.ads.model.PromotedObjectsGetResponseData;
import com.tencent.ads.model.PromotedObjectsUpdateRequest;
import com.tencent.ads.model.WriteTargetingSettingForAdgroup;
import com.tencent.ads.utils.SignatureUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;

public class AddWechatMomentAdsWithLinkPage {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public Long ACCOUNT_ID = 0L;
    public static String ANDROID_APP_ID = "ANDROID_APP_ID";
    public static Long ADCREATIVE_TEMPLATE_ID = 310L;
    public static String IMAGE_PATH = "YOUR AD IMAGE PATH";
    public static String IMAGE_ID = "YOUR IMAGE ID";
    public static Long WECHAT_PAGE_ID = 100L;
    public static String AD_TITLE = "YOUR AD TEXT";
    public static Long PROFILE_ID = 13305L;
    public TencentAds tencentAds;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.tencentAds.useSandbox();
    }

    public Long addWechatMomentAdsWithLinkPage() throws Exception {
        CampaignType campaignType = CampaignType.NORMAL;
        PromotedObjectType promotedObjectType = PromotedObjectType.APP_ANDROID;
        Long campaignId = this.addCampaign(campaignType, promotedObjectType);
        String promotedObjectId = this.addPromotedObject(promotedObjectType, ANDROID_APP_ID);
        List<String> siteSet = Arrays.asList("SITE_SET_MOMENTS");
        Long adgroupId = this.addAdgroup(campaignId, promotedObjectType, promotedObjectId, siteSet);
        String imageId = IMAGE_ID != null ? IMAGE_ID : this.addImage(IMAGE_PATH);
        Long adcreativeId = this.addAdcreative(ADCREATIVE_TEMPLATE_ID, campaignId, promotedObjectType, promotedObjectId, siteSet, imageId, AD_TITLE);
        Long adId = this.addAd(adgroupId, adcreativeId);
        return adId;
    }

    public static void main(String[] args) {
        try {
            AddWechatMomentAds addWechatMomentAds = new AddWechatMomentAds();
            addWechatMomentAds.init();
            Long l = addWechatMomentAds.addWechatMomentAds();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Long addCampaign(CampaignType campaignType, PromotedObjectType promotedObjectType) throws ApiException {
        String campaignName = "SDK\u8ba1\u5212" + UUID.randomUUID().toString().substring(0, 10);
        Long campaignDailyBudget = 0L;
        CampaignsAddResponseData response = this.tencentAds.campaigns().campaignsAdd(new CampaignsAddRequest().accountId(this.ACCOUNT_ID).campaignName(campaignName).campaignType(campaignType).promotedObjectType(promotedObjectType).dailyBudget(campaignDailyBudget));
        return response.getCampaignId();
    }

    private String addPromotedObject(PromotedObjectType promotedObjectType, String promotedObjectId) throws ApiException {
        PromotedObjectsGetResponseData getResponseData = this.tencentAds.promotedObjects().promotedObjectsGet(this.ACCOUNT_ID, Arrays.asList(new FilteringStruct().field("promoted_object_id").operator("EQUALS").values(Arrays.asList(String.valueOf(promotedObjectId)))), null, null, null);
        if (getResponseData != null && getResponseData.getList().size() > 0) {
            this.tencentAds.promotedObjects().promotedObjectsUpdate(new PromotedObjectsUpdateRequest().accountId(this.ACCOUNT_ID).promotedObjectType(promotedObjectType).promotedObjectId(promotedObjectId));
        } else {
            this.tencentAds.promotedObjects().promotedObjectsAdd(new PromotedObjectsAddRequest().accountId(this.ACCOUNT_ID).promotedObjectType(promotedObjectType).promotedObjectId(promotedObjectId));
        }
        return promotedObjectId;
    }

    private Long addAdgroup(Long campaignId, PromotedObjectType promotedObjectType, String promotedObjectId, List<String> siteSet) throws ApiException {
        String adgroupName = "SDK sample adgroup " + UUID.randomUUID().toString().substring(0, 10);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        String beginDate = this.sdf.format(calendar.getTime());
        calendar.add(5, 10);
        String endDate = this.sdf.format(calendar.getTime());
        BillingEvent billingEvent = BillingEvent.IMPRESSION;
        Long bidAmount = 20000L;
        OptimizationGoal optimizationGoal = OptimizationGoal.APP_ACTIVATE;
        String timeSeries = "111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
        Long adgroupDailyBudget = 1000000L;
        boolean expandEnabled = true;
        List<String> expandTargeting = Arrays.asList("age", "geo_location", "gender");
        List<Long> regionIds = Arrays.asList(310000L, 110000L);
        AdgroupsAddResponseData responseData = this.tencentAds.adgroups().adgroupsAdd(new AdgroupsAddRequest().accountId(this.ACCOUNT_ID).campaignId(campaignId).adgroupName(adgroupName).promotedObjectType(promotedObjectType).beginDate(beginDate).endDate(endDate).billingEvent(billingEvent).bidAmount(bidAmount).optimizationGoal(optimizationGoal).timeSeries(timeSeries).siteSet(siteSet).dailyBudget(adgroupDailyBudget).promotedObjectId(promotedObjectId).targeting(new WriteTargetingSettingForAdgroup().age(Arrays.asList(new AgeStruct().max(45L).min(23L))).gender(Arrays.asList("MALE")).geoLocation(new GeoLocations().locationTypes(Arrays.asList("LIVE_IN")).regions(regionIds)).userOs(Arrays.asList("ANDROID"))).expandEnabled(expandEnabled).expandTargeting(expandTargeting));
        return responseData.getAdgroupId();
    }

    private String addImage(String imageFile) throws Exception {
        String imageSignature = SignatureUtils.getMD5Checksum(imageFile);
        String uploadType = "UPLOAD_TYPE_FILE";
        ImagesAddResponseData responseData = this.tencentAds.images().imagesAdd(this.ACCOUNT_ID, uploadType, imageSignature, new File(imageFile), null, null);
        return responseData.getImageId();
    }

    private Long addAdcreative(Long adcreativeTemplateId, Long campaignId, PromotedObjectType promotedObjectType, String promotedObjectId, List<String> siteSet, String imageId, String adTitle) throws ApiException {
        String adcreativeName = "SDK sample adcreative " + UUID.randomUUID().toString();
        LinkNameTypeMP linkNameType = LinkNameTypeMP.VIEW_DETAILS;
        DestinationType pageType = DestinationType.CANVAS_WECHAT;
        AdcreativesAddResponseData responseData = this.tencentAds.adcreatives().adcreativesAdd(new AdcreativesAddRequest().accountId(this.ACCOUNT_ID).campaignId(campaignId).adcreativeName(adcreativeName).adcreativeTemplateId(adcreativeTemplateId).adcreativeElements(new AdcreativeCreativeElementsMp().imageList(Arrays.asList(imageId)).title(adTitle)).promotedObjectType(promotedObjectType).pageType(pageType).pageSpec(new PageSpec().pageId(WECHAT_PAGE_ID).overrideCanvasHeadOption(OverrideCanvasHeadOption.CANVAS_OVERRIDE_CREATIVE)).linkPageSpec(new LinkPageSpec().pageId(WECHAT_PAGE_ID)).linkPageType(LinkPageType.CANVAS_WECHAT).linkNameType(LinkNameTypeMP.DOWNLOAD_APP).siteSet(siteSet).profileId(PROFILE_ID).promotedObjectId(promotedObjectId));
        return responseData.getAdcreativeId();
    }

    private Long addAd(Long adgroupId, Long adcreativeId) throws ApiException {
        String adName = "SDK sample ad " + UUID.randomUUID().toString().substring(0, 10);
        AdsAddResponseData responseData = this.tencentAds.ads().adsAdd(new AdsAddRequest().accountId(this.ACCOUNT_ID).adgroupId(adgroupId).adcreativeId(adcreativeId).adName(adName));
        return responseData.getAdId();
    }
}

