/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.julienvey.trello.Trello;
import com.julienvey.trello.domain.Card;
import com.julienvey.trello.domain.TrelloEntity;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Label
extends TrelloEntity {
    private String id;
    private String idBoard;
    private String color;
    private String name;

    public Label create() {
        Label label = this.getTrelloService().createLabel(this);
        this.id = label.id;
        return this;
    }

    public Label update() {
        Label updateLabel = this.getTrelloService().updateLabel(this);
        this.id = updateLabel.id;
        this.idBoard = updateLabel.idBoard;
        this.color = updateLabel.color;
        this.name = updateLabel.name;
        return this;
    }

    public Label addToCard(String cardId) {
        this.getTrelloService().addLabelToCard(cardId, this.id);
        return this;
    }

    public Label addToCard(Card card) {
        Objects.requireNonNull(card);
        this.getTrelloService().addLabelToCard(card.getId(), this.id);
        List<Label> labels = card.getLabels();
        if (!labels.contains(this)) {
            labels.add(this);
        }
        return this;
    }

    public void delete() {
        this.getTrelloService().deleteLabel(this.id);
    }

    public Label setInternalTrello(Trello trelloService) {
        return (Label)super.setInternalTrello(trelloService);
    }

    public String getId() {
        return this.id;
    }

    public Label setId(String id) {
        this.id = id;
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public Label setColor(String color) {
        this.color = color;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Label setName(String name) {
        this.name = name;
        return this;
    }

    public String getIdBoard() {
        return this.idBoard;
    }

    public Label setIdBoard(String idBoard) {
        this.idBoard = idBoard;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Label)) {
            return false;
        }
        Label label = (Label)o;
        return Objects.equals(this.id, label.id) && Objects.equals(this.idBoard, label.idBoard) && Objects.equals(this.color, label.color) && Objects.equals(this.name, label.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.idBoard, this.color, this.name);
    }

    public String toString() {
        return "Label{id='" + this.id + '\'' + ", idBoard='" + this.idBoard + '\'' + ", color='" + this.color + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

