/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.julienvey.trello.Trello;
import com.julienvey.trello.domain.Action;
import com.julienvey.trello.domain.AddMemberToBoardResult;
import com.julienvey.trello.domain.Argument;
import com.julienvey.trello.domain.Card;
import com.julienvey.trello.domain.CheckList;
import com.julienvey.trello.domain.Member;
import com.julienvey.trello.domain.MemberType;
import com.julienvey.trello.domain.Membership;
import com.julienvey.trello.domain.MyPrefs;
import com.julienvey.trello.domain.Organization;
import com.julienvey.trello.domain.TList;
import com.julienvey.trello.domain.TrelloEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Board
extends TrelloEntity {
    private String id;
    private String name;
    private String desc;
    private boolean closed;
    private String idOrganization;
    private boolean pinned;
    private String url;
    private Map<String, String> labelNames;
    private boolean invited;
    private List<String> invitations;
    private List<Membership> memberships;
    private String shortUrl;
    private boolean subscribed;
    private Prefs prefs;
    private Date dateLastActivity;
    private Date dateLastView;
    private String shortLink;
    private List<String> powerUps;
    private List<TList> lists = new ArrayList<TList>();

    public List<Action> fetchActions(Argument ... args) {
        return this.trelloService.getBoardActions(this.id, args);
    }

    public List<Card> fetchCards(Argument ... args) {
        return this.trelloService.getBoardCards(this.id, args);
    }

    public Card fetchCard(String cardId, Argument ... args) {
        return this.trelloService.getBoardCard(this.id, cardId, args);
    }

    public List<CheckList> fetchCheckLists(Argument ... args) {
        return this.trelloService.getBoardChecklists(this.id, args);
    }

    public List<TList> fetchLists(Argument ... args) {
        return this.trelloService.getBoardLists(this.id, args);
    }

    public List<Member> fetchMembers() {
        return this.trelloService.getBoardMembers(this.id, new Argument[0]);
    }

    public List<Card> fetchMemberCards(String idMember, Argument ... args) {
        return this.trelloService.getBoardMemberCards(this.id, idMember, args);
    }

    public List<Member> fetchMemberships(Argument ... args) {
        return this.trelloService.getBoardMemberships(this.id, args);
    }

    public MyPrefs fetchMyPrefs() {
        return this.trelloService.getBoardMyPrefs(this.id);
    }

    public Organization fetchOrganization(Argument ... args) {
        return this.trelloService.getBoardOrganization(this.id, args);
    }

    public AddMemberToBoardResult addMember(String email, MemberType type, String fullName) {
        return this.trelloService.addMemberToBoard(this.id, email, type, fullName);
    }

    public AddMemberToBoardResult addMember(String memberId, MemberType type) {
        return this.trelloService.addMemberToBoard(this.id, memberId, type);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public String getIdOrganization() {
        return this.idOrganization;
    }

    public void setIdOrganization(String idOrganization) {
        this.idOrganization = idOrganization;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getLabelNames() {
        return this.labelNames;
    }

    public void setLabelNames(Map<String, String> labelNames) {
        this.labelNames = labelNames;
    }

    public boolean isInvited() {
        return this.invited;
    }

    public void setInvited(boolean invited) {
        this.invited = invited;
    }

    public List<String> getInvitations() {
        return this.invitations;
    }

    public void setInvitations(List<String> invitations) {
        this.invitations = invitations;
    }

    public List<Membership> getMemberships() {
        return this.memberships;
    }

    public void setMemberships(List<Membership> memberships) {
        this.memberships = memberships;
    }

    public String getShortUrl() {
        return this.shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    public Date getDateLastActivity() {
        return this.dateLastActivity;
    }

    public void setDateLastActivity(Date dateLastActivity) {
        this.dateLastActivity = dateLastActivity;
    }

    public Date getDateLastView() {
        return this.dateLastView;
    }

    public void setDateLastView(Date dateLastView) {
        this.dateLastView = dateLastView;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public String getShortLink() {
        return this.shortLink;
    }

    public void setShortLink(String shortLink) {
        this.shortLink = shortLink;
    }

    public List<String> getPowerUps() {
        return this.powerUps;
    }

    public void setPowerUps(List<String> powerUps) {
        this.powerUps = powerUps;
    }

    public List<TList> getLists() {
        return this.lists;
    }

    public void setLists(List<TList> lists) {
        this.lists = lists;
    }

    public Board setInternalTrello(Trello trelloService) {
        this.trelloService = trelloService;
        this.getLists().forEach(list -> list.setInternalTrello(trelloService));
        return this;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Prefs {
        private String permissionLevel;
        private String voting;
        private String comments;
        private String invitations;
        private String cardAging;
        private boolean selfJoin;
        private boolean cardCovers;
        private boolean canBePublic;
        private boolean canBeOrg;
        private boolean canBePrivate;
        private boolean canInvite;
        private boolean calendarFeedEnabled;

        public boolean isCalendarFeedEnabled() {
            return this.calendarFeedEnabled;
        }

        public void setCalendarFeedEnabled(boolean calendarFeedEnabled) {
            this.calendarFeedEnabled = calendarFeedEnabled;
        }

        public String getCardAging() {
            return this.cardAging;
        }

        public void setCardAging(String cardAging) {
            this.cardAging = cardAging;
        }

        public String getPermissionLevel() {
            return this.permissionLevel;
        }

        public void setPermissionLevel(String permissionLevel) {
            this.permissionLevel = permissionLevel;
        }

        public String getVoting() {
            return this.voting;
        }

        public void setVoting(String voting) {
            this.voting = voting;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getInvitations() {
            return this.invitations;
        }

        public void setInvitations(String invitations) {
            this.invitations = invitations;
        }

        public boolean isSelfJoin() {
            return this.selfJoin;
        }

        public void setSelfJoin(boolean selfJoin) {
            this.selfJoin = selfJoin;
        }

        public boolean isCardCovers() {
            return this.cardCovers;
        }

        public void setCardCovers(boolean cardCovers) {
            this.cardCovers = cardCovers;
        }

        public boolean isCanBePublic() {
            return this.canBePublic;
        }

        public void setCanBePublic(boolean canBePublic) {
            this.canBePublic = canBePublic;
        }

        public boolean isCanBeOrg() {
            return this.canBeOrg;
        }

        public void setCanBeOrg(boolean canBeOrg) {
            this.canBeOrg = canBeOrg;
        }

        public boolean isCanBePrivate() {
            return this.canBePrivate;
        }

        public void setCanBePrivate(boolean canBePrivate) {
            this.canBePrivate = canBePrivate;
        }

        public boolean isCanInvite() {
            return this.canInvite;
        }

        public void setCanInvite(boolean canInvite) {
            this.canInvite = canInvite;
        }
    }
}

