/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineConfigurationException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.TransportConfiguration;
import com.taskadapter.redmineapi.internal.Transport;
import com.taskadapter.redmineapi.internal.URIConfigurator;
import com.taskadapter.redmineapi.internal.comm.ConnectionEvictor;
import com.taskadapter.redmineapi.internal.comm.naivessl.NaiveSSLFactory;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class RedmineManagerFactory {
    private RedmineManagerFactory() {
        throw new UnsupportedOperationException();
    }

    public static RedmineManager createUnauthenticated(String uri) {
        return RedmineManagerFactory.createUnauthenticated(uri, RedmineManagerFactory.createDefaultTransportConfig());
    }

    public static RedmineManager createUnauthenticated(String uri, TransportConfiguration config) {
        return RedmineManagerFactory.createWithUserAuth(uri, null, null, config);
    }

    public static RedmineManager createWithApiKey(String uri, String apiAccessKey) {
        return RedmineManagerFactory.createWithApiKey(uri, apiAccessKey, RedmineManagerFactory.createDefaultTransportConfig());
    }

    public static RedmineManager createWithApiKey(String uri, String apiAccessKey, TransportConfiguration config) {
        return new RedmineManager(new Transport(new URIConfigurator(uri, apiAccessKey), config.client), config.shutdownListener);
    }

    public static RedmineManager createWithUserAuth(String uri, String login, String password) {
        return RedmineManagerFactory.createWithUserAuth(uri, login, password, RedmineManagerFactory.createDefaultTransportConfig());
    }

    public static RedmineManager createWithUserAuth(String uri, String login, String password, TransportConfiguration config) {
        Transport transport = new Transport(new URIConfigurator(uri, null), config.client);
        transport.setCredentials(login, password);
        return new RedmineManager(transport, config.shutdownListener);
    }

    public static PoolingClientConnectionManager createInsecureConnectionManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        return RedmineManagerFactory.createConnectionManager(Integer.MAX_VALUE, NaiveSSLFactory.createNaiveSSLSocketFactory());
    }

    public static PoolingClientConnectionManager createDefaultConnectionManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        return RedmineManagerFactory.createConnectionManager(Integer.MAX_VALUE, SSLSocketFactory.getSocketFactory());
    }

    public static PoolingClientConnectionManager createSystemDefaultConnectionManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        return RedmineManagerFactory.createConnectionManager(Integer.MAX_VALUE, SSLSocketFactory.getSystemSocketFactory());
    }

    public static PoolingClientConnectionManager createConnectionManager(int maxConnections, SSLSocketFactory sslSocketFactory) {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory));
        PoolingClientConnectionManager manager = new PoolingClientConnectionManager(registry);
        manager.setMaxTotal(maxConnections);
        manager.setDefaultMaxPerRoute(maxConnections);
        return manager;
    }

    public static TransportConfiguration createDefaultHttpClientConfig() {
        return TransportConfiguration.create((HttpClient)new DefaultHttpClient(), null);
    }

    public static TransportConfiguration createShortTermConfig(final ClientConnectionManager connectionManager) {
        return TransportConfiguration.create((HttpClient)RedmineManagerFactory.getNewHttpClient(connectionManager), new Runnable(){

            @Override
            public void run() {
                connectionManager.shutdown();
            }
        });
    }

    public static TransportConfiguration createLongTermConfiguration(final ClientConnectionManager connectionManager, int idleTimeout, int evictionCheck) {
        final ConnectionEvictor evictor = new ConnectionEvictor(connectionManager, evictionCheck, idleTimeout);
        Thread evictorThread = new Thread(evictor);
        evictorThread.setDaemon(true);
        evictorThread.setName("Redmine communicator connection eviction thread");
        evictorThread.start();
        try {
            return TransportConfiguration.create((HttpClient)RedmineManagerFactory.getNewHttpClient(connectionManager), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        connectionManager.shutdown();
                    }
                    finally {
                        evictor.shutdown();
                    }
                }
            });
        }
        catch (RuntimeException t) {
            evictor.shutdown();
            throw t;
        }
        catch (Error e) {
            evictor.shutdown();
            throw e;
        }
    }

    public static TransportConfiguration createDefaultTransportConfig() {
        try {
            return RedmineManagerFactory.createShortTermConfig((ClientConnectionManager)RedmineManagerFactory.createSystemDefaultConnectionManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            return RedmineManagerFactory.createDefaultHttpClientConfig();
        }
    }

    public static DefaultHttpClient getNewHttpClient(ClientConnectionManager connectionManager) {
        try {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            DefaultHttpClient result = new DefaultHttpClient(connectionManager, (HttpParams)params);
            RedmineManagerFactory.configureProxy(result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DefaultHttpClient();
        }
    }

    private static void configureProxy(DefaultHttpClient httpclient) {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            int port;
            try {
                port = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException e) {
                throw new RedmineConfigurationException("Illegal proxy port " + proxyPort, e);
            }
            HttpHost proxy = new HttpHost(proxyHost, port);
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                String proxyPassword = System.getProperty("http.proxyPassword");
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
        }
    }
}

