/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.proxy.server.handler.http;

import com.alibaba.arthas.nat.agent.common.handler.HttpOptionRequestHandler;
import com.alibaba.arthas.nat.agent.proxy.server.handler.http.HttpNativeAgentHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;

public class HttpRequestHandler {
    private static HttpNativeAgentHandler httpNativeAgentHandler = new HttpNativeAgentHandler();
    private static HttpOptionRequestHandler httpOptionRequestHandler = new HttpOptionRequestHandler();

    public void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        String path = new URI(request.uri()).getPath();
        HttpMethod method = request.method();
        FullHttpResponse resp = null;
        if (HttpMethod.OPTIONS.equals(method)) {
            resp = httpOptionRequestHandler.handleOptionsRequest(ctx, request);
        }
        if (HttpMethod.POST.equals(method) && "/api/native-agent-proxy".equals(path)) {
            resp = httpNativeAgentHandler.handle(ctx, request);
        }
        if (resp == null) {
            resp = new DefaultFullHttpResponse(request.getProtocolVersion(), HttpResponseStatus.NOT_FOUND);
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=utf-8");
        }
        ctx.writeAndFlush(resp).addListener(ChannelFutureListener.CLOSE);
    }
}

