/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import io.etcd.jetcd.Cluster;
import io.etcd.jetcd.api.MemberAddRequest;
import io.etcd.jetcd.api.MemberListRequest;
import io.etcd.jetcd.api.MemberRemoveRequest;
import io.etcd.jetcd.api.MemberUpdateRequest;
import io.etcd.jetcd.api.VertxClusterGrpc;
import io.etcd.jetcd.cluster.MemberAddResponse;
import io.etcd.jetcd.cluster.MemberListResponse;
import io.etcd.jetcd.cluster.MemberRemoveResponse;
import io.etcd.jetcd.cluster.MemberUpdateResponse;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.impl.Impl;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

final class ClusterImpl
extends Impl
implements Cluster {
    private final VertxClusterGrpc.ClusterVertxStub stub;

    ClusterImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxClusterGrpc::newVertxStub);
    }

    @Override
    public CompletableFuture<MemberListResponse> listMember() {
        return this.completable(this.stub.memberList(MemberListRequest.getDefaultInstance()), MemberListResponse::new);
    }

    @Override
    public CompletableFuture<MemberAddResponse> addMember(List<URI> peerAddrs) {
        MemberAddRequest memberAddRequest = MemberAddRequest.newBuilder().addAllPeerURLs(peerAddrs.stream().map(URI::toString).collect(Collectors.toList())).build();
        return this.completable(this.stub.memberAdd(memberAddRequest), MemberAddResponse::new);
    }

    @Override
    public CompletableFuture<MemberRemoveResponse> removeMember(long memberID) {
        MemberRemoveRequest memberRemoveRequest = MemberRemoveRequest.newBuilder().setID(memberID).build();
        return this.completable(this.stub.memberRemove(memberRemoveRequest), MemberRemoveResponse::new);
    }

    @Override
    public CompletableFuture<MemberUpdateResponse> updateMember(long memberID, List<URI> peerAddrs) {
        MemberUpdateRequest memberUpdateRequest = MemberUpdateRequest.newBuilder().addAllPeerURLs(peerAddrs.stream().map(URI::toString).collect(Collectors.toList())).setID(memberID).build();
        return this.completable(this.stub.memberUpdate(memberUpdateRequest), MemberUpdateResponse::new);
    }
}

