/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class PropertiesUtils {
    public static <T> T toJavaObject(Properties properties, Class<T> clazz) {
        return PropertiesUtils.toJavaObject(properties, JSONFactory.getDefaultObjectReaderProvider(), clazz, new JSONReader.Feature[0]);
    }

    public static <T> T toJavaObject(Properties properties, ObjectReaderProvider provider, Class<T> clazz, JSONReader.Feature ... features) {
        ObjectReader reader = provider.getObjectReader(clazz);
        Object instance = reader.createInstance(JSONReader.Feature.of(features));
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int dotIndex = key.lastIndexOf(".");
            if (dotIndex == -1) {
                FieldReader fieldReader = reader.getFieldReader(key);
                if (fieldReader == null) continue;
                Object fieldValue = TypeUtils.cast((Object)value, fieldReader.fieldType);
                fieldReader.accept(instance, fieldValue);
                continue;
            }
            JSONPath.set(instance, key, (Object)value);
        }
        return instance;
    }

    public static Properties toProperties(Object object) {
        return PropertiesUtils.toProperties(JSONFactory.getDefaultObjectWriterProvider(), object, new JSONWriter.Feature[0]);
    }

    public static Properties toProperties(ObjectWriterProvider provider, Object object, JSONWriter.Feature ... features) {
        IdentityHashMap<Object, String> values2 = new IdentityHashMap<Object, String>();
        Properties properties = new Properties();
        PropertiesUtils.paths(provider, values2, properties, null, object);
        return properties;
    }

    static void paths(ObjectWriterProvider provider, Map<Object, String> values2, Map paths, String parent, Object javaObject) {
        if (javaObject == null) {
            return;
        }
        String p = values2.put(javaObject, parent);
        if (p != null) {
            boolean basicType;
            Class<?> type = javaObject.getClass();
            boolean bl = basicType = type == String.class || type == Boolean.class || type == Character.class || type == UUID.class || javaObject instanceof Enum || javaObject instanceof Number || javaObject instanceof Date;
            if (!basicType) {
                return;
            }
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            for (Map.Entry entryObj : map.entrySet()) {
                Map.Entry entry = entryObj;
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                String strKey = (String)key;
                boolean escape = strKey.isEmpty();
                if (!escape) {
                    char c0 = strKey.charAt(0);
                    boolean bl = escape = !(c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z' || c0 == '_');
                    if (!escape) {
                        for (int i = 1; i < strKey.length(); ++i) {
                            char ch = strKey.charAt(i);
                            boolean bl2 = escape = !(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_');
                            if (escape) break;
                        }
                    }
                }
                String path = escape ? parent + '[' + JSON.toJSONString((Object)strKey, JSONWriter.Feature.UseSingleQuotes) + ']' : (parent != null ? parent + "." + strKey : strKey);
                PropertiesUtils.paths(provider, values2, paths, path, entry.getValue());
            }
            return;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            int i = 0;
            for (Object item : collection) {
                String path = parent + "[" + i + "]";
                PropertiesUtils.paths(provider, values2, paths, path, item);
                ++i;
            }
            return;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                String path = parent + "[" + i + "]";
                PropertiesUtils.paths(provider, values2, paths, path, item);
            }
            return;
        }
        if (ObjectWriterProvider.isPrimitiveOrEnum(clazz)) {
            String propertyValue = javaObject == null ? "" : javaObject.toString();
            paths.put(parent, propertyValue);
            return;
        }
        ObjectWriter serializer = provider.getObjectWriter(clazz);
        if (serializer instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter javaBeanSerializer = (ObjectWriterAdapter)serializer;
            try {
                Map<String, Object> fieldValues = javaBeanSerializer.toMap(javaObject);
                for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) continue;
                    String path = parent != null ? parent + "." + key : key;
                    PropertiesUtils.paths(provider, values2, paths, path, entry.getValue());
                }
            }
            catch (Exception e) {
                throw new JSONException("toJSON error", e);
            }
        }
    }
}

