/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yetus.audience.tools;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

class RootDocProcessor {
    static String stability = "-unstable";
    static boolean treatUnannotatedClassesAsPrivate = false;
    private static Map<Object, Object> proxies = new WeakHashMap<Object, Object>();

    RootDocProcessor() {
    }

    public static RootDoc process(RootDoc root) {
        return (RootDoc)RootDocProcessor.process(root, RootDoc.class);
    }

    private static Object process(Object obj, Class<?> type) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        if (cls.getName().startsWith("com.sun.")) {
            return RootDocProcessor.getProxy(obj);
        }
        if (obj instanceof Object[]) {
            Class<?> componentType = type.isArray() ? type.getComponentType() : cls.getComponentType();
            Object[] array = (Object[])obj;
            Object[] newArray = (Object[])Array.newInstance(componentType, array.length);
            for (int i = 0; i < array.length; ++i) {
                newArray[i] = RootDocProcessor.process(array[i], componentType);
            }
            return newArray;
        }
        return obj;
    }

    private static Object getProxy(Object obj) {
        Object proxy = proxies.get(obj);
        if (proxy == null) {
            proxy = Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new ExcludeHandler(obj));
            proxies.put(obj, proxy);
        }
        return proxy;
    }

    private static class ExcludeHandler
    implements InvocationHandler {
        private Object target;

        public ExcludeHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            String methodName = method.getName();
            if (this.target instanceof Doc) {
                if (methodName.equals("isIncluded")) {
                    Doc doc = (Doc)this.target;
                    return !ExcludeHandler.exclude(doc) && doc.isIncluded();
                }
                if (this.target instanceof RootDoc) {
                    switch (methodName) {
                        case "classes": {
                            return ExcludeHandler.filter((Doc[])((RootDoc)this.target).classes(), ClassDoc.class);
                        }
                        case "specifiedClasses": {
                            return ExcludeHandler.filter((Doc[])((RootDoc)this.target).specifiedClasses(), ClassDoc.class);
                        }
                        case "specifiedPackages": {
                            return ExcludeHandler.filter((Doc[])((RootDoc)this.target).specifiedPackages(), PackageDoc.class);
                        }
                    }
                } else if (this.target instanceof ClassDoc) {
                    if (this.isFiltered(args2)) {
                        switch (methodName) {
                            case "methods": {
                                return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).methods(true), MethodDoc.class);
                            }
                            case "fields": {
                                return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).fields(true), FieldDoc.class);
                            }
                            case "innerClasses": {
                                return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).innerClasses(true), ClassDoc.class);
                            }
                            case "constructors": {
                                return ExcludeHandler.filter((Doc[])((ClassDoc)this.target).constructors(true), ConstructorDoc.class);
                            }
                        }
                    }
                } else if (this.target instanceof PackageDoc) {
                    switch (methodName) {
                        case "allClasses": {
                            if (this.isFiltered(args2)) {
                                return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).allClasses(true), ClassDoc.class);
                            }
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).allClasses(), ClassDoc.class);
                        }
                        case "annotationTypes": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).annotationTypes(), AnnotationTypeDoc.class);
                        }
                        case "enums": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).enums(), ClassDoc.class);
                        }
                        case "errors": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).errors(), ClassDoc.class);
                        }
                        case "exceptions": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).exceptions(), ClassDoc.class);
                        }
                        case "interfaces": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).interfaces(), ClassDoc.class);
                        }
                        case "ordinaryClasses": {
                            return ExcludeHandler.filter((Doc[])((PackageDoc)this.target).ordinaryClasses(), ClassDoc.class);
                        }
                    }
                }
            }
            if (args2 != null && (methodName.equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
                args2[0] = this.unwrap(args2[0]);
            }
            try {
                return RootDocProcessor.process(method.invoke(this.target, args2), method.getReturnType());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private static boolean exclude(Doc doc) {
            AnnotationDesc[] annotations = null;
            if (doc instanceof ProgramElementDoc) {
                annotations = ((ProgramElementDoc)doc).annotations();
            } else if (doc instanceof PackageDoc) {
                annotations = ((PackageDoc)doc).annotations();
            }
            if (annotations != null) {
                String qualifiedTypeName;
                for (AnnotationDesc annotation : annotations) {
                    qualifiedTypeName = annotation.annotationType().qualifiedTypeName();
                    if (qualifiedTypeName.equals(InterfaceAudience.Private.class.getCanonicalName()) || qualifiedTypeName.equals(InterfaceAudience.LimitedPrivate.class.getCanonicalName())) {
                        return true;
                    }
                    if (stability.equals("-evolving") && qualifiedTypeName.equals(InterfaceStability.Unstable.class.getCanonicalName())) {
                        return true;
                    }
                    if (!stability.equals("-stable") || !qualifiedTypeName.equals(InterfaceStability.Unstable.class.getCanonicalName()) && !qualifiedTypeName.equals(InterfaceStability.Evolving.class.getCanonicalName())) continue;
                    return true;
                }
                for (AnnotationDesc annotation : annotations) {
                    qualifiedTypeName = annotation.annotationType().qualifiedTypeName();
                    if (!qualifiedTypeName.equals(InterfaceAudience.Public.class.getCanonicalName())) continue;
                    return false;
                }
            }
            if (treatUnannotatedClassesAsPrivate) {
                return doc.isClass() || doc.isInterface() || doc.isAnnotationType();
            }
            return false;
        }

        private static Object[] filter(Doc[] array, Class<?> componentType) {
            if (array == null || array.length == 0) {
                return array;
            }
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (Doc entry : array) {
                if (ExcludeHandler.exclude(entry)) continue;
                list.add(RootDocProcessor.process(entry, componentType));
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }

        private Object unwrap(Object proxy) {
            if (proxy instanceof Proxy) {
                return ((ExcludeHandler)Proxy.getInvocationHandler((Object)proxy)).target;
            }
            return proxy;
        }

        private boolean isFiltered(Object[] args2) {
            return args2 != null && Boolean.TRUE.equals(args2[0]);
        }
    }
}

