/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;

public class RecordWriter {
    private OutputArchive archive;
    private static HashMap<String, Method> archiveFactory = RecordWriter.constructFactory();

    static HashMap<String, Method> constructFactory() {
        HashMap<String, Method> factory2 = new HashMap<String, Method>();
        try {
            factory2.put("binary", BinaryOutputArchive.class.getDeclaredMethod("getArchive", OutputStream.class));
        }
        catch (NoSuchMethodException | SecurityException ex) {
            ex.printStackTrace();
        }
        return factory2;
    }

    private static OutputArchive createArchive(OutputStream out, String format) {
        Method factory2 = archiveFactory.get(format);
        if (factory2 != null) {
            Object[] params = new Object[]{out};
            try {
                return (OutputArchive)factory2.invoke(null, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public RecordWriter(OutputStream out, String format) {
        this.archive = RecordWriter.createArchive(out, format);
    }

    public void write(Record r) throws IOException {
        r.serialize(this.archive, "");
    }
}

