/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.proxy.discovery.impl;

import com.alibaba.arthas.nat.agent.proxy.discovery.NativeAgentDiscovery;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZookeeperNativeAgentDiscovery
implements NativeAgentDiscovery {
    private static final int SESSION_TIMEOUT = 20000;
    private static final CountDownLatch connectedSemaphore = new CountDownLatch(1);

    @Override
    public Map<String, String> findNativeAgent(String address) {
        if (address == null || "".equals(address)) {
            return null;
        }
        try {
            ZooKeeper zooKeeper = new ZooKeeper(address, 20000, event -> {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    connectedSemaphore.countDown();
                }
            });
            connectedSemaphore.await();
            List<String> children = zooKeeper.getChildren("/native-agent", false);
            ConcurrentHashMap<String, String> res = new ConcurrentHashMap<String, String>(children.size());
            for (String child : children) {
                String childPath = "/native-agent/" + child;
                byte[] data = zooKeeper.getData(childPath, false, new Stat());
                String dataStr = new String(data);
                res.put(child, dataStr);
            }
            zooKeeper.close();
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

