/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.cli.annotations;

import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.TypedArgument;
import io.vertx.core.cli.TypedOption;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.ConvertedBy;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Hidden;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.ParsedAsList;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.cli.impl.DefaultCLI;
import io.vertx.core.cli.impl.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CLIConfigurator {
    public static CLI define(Class<?> clazz) {
        DefaultCLI cli = new DefaultCLI();
        Summary summary = clazz.getAnnotation(Summary.class);
        Description desc = clazz.getAnnotation(Description.class);
        Hidden hidden = clazz.getAnnotation(Hidden.class);
        Name name = clazz.getAnnotation(Name.class);
        if (name == null) {
            throw new IllegalArgumentException("The command cannot be defined, the @Name annotation is missing.");
        }
        if (name.value().isEmpty()) {
            throw new IllegalArgumentException("The command cannot be defined, the @Name value is empty or null.");
        }
        cli.setName(name.value());
        cli.setPriority(name.priority());
        if (summary != null) {
            cli.setSummary(summary.value());
        }
        if (desc != null) {
            cli.setDescription(desc.value());
        }
        if (hidden != null) {
            cli.setHidden(true);
        }
        List<Method> methods = ReflectionUtils.getSetterMethods(clazz);
        for (Method method : methods) {
            io.vertx.core.cli.annotations.Option option = method.getAnnotation(io.vertx.core.cli.annotations.Option.class);
            Argument argument = method.getAnnotation(Argument.class);
            if (option != null) {
                cli.addOption(CLIConfigurator.createOption(method));
            }
            if (argument == null) continue;
            cli.addArgument(CLIConfigurator.createArgument(method));
        }
        return cli;
    }

    private static Option createOption(Method method) {
        DefaultValue defaultValue;
        ParsedAsList parsedAsList;
        Hidden hidden;
        TypedOption opt = new TypedOption();
        io.vertx.core.cli.annotations.Option option = method.getAnnotation(io.vertx.core.cli.annotations.Option.class);
        ((TypedOption)((TypedOption)((TypedOption)((TypedOption)((TypedOption)opt.setLongName(option.longName())).setShortName(option.shortName())).setMultiValued(option.acceptMultipleValues())).setSingleValued(option.acceptValue())).setArgName(option.argName())).setFlag(option.flag()).setHelp(option.help()).setRequired(option.required());
        Description description = method.getAnnotation(Description.class);
        if (description != null) {
            opt.setDescription(description.value());
        }
        if ((hidden = method.getAnnotation(Hidden.class)) != null) {
            opt.setHidden(true);
        }
        if (ReflectionUtils.isMultiple(method)) {
            opt.setType(ReflectionUtils.getComponentType(method.getParameters()[0])).setMultiValued(true);
        } else {
            Class<?> type = method.getParameters()[0].getType();
            opt.setType(type);
            if (type != Boolean.TYPE && type != Boolean.class) {
                opt.setSingleValued(true);
            }
        }
        ConvertedBy convertedBy = method.getAnnotation(ConvertedBy.class);
        if (convertedBy != null) {
            opt.setConverter(ReflectionUtils.newInstance(convertedBy.value()));
        }
        if ((parsedAsList = method.getAnnotation(ParsedAsList.class)) != null) {
            opt.setParsedAsList(true).setListSeparator(parsedAsList.separator());
        }
        if ((defaultValue = method.getAnnotation(DefaultValue.class)) != null) {
            opt.setDefaultValue(defaultValue.value());
        }
        opt.ensureValidity();
        return opt;
    }

    private static io.vertx.core.cli.Argument createArgument(Method method) {
        DefaultValue defaultValue;
        ConvertedBy convertedBy;
        TypedArgument arg = new TypedArgument();
        Argument argument = method.getAnnotation(Argument.class);
        arg.setIndex(argument.index());
        arg.setArgName(argument.argName());
        arg.setRequired(argument.required());
        Description description = method.getAnnotation(Description.class);
        if (description != null) {
            arg.setDescription(description.value());
        }
        if (ReflectionUtils.isMultiple(method)) {
            arg.setType(ReflectionUtils.getComponentType(method.getParameters()[0])).setMultiValued(true);
        } else {
            Class<?> type = method.getParameters()[0].getType();
            arg.setType(type);
        }
        Hidden hidden = method.getAnnotation(Hidden.class);
        if (hidden != null) {
            arg.setHidden(true);
        }
        if ((convertedBy = method.getAnnotation(ConvertedBy.class)) != null) {
            arg.setConverter(ReflectionUtils.newInstance(convertedBy.value()));
        }
        if ((defaultValue = method.getAnnotation(DefaultValue.class)) != null) {
            arg.setDefaultValue(defaultValue.value());
        }
        return arg;
    }

    private static Object getOptionValue(Method method, String name, CommandLine commandLine) {
        Option option = commandLine.cli().getOption(name);
        if (option == null) {
            return null;
        }
        boolean multiple = ReflectionUtils.isMultiple(method);
        if (multiple) {
            return CLIConfigurator.createMultiValueContainer(method, commandLine.getOptionValues(name));
        }
        return commandLine.getOptionValue(name);
    }

    private static Object getArgumentValue(Method method, int index, CommandLine commandLine) {
        io.vertx.core.cli.Argument argument = commandLine.cli().getArgument(index);
        if (argument == null) {
            return null;
        }
        boolean multiple = ReflectionUtils.isMultiple(method);
        if (multiple) {
            return CLIConfigurator.createMultiValueContainer(method, commandLine.getArgumentValues(argument.getIndex()));
        }
        return commandLine.getArgumentValue(argument.getIndex());
    }

    public static void inject(CommandLine cli, Object object) throws CLIException {
        List<Method> methods = ReflectionUtils.getSetterMethods(object.getClass());
        for (Method method : methods) {
            Object injected;
            io.vertx.core.cli.annotations.Option option = method.getAnnotation(io.vertx.core.cli.annotations.Option.class);
            Argument argument = method.getAnnotation(Argument.class);
            if (option != null) {
                String name = option.longName();
                if (name == null) {
                    name = option.shortName();
                }
                try {
                    injected = CLIConfigurator.getOptionValue(method, name, cli);
                    if (injected != null) {
                        method.setAccessible(true);
                        method.invoke(object, injected);
                    }
                }
                catch (Exception e) {
                    throw new CLIException("Cannot inject value for option '" + name + "'", e);
                }
            }
            if (argument == null) continue;
            int index = argument.index();
            try {
                injected = CLIConfigurator.getArgumentValue(method, index, cli);
                if (injected == null) continue;
                method.setAccessible(true);
                method.invoke(object, injected);
            }
            catch (Exception e) {
                throw new CLIException("Cannot inject value for argument '" + index + "'", e);
            }
        }
    }

    private static <T> Object createMultiValueContainer(Method setter, List<T> values2) {
        Class<?> type = setter.getParameterTypes()[0];
        if (type.isArray()) {
            Object array = Array.newInstance(type.getComponentType(), values2.size());
            for (int i = 0; i < values2.size(); ++i) {
                Array.set(array, i, values2.get(i));
            }
            return array;
        }
        if (Set.class.isAssignableFrom(type)) {
            return new LinkedHashSet<T>(values2);
        }
        if (List.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type)) {
            return values2;
        }
        return null;
    }
}

