package com.takwolf.android.widget;

import android.content.Context;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;

import java.util.ArrayList;
import java.util.List;

public class WebView extends android.webkit.WebView {

    private List<OnScrollListener> onScrollListenerList;

    public WebView(@NonNull Context context) {
        super(context);
    }

    public WebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public WebView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public WebView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (onScrollListenerList != null && onScrollListenerList.size() > 0) {
            for (OnScrollListener onScrollListener : onScrollListenerList) {
                onScrollListener.onScrollChanged(l, t, oldl, oldt);
            }
        }
    }

    public void addOnScrollListener(OnScrollListener listener) {
        if (onScrollListenerList == null) {
            onScrollListenerList = new ArrayList<>();
        }
        onScrollListenerList.add(listener);
    }

    public void removeOnScrollListener(OnScrollListener listener) {
        if (onScrollListenerList != null) {
            onScrollListenerList.remove(listener);
        }
    }

    public void clearOnScrollListeners() {
        if (onScrollListenerList != null) {
            onScrollListenerList.clear();
        }
    }

    public interface OnScrollListener {

        void onScrollChanged(int l, int t, int oldl, int oldt);

    }

}
