package com.takwolf.android.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;

public class ListView extends android.widget.ListView {

    private final AbsListViewOnScrollListenerProxy onScrollListenerProxy = new AbsListViewOnScrollListenerProxy();

    public ListView(Context context) {
        super(context);
        init();
    }

    public ListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public ListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public ListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init();
    }

    private void init() {
        super.setOnScrollListener(onScrollListenerProxy);
    }

    @Override
    @Deprecated
    public void setOnScrollListener(OnScrollListener listener) {
        onScrollListenerProxy.setOnScrollListener(listener);
    }

    public void addOnScrollListener(OnScrollListener listener) {
        onScrollListenerProxy.addOnScrollListener(listener);
    }

    public void removeOnScrollListener(OnScrollListener listener) {
        onScrollListenerProxy.removeOnScrollListener(listener);
    }

    public void clearOnScrollListeners() {
        onScrollListenerProxy.clearOnScrollListeners();
    }

}
