package com.takwolf.android.widget;

import android.content.Context;
import android.util.AttributeSet;

import in.srain.cube.views.GridViewWithHeaderAndFooter;

public class GridView extends GridViewWithHeaderAndFooter {

    private final AbsListViewOnScrollListenerProxy onScrollListenerProxy = new AbsListViewOnScrollListenerProxy();

    public GridView(Context context) {
        super(context);
        init();
    }

    public GridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public GridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }

    private void init() {
        super.setOnScrollListener(onScrollListenerProxy);
    }

    @Override
    @Deprecated
    public void setOnScrollListener(OnScrollListener listener) {
        onScrollListenerProxy.setOnScrollListener(listener);
    }

    public void addOnScrollListener(OnScrollListener listener) {
        onScrollListenerProxy.addOnScrollListener(listener);
    }

    public void removeOnScrollListener(OnScrollListener listener) {
        onScrollListenerProxy.removeOnScrollListener(listener);
    }

    public void clearOnScrollListeners() {
        onScrollListenerProxy.clearOnScrollListeners();
    }

}
