/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.fix.support.v7.preference;

import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.preference.R;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.takisoft.fix.support.v7.preference.PreferenceFragmentCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class PreferenceFragmentCompatDividers
extends PreferenceFragmentCompat {
    public static final int DIVIDER_DEFAULT = -1;
    public static final int DIVIDER_NONE = 0;
    public static final int DIVIDER_CATEGORY_BETWEEN = 1;
    public static final int DIVIDER_CATEGORY_BEFORE_FIRST = 2;
    public static final int DIVIDER_CATEGORY_AFTER_LAST = 4;
    public static final int DIVIDER_PREFERENCE_BETWEEN = 16;
    public static final int DIVIDER_PREFERENCE_BEFORE_FIRST = 32;
    public static final int DIVIDER_PREFERENCE_AFTER_LAST = 64;
    public static final int DIVIDER_PADDING_CHILD = 256;
    public static final int DIVIDER_PADDING_PARENT = 512;
    private boolean divPrefInvalid = false;
    private int divPrefFlags = -1;
    private DividerItemDecoration divItemDecoration;

    protected void setDividerPreferences(int flags) {
        RecyclerView recyclerView = this.getListView();
        if (recyclerView == null) {
            Log.w((String)"PreferenceFragmentFix", (String)"Warning: setDividerPreferences(flags) was called before the list was constructed. Please, move the method to onCreateView(...) after the super.onCreateView(...) call!");
            this.divPrefFlags = flags;
            this.divPrefInvalid = true;
            return;
        }
        if (this.divPrefFlags == flags && !this.divPrefInvalid) {
            return;
        }
        this.applyDividerPreference(recyclerView, flags);
    }

    void applyDividerPreference(RecyclerView recyclerView, int flags) {
        this.divPrefFlags = flags;
        this.divPrefInvalid = false;
        boolean viewCompatFixNeeded = PreferenceFragmentCompatDividers.isViewCompatMessedUp();
        if (flags == 0) {
            this.setDivider(null);
            if (this.divItemDecoration != null) {
                recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.divItemDecoration);
                this.divItemDecoration = null;
            }
        } else if (flags == -1 && !viewCompatFixNeeded) {
            Drawable divider = this.getDividerDrawable();
            this.setDivider(divider);
            if (this.divItemDecoration != null) {
                recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.divItemDecoration);
                this.divItemDecoration = null;
            }
        } else {
            super.setDivider(null);
            if (flags == -1) {
                this.divPrefFlags = 16;
            }
            if (this.divItemDecoration == null) {
                this.divItemDecoration = new DividerItemDecoration(this.getDividerDrawable());
                recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.divItemDecoration);
            }
        }
        recyclerView.invalidateItemDecorations();
    }

    Drawable getDividerDrawable() {
        TypedArray a = this.getPreferenceManager().getContext().obtainStyledAttributes(null, R.styleable.PreferenceFragmentCompat, 2130772166, 0);
        Drawable divider = a.getDrawable(1);
        a.recycle();
        return divider;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (PreferenceFragmentCompatDividers.isViewCompatMessedUp()) {
            this.divPrefInvalid = true;
        }
        this.setDividerPreferences(this.divPrefFlags);
    }

    public void setDivider(Drawable divider) {
        super.setDivider(divider);
        if (this.divItemDecoration != null) {
            this.divItemDecoration.setDivider(divider);
        }
    }

    public void setDividerHeight(int height) {
        super.setDividerHeight(height);
        if (this.divItemDecoration != null) {
            this.divItemDecoration.setDividerHeight(height);
        }
    }

    static boolean isViewCompatMessedUp() {
        return Build.VERSION.SDK_INT < 11;
    }

    protected class DividerItemDecoration
    extends RecyclerView.ItemDecoration {
        private static final byte TYPE_CATEGORY = 0;
        private static final byte TYPE_PREFERENCE = 1;
        private static final byte TYPE_UNKNOWN = -1;
        private Drawable divider;
        private int dividerHeight;

        private DividerItemDecoration(Drawable divider) {
            this.divider = divider;
            if (divider != null) {
                this.dividerHeight = divider.getIntrinsicHeight();
            }
        }

        public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
            if (this.divider != null) {
                int right;
                int left;
                LinearLayoutManager lm = (LinearLayoutManager)parent.getLayoutManager();
                int first = lm.findFirstVisibleItemPosition();
                int last = lm.findLastVisibleItemPosition();
                if ((PreferenceFragmentCompatDividers.this.divPrefFlags & 0x200) == 512) {
                    left = parent.getPaddingLeft();
                    right = parent.getWidth() - parent.getPaddingRight();
                } else {
                    left = 0;
                    right = parent.getWidth();
                }
                byte[] types = new byte[]{-1, -1};
                int typePointer = 0;
                for (int i = first; i <= last; ++i) {
                    int top;
                    int viewRight;
                    int viewLeft;
                    View view = lm.findViewByPosition(i);
                    if ((PreferenceFragmentCompatDividers.this.divPrefFlags & 0x100) == 256) {
                        viewLeft = left + view.getPaddingLeft();
                        viewRight = right - view.getPaddingRight();
                    } else {
                        viewLeft = left;
                        viewRight = right;
                    }
                    if (i == first) {
                        types[typePointer] = this.getViewType(view);
                    }
                    if (i < last) {
                        View viewNext = lm.findViewByPosition(i + 1);
                        types[(typePointer + 1) % 2] = this.getViewType(viewNext);
                    } else {
                        types[(typePointer + 1) % 2] = -1;
                    }
                    int baseY = PreferenceFragmentCompatDividers.isViewCompatMessedUp() ? view.getTop() : (int)ViewCompat.getY((View)view);
                    if (i == 0 && this.hasDividerAbove(types[typePointer])) {
                        top = baseY;
                        this.divider.setBounds(viewLeft, top, viewRight, top + this.dividerHeight);
                        this.divider.draw(c);
                    }
                    if (this.hasDividerBelow(types[typePointer], types[(typePointer + 1) % 2])) {
                        top = baseY + view.getHeight() + view.getPaddingBottom() + view.getPaddingTop();
                        this.divider.setBounds(viewLeft, top, viewRight, top + this.dividerHeight);
                        this.divider.draw(c);
                    }
                    ++typePointer;
                    typePointer %= 2;
                }
            }
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            byte next;
            byte current = this.getViewType(view);
            int index = parent.indexOfChild(view);
            if (index < parent.getChildCount() - 1) {
                View viewNext = parent.getChildAt(index + 1);
                next = this.getViewType(viewNext);
            } else {
                next = -1;
            }
            if (parent.getChildAdapterPosition(view) == 0 && this.hasDividerAbove(current)) {
                outRect.top = this.dividerHeight;
            }
            if (this.hasDividerBelow(current, next)) {
                outRect.bottom = this.dividerHeight;
            }
        }

        private boolean hasDividerAbove(byte current) {
            switch (current) {
                case 0: {
                    return (PreferenceFragmentCompatDividers.this.divPrefFlags & 2) == 2;
                }
                case 1: {
                    return (PreferenceFragmentCompatDividers.this.divPrefFlags & 0x20) == 32;
                }
            }
            return false;
        }

        private boolean hasDividerBelow(byte current, byte next) {
            switch (current) {
                case 0: {
                    switch (next) {
                        case 0: {
                            return (PreferenceFragmentCompatDividers.this.divPrefFlags & 1) == 1;
                        }
                        case 1: {
                            return (PreferenceFragmentCompatDividers.this.divPrefFlags & 4) == 4 || (PreferenceFragmentCompatDividers.this.divPrefFlags & 0x20) == 32;
                        }
                    }
                    return (PreferenceFragmentCompatDividers.this.divPrefFlags & 4) == 4;
                }
                case 1: {
                    switch (next) {
                        case 1: {
                            return (PreferenceFragmentCompatDividers.this.divPrefFlags & 0x10) == 16;
                        }
                        case 0: {
                            return (PreferenceFragmentCompatDividers.this.divPrefFlags & 0x40) == 64 || (PreferenceFragmentCompatDividers.this.divPrefFlags & 2) == 2;
                        }
                    }
                    return (PreferenceFragmentCompatDividers.this.divPrefFlags & 0x40) == 64;
                }
            }
            return false;
        }

        private byte getViewType(View view) {
            return view instanceof ViewGroup ? (byte)1 : 0;
        }

        public void setDivider(Drawable divider) {
            this.dividerHeight = divider != null ? divider.getIntrinsicHeight() : 0;
            this.divider = divider;
            PreferenceFragmentCompatDividers.this.getListView().invalidateItemDecorations();
        }

        public void setDividerHeight(int dividerHeight) {
            this.dividerHeight = dividerHeight;
            PreferenceFragmentCompatDividers.this.getListView().invalidateItemDecorations();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    protected static @interface DividerPrefBase {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    protected static @interface DividerPrefFlags {
    }
}

