/*
 * Decompiled with CFR 0.152.
 */
package com.tailoredapps.androidutil.validation;

import androidx.annotation.StringRes;
import com.tailoredapps.androidutil.validation.Rule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/tailoredapps/androidutil/validation/RegexRule;", "Lcom/tailoredapps/androidutil/validation/Rule;", "", "pattern", "errorMessage", "", "(Ljava/lang/String;I)V", "getErrorMessage", "()I", "validate", "", "input", "util-validation_release"})
public class RegexRule
implements Rule<String> {
    private final String pattern;
    private final int errorMessage;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(@Nullable String input) {
        if (input == null) return false;
        String string = this.pattern;
        boolean bl = false;
        if (!new Regex(string).matches((CharSequence)input)) return false;
        return true;
    }

    @Override
    public int getErrorMessage() {
        return this.errorMessage;
    }

    public RegexRule(@NotNull String pattern, @StringRes int errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        this.errorMessage = errorMessage;
    }
}

