/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.utils;

import android.content.Context;
import com.taboola.android.utils.SharedPrefUtil;

public class GDPRUtils {
    public static final String SDK_API_FETCH_KEY_CONSENT_STRING_V1 = "consent.daisybit";
    public static final String SDK_API_FETCH_KEY_CONSENT_STRING_V2 = "consent.tcstring";
    private static final String CONSENT_STRING = "IABConsent_ConsentString";
    private static final String SUBJECT_TO_GDPR = "IABConsent_SubjectToGDPR";
    private static final String SUBJECT_TO_GDPR_VALUE_DEFAULT = "0";
    private static final String SUBJECT_TO_GDPR_VALUE_ENABLED = "1";
    private static final String CMP_PRESENT = "IABConsent_CMPPresent";
    private static final String CONSENT_STRING_V2 = "IABTCF_TCString";
    private static final String SUBJECT_TO_GDPR_V2 = "IABTCF_gdprApplies";
    private static final int SUBJECT_TO_GDPR_VALUE_DEFAULT_V2 = 0;
    private static final int SUBJECT_TO_GDPR_VALUE_ENABLED_V2 = 1;
    private static final String CMP_PRESENT_V2 = "IABTCF_CmpSdkID";
    private static final int CMP_V2_NA = -1;
    private static final String EMPTY_DEFAULT_STRING = "";

    public static String getConsentString(Context context) {
        return SharedPrefUtil.getStringFromDefaultSharedPref(context, CONSENT_STRING, EMPTY_DEFAULT_STRING);
    }

    public static String getSubjectToGdpr(Context context) {
        return SharedPrefUtil.getStringFromDefaultSharedPref(context, SUBJECT_TO_GDPR, SUBJECT_TO_GDPR_VALUE_DEFAULT);
    }

    public static boolean getCmpPresentValue(Context context) {
        return SharedPrefUtil.getBooleanFromDefaultSharedPref(context, CMP_PRESENT, false);
    }

    public static boolean isSubjectToGdpr(Context context) {
        return GDPRUtils.getSubjectToGdpr(context).equals(SUBJECT_TO_GDPR_VALUE_ENABLED);
    }

    public static String getConsentStringV2(Context context) {
        return SharedPrefUtil.getStringFromDefaultSharedPref(context, CONSENT_STRING_V2, EMPTY_DEFAULT_STRING);
    }

    public static int getSubjectToGdprV2(Context context) {
        return SharedPrefUtil.getIntFromDefaultSharedPref(context, SUBJECT_TO_GDPR_V2, 0);
    }

    public static boolean getCmpPresentValueV2(Context context) {
        return SharedPrefUtil.getIntFromDefaultSharedPref(context, CMP_PRESENT_V2, -1) != -1;
    }

    public static boolean isSubjectToGdprV2(Context context) {
        return GDPRUtils.getSubjectToGdprV2(context) == 1;
    }
}

