/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.network.handlers;

import android.os.Bundle;
import android.support.annotation.Keep;
import com.taboola.android.global_components.network.requests.kibana.GlobalExceptionKibanaReport;
import com.taboola.android.global_components.network.requests.kibana.IntegrationVerificationFailed;
import com.taboola.android.utils.network.KibanaUtils;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import org.json.JSONArray;
import org.json.JSONObject;

@Keep
public class KibanaHandler {
    private static final String KIBANA_BASE_URL = "https://vidanalytics.taboola.com/putes";
    private static final String KIBANA_FSD_BASE_URL = "https://vidanalytics.taboola.com/mput";
    private static final String KIBANA_INDEX_SUFFIX_SDK_VERIFIER = "/sdk_verifier";
    private static final String KIBANA_INDEX_SUFFIX_GUEH = "/sdk_gueh_exception";
    private static final String KIBANA_INDEX_SUFFIX_EVENT = "/mobile";
    private static final String KIBANA_INDEX_SUFFIX_FSD = "/sdk_fsd";
    private HttpManager mHttpManager;

    public void setHttpManager(HttpManager httpManager) {
        this.mHttpManager = httpManager;
    }

    public void sendVerificationFailedKibanaReport(Bundle bundle, HttpManager.NetworkResponse networkResponse) {
        String sdkVer = "2.8.3";
        String timestamp = KibanaUtils.getISO8601currentTime();
        String sdkType = bundle.getString("sdk_type");
        String testName = bundle.getString("test_name");
        boolean isMandatory = bundle.getBoolean("is_mandatory");
        String testOutput = bundle.getString("test_output");
        String publisherId = bundle.getString("publisher_id");
        String sessionId = bundle.getString("session_id");
        IntegrationVerificationFailed integrationVerificationFailed = new IntegrationVerificationFailed(sdkVer, timestamp, sdkType, testName, isMandatory, testOutput, publisherId, sessionId);
        this.mHttpManager.post("https://vidanalytics.taboola.com/putes/sdk_verifier", integrationVerificationFailed.getJsonBody(), networkResponse);
    }

    public void sendGUEHExceptionToKibana(GlobalExceptionKibanaReport globalExceptionReport, HttpManager.NetworkResponse networkResponse) {
        this.mHttpManager.post("https://vidanalytics.taboola.com/putes/sdk_gueh_exception", globalExceptionReport.getJsonBody(), networkResponse);
    }

    public void sendEvent(JSONObject event) {
        this.mHttpManager.post("https://vidanalytics.taboola.com/putes/mobile", event);
    }

    public void sendFsdEvents(JSONArray events, HttpManager.NetworkResponse networkResponse) {
        this.mHttpManager.post("https://vidanalytics.taboola.com/mput/sdk_fsd", events, networkResponse);
    }
}

