/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.fsd;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.taboola.android.Taboola;
import com.taboola.android.global_components.fsd.FSDActivity;
import com.taboola.android.global_components.fsd.FSDManager;
import com.taboola.android.utils.DeviceUtils;
import com.taboola.android.utils.Logger;
import java.lang.ref.WeakReference;
import java.util.List;

public class FSDReceiver
extends BroadcastReceiver {
    private static final String TAG = FSDReceiver.class.getSimpleName();

    public void onReceive(Context context, Intent intent) {
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        Task asyncTask = new Task(pendingResult, context);
        try {
            asyncTask.execute(new String[0]);
        }
        catch (Exception e) {
            Logger.d(TAG, "Exception in AsyncTask execution. " + e.getMessage());
        }
    }

    private static boolean isAppOnForeground(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return false;
            }
            List appProcesses = activityManager.getRunningAppProcesses();
            if (appProcesses == null) {
                return false;
            }
            String appPackageName = context.getPackageName();
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (appProcess.importance != 100 || !appProcess.processName.equals(appPackageName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    private static class Task
    extends AsyncTask<String, Integer, Boolean> {
        private BroadcastReceiver.PendingResult mPendingResult;
        private WeakReference<Context> mWeakContext;
        private FSDManager mFsdManager;
        private boolean mShowOnlyWhenScreenOff = true;
        private String mLogLevel = "A";
        private String mExceptionMessage;
        private boolean mKillSwitch = true;
        private String mErrorMessage;

        private Task(BroadcastReceiver.PendingResult pendingResult, Context context) {
            this.mPendingResult = pendingResult;
            this.mWeakContext = new WeakReference<Context>(context);
            this.mFsdManager = Taboola.getTaboolaImpl().getFsdManager();
        }

        protected Boolean doInBackground(String ... strings) {
            boolean shouldRunFsd = false;
            Context context = (Context)this.mWeakContext.get();
            try {
                if (this.mFsdManager == null) {
                    return false;
                }
                this.mShowOnlyWhenScreenOff = this.mFsdManager.getScreenOff(this.mShowOnlyWhenScreenOff);
                this.mLogLevel = this.mFsdManager.getLogLevel(this.mLogLevel);
                this.mKillSwitch = this.mFsdManager.getKillSwitch(this.mKillSwitch);
                Logger.d(TAG, "onHandleWork: mShowOnlyWhenScreenOff =" + this.mShowOnlyWhenScreenOff);
                if (!(context == null || this.mShowOnlyWhenScreenOff && DeviceUtils.getScreenState(context) != 0)) {
                    shouldRunFsd = true;
                } else {
                    this.mErrorMessage = "fsd_err_so";
                }
                if (!FSDManager.isDeviceConnectedToNetwork()) {
                    this.mErrorMessage = "fsd_err_network";
                    shouldRunFsd = false;
                }
                return shouldRunFsd;
            }
            catch (Exception e) {
                Logger.d(TAG, "doInBackground: " + e.getMessage());
                this.mExceptionMessage = e.getMessage();
                return false;
            }
        }

        protected void onPostExecute(Boolean shouldRunFsd) {
            super.onPostExecute((Object)shouldRunFsd);
            try {
                if (this.mFsdManager == null) {
                    Logger.d(TAG, "onPostExecutre :: FSDManger is null.");
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)this.mExceptionMessage)) {
                    this.mFsdManager.markAsFailedWithStats(this.mLogLevel, "fsd_err_async: " + this.mExceptionMessage);
                } else if (!shouldRunFsd.booleanValue()) {
                    if (TextUtils.isEmpty((CharSequence)this.mErrorMessage)) {
                        this.mErrorMessage = "fsd_err_def";
                    }
                    this.mFsdManager.markAsFailedWithStats(this.mLogLevel, this.mErrorMessage);
                } else {
                    Context context = null;
                    if (this.mWeakContext != null) {
                        context = (Context)this.mWeakContext.get();
                    }
                    if (context != null && !this.mKillSwitch) {
                        Task.launchFSDActivity(context, FSDReceiver.isAppOnForeground(context));
                    } else {
                        this.mFsdManager.markAsFailedWithStats(this.mLogLevel, "fsd_err_ks");
                    }
                }
            }
            catch (Exception e) {
                Logger.e(TAG, e.getMessage(), e);
            }
            finally {
                this.mWeakContext = null;
                if (this.mPendingResult != null) {
                    try {
                        this.mPendingResult.finish();
                        this.mPendingResult = null;
                    }
                    catch (Exception e) {
                        Logger.d(TAG, "PendingResult error: " + e.getMessage());
                    }
                }
            }
        }

        private static void launchFSDActivity(Context context, boolean isAppInForeground) {
            if (context == null) {
                return;
            }
            try {
                Intent fsdActivityIntent = new Intent();
                fsdActivityIntent.setComponent(new ComponentName(context.getPackageName(), FSDActivity.class.getName()));
                fsdActivityIntent.addFlags(0x800000);
                fsdActivityIntent.addFlags(0x10000000);
                fsdActivityIntent.putExtra("foreground", isAppInForeground);
                context.startActivity(fsdActivityIntent);
            }
            catch (Exception e) {
                Logger.d(TAG, e.getMessage());
            }
        }
    }
}

