/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.fsd;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taboola.android.Taboola;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.configuration.ConfigManager;
import com.taboola.android.global_components.fsd.FSDCloseActivityRunnable;
import com.taboola.android.global_components.fsd.FSDScheduler;
import com.taboola.android.global_components.network.NetworkManager;
import com.taboola.android.global_components.network.handlers.KibanaHandler;
import com.taboola.android.utils.JSONUtils;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MapUtils;
import com.taboola.android.utils.OnClickHelper;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.SharedPrefUtil;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class FSDManager {
    public static final String CONFIG_KEY = "fsdConfig";
    private static final String KILL_SWITCH_KEY = "ks";
    private static final String LOG_LEVEL_KEY = "ll";
    private static final String SHOULD_SEND_EVENTS_KEY = "se";
    private static final String SHOW_ONLY_WHEN_SCREEN_OFF_KEY = "so";
    private static final String SHOULD_LEAVE_OPEN_KEY = "lo";
    private static final String BASE_URL_KEY = "burl";
    private static final String REDIRECT_URL_KEY = "rurl";
    private static final String GAID_PARAM_KEY = "gaparam";
    private static final String FIRST_LOAD_TIME_KEY = "lt";
    private static final String NEXT_SCHEDULE_TIME_AFTER_FAIL_KEY = "na";
    private static final String NEXT_SCHEDULE_TIME_AFTER_SUCCESS_KEY = "nas";
    private static final String NUMBER_OF_RETRIES_KEY = "nr";
    private static final String RETRIES_INTERVAL_KEY = "ri";
    private static final String MAX_TIMEOUT_KEY = "mt";
    private static final String IS_DEBUG_MODE_KEY = "tbdbg";
    private static final String RESET_SCHEDULER_KEY = "resetssp";
    private static final String PERCENTAGE_ALLOWED_FOR_STATISTICS = "ps";
    private static final String TAG = FSDManager.class.getSimpleName();
    private static final String CHROME_PACKAGE = "com.android.chrome";
    private static final String STATS_SEPARATOR = "|";
    private static final String FSD_ALIAS_ACTIVITY = ".FSDAliasActivity";
    public static final boolean KILL_SWITCH_DEF_VALUE = true;
    private final NetworkManager mNetworkManager;
    private final Context mApplicationContext = TaboolaContextManager.getInstance().getApplicationContext();
    private FSDScheduler mFsdScheduler;
    private KibanaHandler mKibanaHandler;
    private boolean mShouldSendEvents;
    private String mLogLevel = "A";
    private Map<String, String> mConfigurationMap;

    public FSDManager(NetworkManager networkManager) {
        this.mNetworkManager = networkManager;
        ConfigManager configManager = Taboola.getTaboolaImpl().loadAndGetConfigManager();
        this.mConfigurationMap = JSONUtils.convertJsonToMap(configManager.getConfigValue(CONFIG_KEY, null));
        this.mLogLevel = this.getLogLevel(this.mLogLevel);
        this.mShouldSendEvents = this.getShouldSendEvents(true);
        this.setDebugLogLevel(this.mLogLevel);
    }

    public void init() {
        try {
            if (this.mFsdScheduler == null) {
                this.mFsdScheduler = new FSDScheduler();
            }
            this.checkIfSchedulerNeedsReset();
            if (this.getKillSwitch(true)) {
                Logger.d(TAG, "FSD Kill switch is active.");
                if (this.mApplicationContext != null) {
                    FSDScheduler.cancelScheduler(this.mApplicationContext);
                }
                return;
            }
            this.mFsdScheduler.schedule(TaboolaContextManager.getInstance().getApplicationContext());
        }
        catch (Exception e) {
            Logger.e(TAG, "FSDManager: " + e.getMessage(), e);
        }
    }

    private void checkIfSchedulerNeedsReset() {
        String resetValueFromConfig = MapUtils.getValueOrDefault(this.mConfigurationMap, RESET_SCHEDULER_KEY, null);
        if (this.shouldResetSharedPref(resetValueFromConfig)) {
            this.resetFsdSchedulerSharedPrefKeys(this.mApplicationContext);
            SharedPrefUtil.setFsdResetValue(this.mApplicationContext, resetValueFromConfig);
        }
    }

    private void setDebugLogLevel(String logLevel) {
        if (logLevel.equals("B")) {
            Logger.setLogLevel(3);
        } else {
            this.mLogLevel = "A";
        }
    }

    void markAsSuccessWithStats(String logLevel) {
        long timestamp = System.currentTimeMillis();
        SharedPrefUtil.setFsdSuccess(this.mApplicationContext, timestamp);
        SharedPrefUtil.setFsdRetry(this.mApplicationContext, 0);
        this.addStats(logLevel, timestamp, "fsd_success", new String[0]);
        this.reschedule();
    }

    void markAsFailedWithStats(String logLevel, String event) {
        long timestamp = System.currentTimeMillis();
        SharedPrefUtil.setFsdFail(this.mApplicationContext, timestamp);
        int fsdRetries = SharedPrefUtil.getFsdRetries(this.mApplicationContext, 0);
        SharedPrefUtil.setFsdRetry(this.mApplicationContext, fsdRetries + 1);
        this.addStats(logLevel, timestamp, event, new String[0]);
        this.reschedule();
    }

    private void reschedule() {
        if (this.mFsdScheduler == null) {
            this.mFsdScheduler = new FSDScheduler();
        }
        this.mFsdScheduler.schedule(this.mApplicationContext);
    }

    void addStats(long timestamp, String event, String ... isAnalyticsEnabled) {
        this.setDebugLogLevel(this.mLogLevel);
        this.addStats(this.mLogLevel, timestamp, event, isAnalyticsEnabled);
    }

    void addStats(String logLevel, long timestamp, String event, String ... isAnalyticsEnabled) {
        try {
            if (logLevel.equals("B") || SharedPrefUtil.getFsdStatsEnabled(this.mApplicationContext, false)) {
                SimpleDateFormat defaultSdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
                defaultSdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                String formattedDate = defaultSdf.format(new Date(timestamp));
                StringBuilder statsBuilder = new StringBuilder();
                statsBuilder.append(formattedDate).append(STATS_SEPARATOR).append(event);
                if (isAnalyticsEnabled != null && isAnalyticsEnabled.length > 0) {
                    statsBuilder.append(STATS_SEPARATOR).append(isAnalyticsEnabled[0]);
                }
                Logger.d(TAG, "addStats: " + statsBuilder.toString());
                this.saveToPersist(statsBuilder.toString());
            } else {
                Logger.d(TAG, "addStats: Not adding stats for this user.");
            }
        }
        catch (Exception e) {
            Logger.d(TAG, e.getMessage());
        }
    }

    private void saveToPersist(String stats) {
        SharedPrefUtil.addFsdStatsKibana(this.mApplicationContext, stats);
    }

    private JSONObject createJsonEntry(String timestamp, String event, Context context) {
        try {
            return this.createJsonEntry(timestamp, event, context, null);
        }
        catch (Exception e) {
            Logger.e(TAG, "createJsonEntry: " + e.getMessage(), e);
            return null;
        }
    }

    private JSONObject createJsonEntry(String timestamp, String event, Context context, String isAnalyticsAllowed) {
        try {
            AdvertisingIdInfo advertistingIdInfo = Taboola.getTaboolaImpl().getAdvertisingIdInfo();
            PackageInfo packageInfo = SdkDetailsHelper.getPackageInfo(context);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("app", (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getApplicationName(context)));
            jsonObject.put("appid", (Object)packageInfo.packageName);
            jsonObject.put("appv", (Object)packageInfo.versionName);
            jsonObject.put("event", (Object)event);
            jsonObject.put("model", (Object)TextUtils.htmlEncode((String)SdkDetailsHelper.getDeviceName()));
            jsonObject.put("os", (Object)"Android");
            jsonObject.put("osv", (Object)Build.VERSION.RELEASE);
            jsonObject.put("PublisherId", (Object)SharedPrefUtil.getConfigPublisherId(context));
            jsonObject.put("sdk_version", (Object)"2.8.3");
            jsonObject.put("timestamp", (Object)timestamp);
            if (!advertistingIdInfo.isLimitedAdTrackingEnabled()) {
                jsonObject.put("device_id", (Object)advertistingIdInfo.getAdvertisingId());
            }
            if (!TextUtils.isEmpty((CharSequence)isAnalyticsAllowed)) {
                jsonObject.put("analytics", (Object)isAnalyticsAllowed);
            }
            return jsonObject;
        }
        catch (Exception e) {
            Logger.e(TAG, "Unable to write log", e);
            return null;
        }
    }

    public String getCustomTabPackageName(Context context) {
        String defaultBrowserPackageName = "";
        try {
            PackageManager pm = context.getPackageManager();
            Intent activityIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
            ResolveInfo defaultBrowserResolveInfo = pm.resolveActivity(activityIntent, 0);
            if (defaultBrowserResolveInfo != null) {
                defaultBrowserPackageName = defaultBrowserResolveInfo.activityInfo.packageName;
                Logger.d(TAG, "getCustomTabPackageName: default browser = " + (defaultBrowserPackageName == null ? "N/A" : defaultBrowserPackageName));
                if (defaultBrowserPackageName.equals(CHROME_PACKAGE)) {
                    return CHROME_PACKAGE;
                }
                return "";
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "getCustomTabPackageName() | " + e.getMessage(), e);
        }
        return defaultBrowserPackageName;
    }

    void createAndSendFirstTimeLog(Calendar scheduleTime) {
        try {
            SimpleDateFormat defaultSdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
            defaultSdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String formattedDate = defaultSdf.format(new Date(scheduleTime.getTimeInMillis()));
            String event = "fsd_ft";
            String isAnalyticsAllowed = String.valueOf(SharedPrefUtil.getFsdStatsEnabled(this.mApplicationContext, false));
            SharedPrefUtil.addFsdStatsKibana(this.mApplicationContext, formattedDate + STATS_SEPARATOR + event + STATS_SEPARATOR + isAnalyticsAllowed);
            this.sendFsdStatsToKibana();
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage(), e);
        }
    }

    void sendFsdStatsToKibana() {
        if (this.mShouldSendEvents) {
            Logger.d(TAG, "about to send FSD stats ");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (FSDManager.this.mApplicationContext == null) {
                        return;
                    }
                    try {
                        Set<String> fsdStatsKibanaFromSharedPref = SharedPrefUtil.getFsdStatsKibana(FSDManager.this.mApplicationContext, null);
                        if (fsdStatsKibanaFromSharedPref != null && !fsdStatsKibanaFromSharedPref.isEmpty()) {
                            JSONArray kibanaStatsAsJsonArray = FSDManager.this.createJsonArrayItemToSend(fsdStatsKibanaFromSharedPref);
                            FSDManager.this.sendJsonArrayToKibana(kibanaStatsAsJsonArray);
                        }
                    }
                    catch (Exception e) {
                        Logger.e(TAG, "SendFsdStats: " + e.getMessage(), e);
                    }
                }
            }).start();
        } else {
            Logger.d(TAG, "sendFsdStatsToKibana: not allowed to send events.");
        }
    }

    private JSONArray createJsonArrayItemToSend(Set<String> fsdStats) {
        if (fsdStats == null) {
            return new JSONArray();
        }
        try {
            ArrayList<JSONObject> jsonStats = new ArrayList<JSONObject>();
            block6: for (String stat : fsdStats) {
                String[] splitStat = stat.split("\\|");
                switch (splitStat.length) {
                    case 2: {
                        jsonStats.add(this.createJsonEntry(splitStat[0], splitStat[1], this.mApplicationContext));
                        continue block6;
                    }
                    case 3: {
                        jsonStats.add(this.createJsonEntry(splitStat[0], splitStat[1], this.mApplicationContext, splitStat[2]));
                        continue block6;
                    }
                }
                Logger.e(TAG, "createJsonItemsToSend: error splitting: " + stat);
            }
            return new JSONArray(jsonStats);
        }
        catch (Exception e) {
            Logger.e(TAG, e.getMessage(), e);
            return new JSONArray();
        }
    }

    private void sendJsonArrayToKibana(final JSONArray data) {
        AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Logger.d(TAG, "sendJsonArrayToKibana: " + data.toString());
                FSDManager.this.mKibanaHandler = FSDManager.this.mNetworkManager.getKibanaHandler();
                FSDManager.this.mKibanaHandler.sendFsdEvents(data, new HttpManager.NetworkResponse(){

                    @Override
                    public void onResponse(HttpResponse response) {
                        try {
                            if (response.mMessage.contains("error bad json")) {
                                Logger.d(TAG, "Failed to send stats to Kibana");
                            } else {
                                SharedPrefUtil.overrideFsdStatsKibana(TaboolaContextManager.getInstance().getApplicationContext(), new HashSet<String>(0));
                            }
                        }
                        catch (Exception e) {
                            Logger.e(TAG, e.getMessage(), e);
                        }
                    }

                    @Override
                    public void onError(HttpError error) {
                        Logger.e(TAG, "Failed to send stats to Kibana: " + (TextUtils.isEmpty((CharSequence)error.mMessage) ? "" : error.mMessage));
                    }
                });
            }
        });
    }

    void closeCCTabActivity(Context context, boolean shouldLeaveOpen) {
        if (context == null || shouldLeaveOpen) {
            Logger.d(TAG, "should not close FSD activity.");
            return;
        }
        FSDCloseActivityRunnable runnable = new FSDCloseActivityRunnable(context, shouldLeaveOpen);
        new Handler(Looper.getMainLooper()).post((Runnable)runnable);
    }

    boolean getScreenOff(boolean defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, SHOW_ONLY_WHEN_SCREEN_OFF_KEY, defValue);
    }

    boolean getKillSwitch(boolean defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, KILL_SWITCH_KEY, defValue);
    }

    boolean getShouldSendEvents(boolean defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, SHOULD_SEND_EVENTS_KEY, defValue);
    }

    String getLogLevel(String defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, LOG_LEVEL_KEY, defValue);
    }

    boolean getShouldLeaveOpen(boolean defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, SHOULD_LEAVE_OPEN_KEY, defValue);
    }

    String getBaseUrl(String defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, BASE_URL_KEY, defValue);
    }

    String getRedirUrl(String defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, REDIRECT_URL_KEY, defValue);
    }

    int getMaxTimeoutInMilliseconds(int defValue) {
        return Math.max(MapUtils.getValueOrDefault(this.mConfigurationMap, MAX_TIMEOUT_KEY, defValue), defValue);
    }

    String getGaidParam(String defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, GAID_PARAM_KEY, defValue);
    }

    int getFirstScheduleTimeInHours(int defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, FIRST_LOAD_TIME_KEY, defValue);
    }

    int getNextScheduleTimeAfterSuccessInDays(int defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, NEXT_SCHEDULE_TIME_AFTER_SUCCESS_KEY, defValue);
    }

    int getNextScheduleTimeAfterFailInDays(int defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, NEXT_SCHEDULE_TIME_AFTER_FAIL_KEY, defValue);
    }

    int getNumberOfRetries(int defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, NUMBER_OF_RETRIES_KEY, defValue);
    }

    int getRetriesIntervalTimeInHours(int defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, RETRIES_INTERVAL_KEY, defValue);
    }

    int getAllowedPercentageForStatistics(int defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, PERCENTAGE_ALLOWED_FOR_STATISTICS, defValue);
    }

    boolean getIsInDebugMode(boolean defValue) {
        return MapUtils.getValueOrDefault(this.mConfigurationMap, IS_DEBUG_MODE_KEY, defValue);
    }

    public static boolean shouldAllowInit(Context context, @NonNull ConfigManager configManager) {
        configManager.loadConfig();
        HashMap<String, String> configAsMap = JSONUtils.convertJsonToMap(configManager.getConfigValue(CONFIG_KEY, null));
        boolean isKillSwitchEnabled = MapUtils.getValueOrDefault(configAsMap, KILL_SWITCH_KEY, true);
        if (isKillSwitchEnabled) {
            FSDScheduler.cancelScheduler(context);
            return false;
        }
        if (context == null || Build.VERSION.SDK_INT >= 29) {
            return false;
        }
        if (!OnClickHelper.areChromeCustomTabsSupported(context)) {
            return false;
        }
        if (SharedPrefUtil.getIsFSdActive(context, false)) {
            return true;
        }
        long fsdLastCheckTimestamp = SharedPrefUtil.getFsdCheckTimestamp(context, -1L);
        if (fsdLastCheckTimestamp == -1L || FSDManager.isFsdLastCheckTimeNeedsUpdate(fsdLastCheckTimestamp)) {
            try {
                String packageNameOfActivityWithDeepLink = FSDManager.getPackageNameOfActivityWithDeepLink(context);
                if (TextUtils.isEmpty((CharSequence)packageNameOfActivityWithDeepLink) || SdkDetailsHelper.getPackageInfo((Context)context).packageName.equals(packageNameOfActivityWithDeepLink)) {
                    FSDManager.enableFsdDeeplinkInManifest(context);
                    SharedPrefUtil.setIsFSdActive(context, true);
                    return true;
                }
                SharedPrefUtil.setFsdCheckTimestamp(context, System.currentTimeMillis());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Nullable
    private static String getPackageNameOfActivityWithDeepLink(Context context) throws Exception {
        if (context == null) {
            Logger.d(TAG, "context is null");
            throw new Exception("Context is null");
        }
        try {
            Uri uri = Uri.parse((String)"tblfsd://fsd");
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            PackageManager packageManager = context.getPackageManager();
            List activities = packageManager.queryIntentActivities(intent, 0);
            if (activities != null && activities.size() == 1) {
                return ((ResolveInfo)activities.get((int)0)).activityInfo.packageName;
            }
            return null;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private static void enableFsdDeeplinkInManifest(Context context) throws Exception {
        try {
            PackageManager pm = context.getPackageManager();
            ComponentName compName = new ComponentName(context.getPackageName(), "com.taboola.android.FSDAliasActivity");
            pm.setComponentEnabledSetting(compName, 1, 1);
        }
        catch (Exception e) {
            Logger.d(TAG, e.getMessage());
            throw new Exception(e);
        }
    }

    private static boolean isFsdLastCheckTimeNeedsUpdate(long fsdTimestamp) {
        Calendar currentTime = Calendar.getInstance();
        Calendar savedTime = Calendar.getInstance();
        savedTime.setTimeInMillis(fsdTimestamp);
        savedTime.add(2, 1);
        return currentTime.getTimeInMillis() >= savedTime.getTimeInMillis();
    }

    private boolean shouldResetSharedPref(@Nullable String resetValueFromConfig) {
        if (resetValueFromConfig == null) {
            return false;
        }
        String fsdResetValue = SharedPrefUtil.getFsdResetValue(TaboolaContextManager.getInstance().getApplicationContext(), "");
        return !resetValueFromConfig.equals(fsdResetValue);
    }

    private void resetFsdSchedulerSharedPrefKeys(Context context) {
        SharedPrefUtil.setFsdNext(context, 0L);
        SharedPrefUtil.setFsdFail(context, 0L);
        SharedPrefUtil.setFsdSuccess(context, 0L);
    }

    static boolean isDeviceConnectedToNetwork() {
        try {
            return Taboola.getTaboolaImpl().getNetworkManager().getState().isConnected();
        }
        catch (Exception e) {
            Logger.d(TAG, "Unable to get connectivity info. " + e.getMessage());
            return false;
        }
    }
}

