/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.global_components.advertisingid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.global_components.TaboolaContextManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.SharedPrefUtil;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class AdvertisingIdInfo {
    private static final String TAG = AdvertisingIdInfo.class.getSimpleName();
    private String mAdvertisingId;
    private boolean mIsLimitedAdTrackingEnabled;

    public AdvertisingIdInfo(Context context) {
        this.init(context);
    }

    private void init(Context context) {
        Log.d((String)TAG, (String)"init called");
        this.mAdvertisingId = this.getCachedAdvertisingId(context);
        this.updateAdvertisingIdAsync(context);
    }

    private String getCachedAdvertisingId(Context context) {
        if (context == null) {
            Logger.e(TAG, "getCachedAdvertisingId, context is null ", new Exception());
            return "";
        }
        return SharedPrefUtil.getCachedAdvertisingId(context);
    }

    public String getAdvertisingId() {
        if (TextUtils.isEmpty((CharSequence)this.mAdvertisingId)) {
            Logger.d(TAG, "getAdvertisingId: " + this.getCachedAdvertisingId(TaboolaContextManager.getInstance().getApplicationContext()));
            return this.getCachedAdvertisingId(TaboolaContextManager.getInstance().getApplicationContext());
        }
        Logger.d(TAG, "getAdvertisingId: " + this.mAdvertisingId);
        return this.mAdvertisingId;
    }

    public boolean isLimitedAdTrackingEnabled() {
        return this.mIsLimitedAdTrackingEnabled;
    }

    public void updateAdvertisingIdAsync(Context context) {
        this.updateAdvertisingIdAsync(context, null);
    }

    public void updateAdvertisingIdAsync(final Context context, final @Nullable AdvertisingIdCallback callback) {
        Logger.d(TAG, "updateAdvertisingIdAsync :: called");
        new Thread(new Runnable(){

            @Override
            public void run() {
                Handler mainHandler = new Handler(context.getMainLooper());
                try {
                    AdInfo adInfo = AdvertisingIdInfo.getAdvertisingIdInfo(context);
                    final String advertisingId = adInfo.getId();
                    Logger.d(TAG, "updateAdvertisingIdAsync :: advertisingId = " + advertisingId);
                    AdvertisingIdInfo.this.mAdvertisingId = advertisingId;
                    AdvertisingIdInfo.this.mIsLimitedAdTrackingEnabled = adInfo.isLimitAdTrackingEnabled();
                    SharedPrefUtil.setCachedAdvertisingId(context, advertisingId);
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onIdRetrieved(advertisingId);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Logger.d(TAG, "updateAdvertisingIdAsync :: failed");
                    Logger.e(TAG, "updateAdvertisingIdAsync :: failed", e);
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onIdUnavailable();
                            }
                        }
                    });
                }
            }
        }).start();
    }

    private static AdInfo getAdvertisingIdInfo(Context context) throws Exception {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot be called from the main thread");
        }
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.android.vending", 0);
        }
        catch (Exception e) {
            Logger.e(TAG, "Failed to get AdvertisingIdInfo", e);
            throw e;
        }
        AdvertisingConnection connection = new AdvertisingConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        if (context.bindService(intent, (ServiceConnection)connection, 1)) {
            try {
                AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                AdInfo adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
                return adInfo;
            }
            catch (Exception exception) {
                Logger.e(TAG, "Failed ot get AdvertisingIdInfo", exception);
                throw exception;
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        Logger.e(TAG, "bindService fail");
        throw new IOException("Google Play connection failed");
    }

    @Keep
    public static interface AdvertisingIdCallback {
        public void onIdRetrieved(String var1);

        public void onIdUnavailable();
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        AdvertisingInterface(IBinder pBinder) {
            this.binder = pBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() throws Exception {
            String id;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                id = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
            boolean limitAdTracking;
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(paramBoolean ? 1 : 0);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                limitAdTracking = 0 != reply.readInt();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return limitAdTracking;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.queue.put(service);
            }
            catch (InterruptedException localInterruptedException) {
                Logger.e(TAG, "AdvertisingConnection | OnServiceConnected ", localInterruptedException);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        IBinder getBinder() throws InterruptedException {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.queue.take();
        }
    }

    public static final class AdInfo {
        private final String advertisingId;
        private final boolean limitAdTrackingEnabled;

        AdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
            this.advertisingId = advertisingId;
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.advertisingId;
        }

        boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }
    }
}

