/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.content;

import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.common.PlacementSharedUtil;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.notifications.scheduled.NotificationContentState;
import com.taboola.android.plus.notifications.scheduled.NotificationItem;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.TBContent;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.plus.notifications.scheduled.content.NotificationRemoteRepository;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationUtil;
import com.taboola.android.utils.UrlUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class NotificationContentRepository {
    private static final String TAG = NotificationContentRepository.class.getSimpleName();
    private final NotificationRemoteRepository remoteRepository;
    private final TBScheduledNotificationAnalyticsManager scheduledAnalyticsManager;
    private final ScheduledNotificationsLocalStorage scheduledLocalStorage;
    private final SharedLocalStorage sharedLocalStorage;
    private final Executor mainThreadExecutor;
    private final Executor diskIOExecutor;

    public NotificationContentRepository(@NonNull NotificationRemoteRepository remoteRepository, @NonNull TBScheduledNotificationAnalyticsManager scheduledAnalyticsManager, @NonNull ScheduledNotificationsLocalStorage scheduledLocalStorage, @NonNull SharedLocalStorage sharedLocalStorage, @NonNull Executor mainThreadExecutor, @NonNull Executor diskIOExecutor) {
        this.remoteRepository = remoteRepository;
        this.scheduledAnalyticsManager = scheduledAnalyticsManager;
        this.scheduledLocalStorage = scheduledLocalStorage;
        this.sharedLocalStorage = sharedLocalStorage;
        this.mainThreadExecutor = mainThreadExecutor;
        this.diskIOExecutor = diskIOExecutor;
    }

    public void loadNewContent(final @NonNull ScheduledNotificationsConfig scheduledNotificationsConfig, @NonNull List<String> contentCategories, final @NonNull NotificationContentRefreshCallback callback) {
        String readMorePlacementName = null;
        if (scheduledNotificationsConfig.getReadMoreItem().getReadMoreFeatureEnabled().booleanValue()) {
            readMorePlacementName = scheduledNotificationsConfig.getReadMoreItem().getPlacementName();
        }
        this.remoteRepository.getNotificationContent(scheduledNotificationsConfig.getNotificationContent(), contentCategories, readMorePlacementName, this.sharedLocalStorage.getUserUnifiedId(), new NotificationRemoteRepository.OnNotificationContentFetchedCallback(){

            @Override
            public void onNotificationContentFetched(@NonNull TBContent notificationData) {
                NotificationContentRepository.this.scheduledLocalStorage.setRefreshedTimestamp(System.currentTimeMillis());
                if (!TaboolaApi.getInstance().isInitialized()) {
                    String info = "TBNotificationRepository: loadNewContent: getNotificationContent(): onNotificationContentFetched()";
                    NotificationContentRepository.this.scheduledAnalyticsManager.sendTaboolaApiNotInitializedEvent(info);
                }
                int hotItemsCount = scheduledNotificationsConfig.getScheduledNotificationsLayout().getContentNotificationLayout().getSingleItemNotificationsLayout().getTrendingNotificationsLayout().getHotItemsCount();
                List<Integer> hotItemIds = ScheduledNotificationUtil.generateHotItemIdsList(notificationData.getContentSize(), hotItemsCount);
                for (Integer hotItemId : hotItemIds) {
                    notificationData.getItems().get(hotItemId).setIsHotItem(true);
                }
                NotificationContentRepository.this.setNotificationContent(notificationData);
                NotificationContentRepository.this.scheduledAnalyticsManager.sendContentRefreshSuccessfulEvent(notificationData.getContentSize());
                callback.onContentRefreshSuccessful(notificationData);
            }

            @Override
            public void onNotificationContentFailed(Throwable throwable) {
                NotificationContentRepository.this.scheduledAnalyticsManager.sendContentRefreshFailedEvent(throwable);
                callback.onContentRefreshFailed(throwable);
            }
        });
    }

    @AnyThread
    public void deletePlacement(final @NonNull String imageUriToDelete, final OnDeletePlacementCallback callback) {
        this.diskIOExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final TBContent tbContent = NotificationContentRepository.this.scheduledLocalStorage.getContent();
                final NotificationContentState contentState = NotificationContentRepository.this.scheduledLocalStorage.getNotificationContentState();
                String zeroSizeUrlToDelete = UrlUtils.replaceImageSizeInUrl((String)imageUriToDelete, (int)0, (int)0);
                if (tbContent != null && !tbContent.getItems().isEmpty()) {
                    ArrayList<NotificationItem> notificationItems = tbContent.getItems();
                    Iterator<NotificationItem> itemIterator = notificationItems.iterator();
                    while (itemIterator.hasNext()) {
                        TBRecommendationItem item;
                        String zeroSizeImageUri;
                        NotificationItem notificationItem = itemIterator.next();
                        if (notificationItem.getPlacement().getItems().get(0) == null || !zeroSizeUrlToDelete.equals(zeroSizeImageUri = PlacementSharedUtil.getItemThumbnailUrlWithSizes(item = (TBRecommendationItem)notificationItem.getPlacement().getItems().get(0), 0, 0))) continue;
                        itemIterator.remove();
                        NotificationContentRepository.this.setNotificationContent(tbContent);
                        Log.d((String)TAG, (String)"deletePlacement by imageUri: found and deleted item");
                        NotificationContentRepository.this.mainThreadExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (contentState != null) {
                                    callback.onDeleted(tbContent, contentState);
                                }
                            }
                        });
                        return;
                    }
                    Log.d((String)TAG, (String)"deletePlacement by imageUri: deletion failed: didn't find an item (it's possible that item was already deleted by a different thumbnail fail)");
                }
            }
        });
    }

    @AnyThread
    public void deletePlacement(final TBPlacement placementToDelete, final OnDeletePlacementCallback callback) {
        this.diskIOExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final TBContent tbContent = NotificationContentRepository.this.scheduledLocalStorage.getContent();
                final NotificationContentState contentState = NotificationContentRepository.this.scheduledLocalStorage.getNotificationContentState();
                if (tbContent != null && !tbContent.getItems().isEmpty()) {
                    Iterator<NotificationItem> itemIterator = tbContent.getItems().iterator();
                    while (itemIterator.hasNext()) {
                        NotificationItem notificationItem = itemIterator.next();
                        TBPlacement tbPlacement = notificationItem.getPlacement();
                        if (!NotificationContentRepository.this.arePlacementsEqual(placementToDelete, tbPlacement)) continue;
                        itemIterator.remove();
                        NotificationContentRepository.this.setNotificationContent(tbContent);
                        NotificationContentRepository.this.mainThreadExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (contentState != null) {
                                    callback.onDeleted(tbContent, contentState);
                                }
                            }
                        });
                        return;
                    }
                    Log.w((String)TAG, (String)"deletePlacement by item id : deletion failed: didn't find an item");
                } else {
                    Log.w((String)TAG, (String)"deletePlacement by item id : deletion failed: didn't find an item");
                }
            }
        });
    }

    private boolean arePlacementsEqual(TBPlacement placement1, TBPlacement placement2) {
        String firstId = (String)((TBRecommendationItem)placement1.getItems().get(0)).getExtraDataMap().get("id");
        String secondId = (String)((TBRecommendationItem)placement2.getItems().get(0)).getExtraDataMap().get("id");
        return TextUtils.equals((CharSequence)firstId, (CharSequence)secondId);
    }

    @AnyThread
    public void fetchCurrentData(final FetchCurrentDataCallback callback) {
        this.diskIOExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final TBContent content = NotificationContentRepository.this.scheduledLocalStorage.getContent();
                final NotificationContentState notificationContentState = NotificationContentRepository.this.scheduledLocalStorage.getNotificationContentState();
                NotificationContentRepository.this.mainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFetched(content, notificationContentState);
                    }
                });
            }
        });
    }

    @AnyThread
    public void setNotificationState(final @Nullable NotificationContentState notificationContentState) {
        this.diskIOExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NotificationContentRepository.this.scheduledLocalStorage.setNotificationContentState(notificationContentState);
            }
        });
    }

    @AnyThread
    private void setNotificationContent(final @Nullable TBContent content) {
        this.diskIOExecutor.execute(new Runnable(){

            @Override
            public void run() {
                NotificationContentRepository.this.scheduledLocalStorage.setContent(content);
            }
        });
    }

    public static interface NotificationContentRefreshCallback {
        public void onContentRefreshSuccessful(@NonNull TBContent var1);

        public void onContentRefreshFailed(@NonNull Throwable var1);
    }

    public static interface OnDeletePlacementCallback {
        public void onDeleted(@NonNull TBContent var1, @NonNull NotificationContentState var2);
    }

    public static interface FetchCurrentDataCallback {
        public void onFetched(@Nullable TBContent var1, @Nullable NotificationContentState var2);
    }
}

