/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.widget.job;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.home.screen.widget.IWidgetManager;
import com.taboola.android.plus.home.screen.widget.TBHomeScreenWidget;
import com.taboola.android.plus.home.screen.widget.WidgetBridgeInternal;
import com.taboola.android.plus.home.screen.widget.WidgetConfig;
import com.taboola.android.plus.home.screen.widget.WidgetLocalStorage;

@RequiresApi(api=21)
public class WidgetRefreshJob
extends JobService {
    private static final String TAG = WidgetRefreshJob.class.getSimpleName();
    private static final int JOB_ID = 75681145;
    private static final long DEFAULT_REFRESH_INTERVAL_MS = 900000L;

    public static void scheduleWidgetUpdate(Context context, long refreshIntervalMs) {
        Log.d((String)TAG, (String)"scheduleWidgetUpdate: scheduled periodic widget update");
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            ComponentName componentName = new ComponentName(context, WidgetRefreshJob.class);
            long actualRefreshInterval = Math.max(refreshIntervalMs, 900000L);
            JobInfo.Builder builder = new JobInfo.Builder(75681145, componentName).setPeriodic(actualRefreshInterval).setPersisted(true);
            jobScheduler.schedule(builder.build());
        } else {
            Log.e((String)TAG, (String)"scheduleWidgetUpdate: cannot schedule widget periodic refresh");
        }
    }

    public static boolean isJobRunning(@NonNull Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        boolean hasBeenScheduled = false;
        if (jobScheduler != null) {
            for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
                if (jobInfo.getId() != 75681145) continue;
                hasBeenScheduled = true;
                break;
            }
        }
        return hasBeenScheduled;
    }

    public static void cancelScheduledJob(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(75681145);
            Log.v((String)TAG, (String)"Canceling periodic refresh");
        }
    }

    public boolean onStartJob(final JobParameters params) {
        Log.e((String)TAG, (String)"onStartJob: ");
        WidgetBridgeInternal.getWidgetManagerAsync(new IWidgetManager.WidgetManagerInternalCallback(){

            @Override
            public void onManagerRetrieved(IWidgetManager manager) {
                WidgetConfig widgetConfig = manager.widgetConfig();
                WidgetLocalStorage widgetLocalStorage = manager.getWidgetLocalStorage();
                boolean didRefreshIntervalPass = WidgetRefreshJob.this.didIntervalPass(widgetLocalStorage.getLastWidgetRefreshTimestamp(), widgetConfig.getWidgetRefreshIntervalMs(), System.currentTimeMillis());
                boolean isWidgetInstanceExist = manager.isWidgetInstanceExist();
                if (isWidgetInstanceExist) {
                    if (didRefreshIntervalPass) {
                        Log.d((String)TAG, (String)"onStartJob: send refresh widget broadcast");
                        TBHomeScreenWidget.sendRefreshBroadcast(WidgetRefreshJob.this.getApplicationContext());
                    } else {
                        Log.i((String)TAG, (String)"onStartJob: trying to refresh Widget content before refresh interval have passed. Ignoring call.");
                        WidgetRefreshJob.this.jobFinished(params, false);
                    }
                } else {
                    Log.i((String)TAG, (String)"onStartJob: there is no active widgets on home screen. Ignoring call.");
                }
            }

            @Override
            public void onManagerRetrieveFailed(Throwable t) {
                WidgetRefreshJob.this.jobFinished(params, false);
            }
        });
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        Log.w((String)TAG, (String)"onStopJob: job was stopped by the system");
        return false;
    }

    private boolean didIntervalPass(long lastShownTimestamp, long minTriggerInterval, long currentTime) {
        return currentTime - lastShownTimestamp > minTriggerInterval;
    }
}

